/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class ParallelMultiInstanceActivityBehavior
extends MultiInstanceActivityBehavior {
    @Override
    protected void createInstances(ActivityExecution execution, int nrOfInstances) throws Exception {
        int i;
        ActivityImpl innerActivity = this.getInnerActivity(execution);
        this.prepareScopeExecution(execution, nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (i = 0; i < nrOfInstances; ++i) {
            ActivityExecution concurrentChild = execution.createExecution();
            concurrentChild.setConcurrent(true);
            concurrentChild.setScope(false);
            concurrentExecutions.add(concurrentChild);
        }
        for (i = nrOfInstances - 1; i >= 0; --i) {
            ActivityExecution activityExecution = (ActivityExecution)concurrentExecutions.get(i);
            this.performInstance(activityExecution, innerActivity, i);
        }
    }

    protected void prepareScopeExecution(ActivityExecution scopeExecution, int nrOfInstances) {
        this.setLoopVariable(scopeExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfInstances);
        scopeExecution.setActivity(null);
        scopeExecution.inactivate();
    }

    @Override
    public void concurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        int nrOfCompletedInstances = this.getLoopVariable(scopeExecution, "nrOfCompletedInstances") + 1;
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances") - 1;
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances);
        endedExecution.inactivate();
        endedExecution.setActivityInstanceId(null);
        scopeExecution.forceUpdate();
        if (this.completionConditionSatisfied(endedExecution) || this.allExecutionsEnded(scopeExecution, endedExecution)) {
            ArrayList<? extends PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>(((PvmExecutionImpl)scopeExecution).getNonEventScopeExecutions());
            for (ActivityExecution activityExecution : childExecutions) {
                if (activityExecution.isActive() || activityExecution.getActivity() == null) {
                    ((PvmExecutionImpl)activityExecution).deleteCascade("Multi instance completion condition satisfied.");
                    continue;
                }
                activityExecution.remove();
            }
            scopeExecution.setActivity((PvmActivity)((Object)endedExecution.getActivity().getFlowScope()));
            scopeExecution.setActive(true);
            this.leave(scopeExecution);
        }
    }

    protected boolean allExecutionsEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        int numberOfInactiveConcurrentExecutions = endedExecution.findInactiveConcurrentExecutions(endedExecution.getActivity()).size();
        int concurrentExecutions = scopeExecution.getExecutions().size();
        return this.getLocalLoopVariable(scopeExecution, "nrOfActiveInstances") <= 0 && numberOfInactiveConcurrentExecutions == concurrentExecutions;
    }

    @Override
    public void complete(ActivityExecution scopeExecution) {
    }

    @Override
    public ActivityExecution initializeScope(ActivityExecution scopeExecution) {
        this.prepareScopeExecution(scopeExecution, 1);
        ActivityExecution concurrentChild = scopeExecution.createExecution();
        concurrentChild.setConcurrent(true);
        concurrentChild.setScope(false);
        this.setLoopVariable(concurrentChild, "loopCounter", 0);
        return concurrentChild;
    }

    @Override
    public void concurrentExecutionCreated(ActivityExecution scopeExecution, ActivityExecution concurrentExecution) {
        int nrOfInstances = this.getLoopVariable(scopeExecution, "nrOfInstances");
        this.setLoopVariable(scopeExecution, "nrOfInstances", nrOfInstances + 1);
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances");
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        this.setLoopVariable(concurrentExecution, "loopCounter", nrOfInstances);
    }

    @Override
    public void concurrentExecutionDeleted(ActivityExecution scopeExecution, ActivityExecution concurrentExecution) {
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances");
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances - 1);
    }
}

