/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import java.io.InputStream;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BpmnParseException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CallableElementActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CancelBoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CancelEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CaseCallActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ClassDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CompensationEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.DmnBusinessRuleTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ErrorEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventBasedGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ExclusiveGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ExternalTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateCatchLinkEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateThrowNoneEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateThrowSignalEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MailActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ManualTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.NoneEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ParallelMultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ScriptTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SequentialMultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskDelegateExpressionActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskExpressionActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ShellActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SignalEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.TerminateEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ThrowEscalationEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.TransactionActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.bpmn.listener.ClassDelegateExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.listener.ExpressionExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.listener.ScriptExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseUtil;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParser;
import org.camunda.bpm.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.Error;
import org.camunda.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.Escalation;
import org.camunda.bpm.engine.impl.bpmn.parser.EscalationEventDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.bpmn.parser.MessageDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.SignalDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.XMLImporter;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.core.model.CallableElement;
import org.camunda.bpm.engine.impl.core.model.CallableElementParameter;
import org.camunda.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ConstantValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.NullValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.dmn.result.DecisionTableResultMapper;
import org.camunda.bpm.engine.impl.el.ElValueProvider;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.engine.impl.el.UelExpressionCondition;
import org.camunda.bpm.engine.impl.form.handler.DefaultStartFormHandler;
import org.camunda.bpm.engine.impl.form.handler.DefaultTaskFormHandler;
import org.camunda.bpm.engine.impl.form.handler.DelegateStartFormHandler;
import org.camunda.bpm.engine.impl.form.handler.DelegateTaskFormHandler;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.jobexecutor.AsyncAfterMessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.AsyncBeforeMessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.EventSubscriptionJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.MessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationType;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.camunda.bpm.engine.impl.pvm.process.HasDIBounds;
import org.camunda.bpm.engine.impl.pvm.process.Lane;
import org.camunda.bpm.engine.impl.pvm.process.LaneSet;
import org.camunda.bpm.engine.impl.pvm.process.ParticipantProcess;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptCondition;
import org.camunda.bpm.engine.impl.task.TaskDecorator;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.task.listener.ClassDelegateTaskListener;
import org.camunda.bpm.engine.impl.task.listener.DelegateExpressionTaskListener;
import org.camunda.bpm.engine.impl.task.listener.ExpressionTaskListener;
import org.camunda.bpm.engine.impl.task.listener.ScriptTaskListener;
import org.camunda.bpm.engine.impl.util.ClassDelegateUtil;
import org.camunda.bpm.engine.impl.util.DecisionTableUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.impl.util.ScriptUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.impl.util.xml.Namespace;
import org.camunda.bpm.engine.impl.util.xml.Parse;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class BpmnParse
extends Parse {
    public static final String MULTI_INSTANCE_BODY_ID_SUFFIX = "#multiInstanceBody";
    protected static final BpmnParseLogger LOG = ProcessEngineLogger.BPMN_PARSE_LOGGER;
    public static final String PROPERTYNAME_DOCUMENTATION = "documentation";
    public static final String PROPERTYNAME_INITIAL = "initial";
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";
    public static final String PROPERTYNAME_VARIABLE_DECLARATIONS = "variableDeclarations";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";
    public static final String PROPERTYNAME_MESSAGE_JOB_DECLARATION = "messageJobDeclaration";
    public static final String PROPERTYNAME_ISEXPANDED = "isExpanded";
    public static final String PROPERTYNAME_START_TIMER = "timerStart";
    public static final String PROPERTYNAME_COMPENSATION_HANDLER_ID = "compensationHandler";
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_JOB_DECLARATION = "eventJobDeclarations";
    public static final String PROPERTYNAME_TRIGGERED_BY_EVENT = "triggeredByEvent";
    public static final String PROPERTYNAME_THROWS_COMPENSATION = "throwsCompensation";
    public static final String PROPERTYNAME_CONSUMES_COMPENSATION = "consumesCompensation";
    public static final String PROPERTYNAME_JOB_PRIORITY = "jobPriority";
    @Deprecated
    public static final String PROPERTYNAME_TYPE = BpmnProperties.TYPE.getName();
    @Deprecated
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = BpmnProperties.ERROR_EVENT_DEFINITIONS.getName();
    protected static final String POTENTIAL_STARTER = "potentialStarter";
    protected static final String CANDIDATE_STARTER_USERS_EXTENSION = "candidateStarterUsers";
    protected static final String CANDIDATE_STARTER_GROUPS_EXTENSION = "candidateStarterGroups";
    protected static final String ATTRIBUTEVALUE_T_FORMAL_EXPRESSION = "http://www.omg.org/spec/BPMN/20100524/MODEL:tFormalExpression";
    public static final String PROPERTYNAME_IS_MULTI_INSTANCE = "isMultiInstance";
    public static final Namespace CAMUNDA_BPMN_EXTENSIONS_NS = new Namespace("http://camunda.org/schema/1.0/bpmn", "http://activiti.org/bpmn");
    public static final Namespace XSI_NS = new Namespace("http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace BPMN_DI_NS = new Namespace("http://www.omg.org/spec/BPMN/20100524/DI");
    public static final Namespace OMG_DI_NS = new Namespace("http://www.omg.org/spec/DD/20100524/DI");
    public static final Namespace BPMN_DC_NS = new Namespace("http://www.omg.org/spec/DD/20100524/DC");
    protected DeploymentEntity deployment;
    protected List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
    protected Map<String, Error> errors = new HashMap<String, Error>();
    protected Map<String, Escalation> escalations = new HashMap<String, Escalation>();
    protected Map<String, List<JobDeclaration<?, ?>>> jobDeclarations = new HashMap();
    protected Map<String, TransitionImpl> sequenceFlows;
    protected List<String> elementIds = new ArrayList<String>();
    protected Map<String, String> participantProcesses = new HashMap<String, String>();
    protected Map<String, MessageDefinition> messages = new HashMap<String, MessageDefinition>();
    protected Map<String, SignalDefinition> signals = new HashMap<String, SignalDefinition>();
    protected ExpressionManager expressionManager;
    protected List<BpmnParseListener> parseListeners;
    protected Map<String, XMLImporter> importers = new HashMap<String, XMLImporter>();
    protected Map<String, String> prefixs = new HashMap<String, String>();
    protected String targetNamespace;
    private Map<String, String> eventLinkTargets = new HashMap<String, String>();
    private Map<String, String> eventLinkSources = new HashMap<String, String>();
    protected static final String HUMAN_PERFORMER = "humanPerformer";
    protected static final String POTENTIAL_OWNER = "potentialOwner";
    protected static final String RESOURCE_ASSIGNMENT_EXPR = "resourceAssignmentExpression";
    protected static final String FORMAL_EXPRESSION = "formalExpression";
    protected static final String USER_PREFIX = "user(";
    protected static final String GROUP_PREFIX = "group(";
    protected static final String ASSIGNEE_EXTENSION = "assignee";
    protected static final String CANDIDATE_USERS_EXTENSION = "candidateUsers";
    protected static final String CANDIDATE_GROUPS_EXTENSION = "candidateGroups";
    protected static final String DUE_DATE_EXTENSION = "dueDate";
    protected static final String FOLLOW_UP_DATE_EXTENSION = "followUpDate";
    protected static final String PRIORITY_EXTENSION = "priority";

    public BpmnParse(BpmnParser parser) {
        super(parser);
        this.expressionManager = parser.getExpressionManager();
        this.parseListeners = parser.getParseListeners();
        this.setSchemaResource(ReflectUtil.getResourceUrlAsString("org/camunda/bpm/engine/impl/bpmn/parser/BPMN20.xsd"));
    }

    public BpmnParse deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    @Override
    public BpmnParse execute() {
        super.execute();
        try {
            this.parseRootElement();
        }
        catch (BpmnParseException e) {
            this.addError(e);
        }
        catch (Exception e) {
            LOG.parsingFailure(e);
            throw LOG.parsingProcessException(e);
        }
        finally {
            if (this.hasWarnings()) {
                this.logWarnings();
            }
            if (this.hasErrors()) {
                this.throwExceptionForErrors();
            }
        }
        return this;
    }

    protected void parseRootElement() {
        this.collectElementIds();
        this.parseDefinitionsAttributes();
        this.parseImports();
        this.parseMessages();
        this.parseSignals();
        this.parseErrors();
        this.parseEscalations();
        this.parseProcessDefinitions();
        this.parseCollaboration();
        this.parseDiagramInterchangeElements();
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseRootElement(this.rootElement, this.getProcessDefinitions());
        }
    }

    protected void collectElementIds() {
        this.rootElement.collectIds(this.elementIds);
    }

    protected void parseDefinitionsAttributes() {
        this.targetNamespace = this.rootElement.attribute("targetNamespace");
        for (String attribute : this.rootElement.attributes()) {
            if (!attribute.startsWith("xmlns:")) continue;
            String prefixValue = this.rootElement.attribute(attribute);
            String prefixName = attribute.substring(6);
            this.prefixs.put(prefixName, prefixValue);
        }
    }

    protected String resolveName(String name) {
        if (name == null) {
            return null;
        }
        int indexOfP = name.indexOf(58);
        if (indexOfP != -1) {
            String prefix = name.substring(0, indexOfP);
            String resolvedPrefix = this.prefixs.get(prefix);
            return resolvedPrefix + ":" + name.substring(indexOfP + 1);
        }
        return this.targetNamespace + ":" + name;
    }

    protected void parseImports() {
        List<Element> imports = this.rootElement.elements("import");
        for (Element theImport : imports) {
            String importType = theImport.attribute("importType");
            XMLImporter importer = this.getImporter(importType, theImport);
            if (importer == null) {
                this.addError("Could not import item of type " + importType, theImport);
                continue;
            }
            importer.importFrom(theImport, this);
        }
    }

    protected XMLImporter getImporter(String importType, Element theImport) {
        if (this.importers.containsKey(importType)) {
            return this.importers.get(importType);
        }
        if (importType.equals("http://schemas.xmlsoap.org/wsdl/")) {
            try {
                Class<?> wsdlImporterClass = Class.forName("org.camunda.bpm.engine.impl.webservice.CxfWSDLImporter", true, Thread.currentThread().getContextClassLoader());
                XMLImporter newInstance = (XMLImporter)wsdlImporterClass.newInstance();
                this.importers.put(importType, newInstance);
                return newInstance;
            }
            catch (Exception e) {
                this.addError("Could not find importer for type " + importType, theImport);
            }
        }
        return null;
    }

    public void parseMessages() {
        for (Element messageElement : this.rootElement.elements("message")) {
            String id = messageElement.attribute("id");
            String name = messageElement.attribute("name");
            MessageDefinition messageDefinition = new MessageDefinition(this.targetNamespace + ":" + id, name);
            this.messages.put(messageDefinition.getId(), messageDefinition);
        }
    }

    protected void parseSignals() {
        for (Element signalElement : this.rootElement.elements("signal")) {
            String id = signalElement.attribute("id");
            String signalName = signalElement.attribute("name");
            for (SignalDefinition signalDefinition : this.signals.values()) {
                if (!signalDefinition.getName().equals(signalName)) continue;
                this.addError("duplicate signal name '" + signalName + "'.", signalElement);
            }
            if (id == null) {
                this.addError("signal must have an id", signalElement);
                continue;
            }
            if (signalName == null) {
                this.addError("signal with id '" + id + "' has no name", signalElement);
                continue;
            }
            SignalDefinition signal = new SignalDefinition();
            signal.setId(this.targetNamespace + ":" + id);
            signal.setName(signalName);
            this.signals.put(signal.getId(), signal);
        }
    }

    public void parseErrors() {
        for (Element errorElement : this.rootElement.elements("error")) {
            Error error = new Error();
            String id = errorElement.attribute("id");
            if (id == null) {
                this.addError("'id' is mandatory on error definition", errorElement);
            }
            error.setId(id);
            String errorCode = errorElement.attribute("errorCode");
            if (errorCode != null) {
                error.setErrorCode(errorCode);
            }
            this.errors.put(id, error);
        }
    }

    protected void parseEscalations() {
        for (Element element : this.rootElement.elements("escalation")) {
            String id = element.attribute("id");
            if (id == null) {
                this.addError("escalation must have an id", element);
                continue;
            }
            Escalation escalation = this.createEscalation(id, element);
            this.escalations.put(id, escalation);
        }
    }

    protected Escalation createEscalation(String id, Element element) {
        String escalationCode;
        Escalation escalation = new Escalation(id);
        String name = element.attribute("name");
        if (name != null) {
            escalation.setName(name);
        }
        if ((escalationCode = element.attribute("escalationCode")) != null && !escalationCode.isEmpty()) {
            escalation.setEscalationCode(escalationCode);
        }
        return escalation;
    }

    public void parseProcessDefinitions() {
        for (Element processElement : this.rootElement.elements("process")) {
            boolean isExecutable = true;
            String isExecutableStr = processElement.attribute("isExecutable");
            if (isExecutableStr != null) {
                if (!Boolean.parseBoolean(isExecutableStr)) {
                    isExecutable = false;
                    LOG.ignoringNonExecutableProcess(processElement.attribute("id"));
                }
            } else {
                LOG.missingIsExecutableAttribute(processElement.attribute("id"));
            }
            if (!isExecutable) continue;
            this.processDefinitions.add(this.parseProcess(processElement));
        }
    }

    public void parseCollaboration() {
        Element collaboration = this.rootElement.element("collaboration");
        if (collaboration != null) {
            for (Element participant : collaboration.elements("participant")) {
                ProcessDefinitionEntity procDef;
                String processRef = participant.attribute("processRef");
                if (processRef == null || (procDef = this.getProcessDefinition(processRef)) == null) continue;
                ParticipantProcess participantProcess = new ParticipantProcess();
                participantProcess.setId(participant.attribute("id"));
                participantProcess.setName(participant.attribute("name"));
                procDef.setParticipantProcess(participantProcess);
                this.participantProcesses.put(participantProcess.getId(), processRef);
            }
        }
    }

    public ProcessDefinitionEntity parseProcess(Element processElement) {
        this.sequenceFlows = new HashMap<String, TransitionImpl>();
        ProcessDefinitionEntity processDefinition = new ProcessDefinitionEntity();
        processDefinition.setKey(processElement.attribute("id"));
        processDefinition.setName(processElement.attribute("name"));
        processDefinition.setCategory(this.rootElement.attribute("targetNamespace"));
        processDefinition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(processElement));
        processDefinition.setTaskDefinitions(new HashMap<String, TaskDefinition>());
        processDefinition.setDeploymentId(this.deployment.getId());
        processDefinition.setProperty(PROPERTYNAME_JOB_PRIORITY, this.parseJobPriority(processElement));
        LOG.parsingElement("process", processDefinition.getKey());
        this.parseScope(processElement, processDefinition);
        this.parseLaneSets(processElement, processDefinition);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProcess(processElement, processDefinition);
        }
        this.validateActivities(processDefinition.getActivities());
        return processDefinition;
    }

    protected void parseLaneSets(Element parentElement, ProcessDefinitionEntity processDefinition) {
        List<Element> laneSets = parentElement.elements("laneSet");
        if (laneSets != null && laneSets.size() > 0) {
            for (Element laneSetElement : laneSets) {
                LaneSet newLaneSet = new LaneSet();
                newLaneSet.setId(laneSetElement.attribute("id"));
                newLaneSet.setName(laneSetElement.attribute("name"));
                this.parseLanes(laneSetElement, newLaneSet);
                processDefinition.addLaneSet(newLaneSet);
            }
        }
    }

    protected void parseLanes(Element laneSetElement, LaneSet laneSet) {
        List<Element> lanes = laneSetElement.elements("lane");
        if (lanes != null && lanes.size() > 0) {
            for (Element laneElement : lanes) {
                Lane lane = new Lane();
                lane.setId(laneElement.attribute("id"));
                lane.setName(laneElement.attribute("name"));
                List<Element> flowNodeElements = laneElement.elements("flowNodeRef");
                if (flowNodeElements != null && flowNodeElements.size() > 0) {
                    for (Element flowNodeElement : flowNodeElements) {
                        lane.getFlowNodeIds().add(flowNodeElement.getText());
                    }
                }
                laneSet.addLane(lane);
            }
        }
    }

    public void parseScope(Element scopeElement, ScopeImpl parentScope) {
        ArrayList<Element> activityElements = new ArrayList<Element>(scopeElement.elements());
        HashMap<String, Element> intermediateCatchEvents = this.filterIntermediateCatchEvents(activityElements);
        activityElements.removeAll(intermediateCatchEvents.values());
        HashMap<String, Element> compensationHandlers = this.filterCompensationHandlers(activityElements);
        activityElements.removeAll(compensationHandlers.values());
        this.parseStartEvents(scopeElement, parentScope);
        this.parseActivities(activityElements, scopeElement, parentScope);
        this.parseIntermediateCatchEvents(scopeElement, parentScope, intermediateCatchEvents);
        this.parseEndEvents(scopeElement, parentScope);
        this.parseBoundaryEvents(scopeElement, parentScope);
        this.parseSequenceFlow(scopeElement, parentScope, compensationHandlers);
        this.parseExecutionListenersOnScope(scopeElement, parentScope);
        this.parseAssociations(scopeElement, parentScope, compensationHandlers);
        this.parseCompensationHandlers(parentScope, compensationHandlers);
        if (parentScope instanceof ProcessDefinition) {
            this.parseProcessDefinitionCustomExtensions(scopeElement, (ProcessDefinition)((Object)parentScope));
        }
    }

    protected HashMap<String, Element> filterIntermediateCatchEvents(List<Element> activityElements) {
        HashMap<String, Element> intermediateCatchEvents = new HashMap<String, Element>();
        for (Element activityElement : activityElements) {
            if (!activityElement.getTagName().equals("intermediateCatchEvent")) continue;
            intermediateCatchEvents.put(activityElement.attribute("id"), activityElement);
        }
        return intermediateCatchEvents;
    }

    protected HashMap<String, Element> filterCompensationHandlers(List<Element> activityElements) {
        HashMap<String, Element> compensationHandlers = new HashMap<String, Element>();
        for (Element activityElement : activityElements) {
            if (!this.isCompensationHandler(activityElement)) continue;
            compensationHandlers.put(activityElement.attribute("id"), activityElement);
        }
        return compensationHandlers;
    }

    protected void parseIntermediateCatchEvents(Element scopeElement, ScopeImpl parentScope, Map<String, Element> intermediateCatchEventElements) {
        for (Element intermediateCatchEventElement : intermediateCatchEventElements.values()) {
            ActivityImpl activity;
            if (parentScope.findActivity(intermediateCatchEventElement.attribute("id")) != null || (activity = this.parseIntermediateCatchEvent(intermediateCatchEventElement, parentScope, null)) == null) continue;
            this.parseActivityInputOutput(intermediateCatchEventElement, activity);
        }
        intermediateCatchEventElements.clear();
    }

    protected void parseProcessDefinitionCustomExtensions(Element scopeElement, ProcessDefinition definition) {
        this.parseStartAuthorization(scopeElement, definition);
    }

    protected void parseStartAuthorization(Element scopeElement, ProcessDefinition definition) {
        String candidateGroupsString;
        String candidateUsersString;
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)definition;
        Element extentionsElement = scopeElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> potentialStarterElements = extentionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, POTENTIAL_STARTER);
            for (Element potentialStarterElement : potentialStarterElements) {
                this.parsePotentialStarterResourceAssignment(potentialStarterElement, processDefinition);
            }
        }
        if ((candidateUsersString = scopeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_STARTER_USERS_EXTENSION)) != null) {
            List<String> candidateUsers = this.parseCommaSeparatedList(candidateUsersString);
            for (String candidateUser : candidateUsers) {
                processDefinition.addCandidateStarterUserIdExpression(this.expressionManager.createExpression(candidateUser.trim()));
            }
        }
        if ((candidateGroupsString = scopeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_STARTER_GROUPS_EXTENSION)) != null) {
            List<String> candidateGroups = this.parseCommaSeparatedList(candidateGroupsString);
            for (String candidateGroup : candidateGroups) {
                processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(candidateGroup.trim()));
            }
        }
    }

    protected void parsePotentialStarterResourceAssignment(Element performerElement, ProcessDefinitionEntity processDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            List<String> assignmentExpressions = this.parseCommaSeparatedList(feElement.getText());
            for (String assignmentExpression : assignmentExpressions) {
                if ((assignmentExpression = assignmentExpression.trim()).startsWith(USER_PREFIX)) {
                    String userAssignementId = this.getAssignmentId(assignmentExpression, USER_PREFIX);
                    processDefinition.addCandidateStarterUserIdExpression(this.expressionManager.createExpression(userAssignementId));
                    continue;
                }
                if (assignmentExpression.startsWith(GROUP_PREFIX)) {
                    String groupAssignementId = this.getAssignmentId(assignmentExpression, GROUP_PREFIX);
                    processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(groupAssignementId));
                    continue;
                }
                processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(assignmentExpression));
            }
        }
    }

    protected void parseAssociations(Element scopeElement, ScopeImpl parentScope, Map<String, Element> compensationHandlers) {
        for (Element associationElement : scopeElement.elements("association")) {
            String targetRef;
            String sourceRef = associationElement.attribute("sourceRef");
            if (sourceRef == null) {
                this.addError("association element missing attribute 'sourceRef'", associationElement);
            }
            if ((targetRef = associationElement.attribute("targetRef")) == null) {
                this.addError("association element missing attribute 'targetRef'", associationElement);
            }
            ActivityImpl sourceActivity = parentScope.findActivity(sourceRef);
            ActivityImpl targetActivity = parentScope.findActivity(targetRef);
            if (sourceActivity == null && !this.elementIds.contains(sourceRef)) {
                this.addError("Invalid reference sourceRef '" + sourceRef + "' of association element ", associationElement);
                continue;
            }
            if (targetActivity == null && !this.elementIds.contains(targetRef)) {
                this.addError("Invalid reference targetRef '" + targetRef + "' of association element ", associationElement);
                continue;
            }
            if (sourceActivity == null || !sourceActivity.getProperty("type").equals("compensationBoundaryCatch")) continue;
            if (targetActivity == null && compensationHandlers.containsKey(targetRef)) {
                targetActivity = this.parseCompensationHandlerForCompensationBoundaryEvent(parentScope, sourceActivity, targetRef, compensationHandlers);
                compensationHandlers.remove(targetActivity.getId());
            }
            if (targetActivity == null) continue;
            this.parseAssociationOfCompensationBoundaryEvent(associationElement, sourceActivity, targetActivity);
        }
    }

    protected ActivityImpl parseCompensationHandlerForCompensationBoundaryEvent(ScopeImpl parentScope, ActivityImpl sourceActivity, String targetRef, Map<String, Element> compensationHandlers) {
        Element compensationHandler = compensationHandlers.get(targetRef);
        ActivityImpl eventScope = (ActivityImpl)sourceActivity.getEventScope();
        if (eventScope.isMultiInstance()) {
            ScopeImpl miBody = eventScope.getFlowScope();
            return this.parseActivity(compensationHandler, null, miBody);
        }
        return this.parseActivity(compensationHandler, null, parentScope);
    }

    protected void parseAssociationOfCompensationBoundaryEvent(Element associationElement, ActivityImpl sourceActivity, ActivityImpl targetActivity) {
        if (!targetActivity.isCompensationHandler()) {
            this.addError("compensation boundary catch must be connected to element with isForCompensation=true", associationElement);
        } else {
            ActivityImpl compensatedActivity = (ActivityImpl)sourceActivity.getEventScope();
            ActivityImpl compensationHandler = compensatedActivity.findCompensationHandler();
            if (compensationHandler != null && compensationHandler.isSubProcessScope()) {
                this.addError("compensation boundary event and event subprocess with compensation start event are not supported on the same scope", associationElement);
            } else {
                compensatedActivity.setProperty(PROPERTYNAME_COMPENSATION_HANDLER_ID, targetActivity.getId());
            }
        }
    }

    protected void parseCompensationHandlers(ScopeImpl parentScope, Map<String, Element> compensationHandlers) {
        for (Element compensationHandler : new HashSet<Element>(compensationHandlers.values())) {
            this.parseActivity(compensationHandler, null, parentScope);
        }
        compensationHandlers.clear();
    }

    public void parseStartEvents(Element parentElement, ScopeImpl scope) {
        List<Element> startEventElements = parentElement.elements("startEvent");
        ArrayList<ActivityImpl> startEventActivities = new ArrayList<ActivityImpl>();
        for (Element startEventElement : startEventElements) {
            ActivityImpl startEventActivity = this.createActivityOnScope(startEventElement, scope);
            this.parseAsynchronousContinuationForActivity(startEventElement, startEventActivity);
            if (scope instanceof ProcessDefinitionEntity) {
                this.parseProcessDefinitionStartEvent(startEventActivity, startEventElement, parentElement, scope);
                startEventActivities.add(startEventActivity);
            } else {
                this.parseScopeStartEvent(startEventActivity, startEventElement, parentElement, (ActivityImpl)scope);
            }
            this.ensureNoIoMappingDefined(startEventElement);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseStartEvent(startEventElement, scope, startEventActivity);
            }
            this.parseExecutionListenersOnScope(startEventElement, startEventActivity);
        }
        if (scope instanceof ProcessDefinitionEntity) {
            this.selectInitial(startEventActivities, (ProcessDefinitionEntity)scope, parentElement);
            this.parseStartFormHandlers(startEventElements, (ProcessDefinitionEntity)scope);
        }
    }

    protected void selectInitial(List<ActivityImpl> startEventActivities, ProcessDefinitionEntity processDefinition, Element parentElement) {
        ActivityImpl initial = null;
        List<String> exclusiveStartEventTypes = Arrays.asList("startEvent", "startTimerEvent");
        for (ActivityImpl activityImpl : startEventActivities) {
            if (!exclusiveStartEventTypes.contains(activityImpl.getProperty("type"))) continue;
            if (initial == null) {
                initial = activityImpl;
                continue;
            }
            this.addError("multiple none start events or timer start events not supported on process definition", parentElement);
        }
        if (initial == null && startEventActivities.size() == 1) {
            initial = startEventActivities.get(0);
        }
        processDefinition.setInitial(initial);
    }

    protected void parseProcessDefinitionStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ScopeImpl scope) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)scope;
        String initiatorVariableName = startEventElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "initiator");
        if (initiatorVariableName != null) {
            processDefinition.setProperty(PROPERTYNAME_INITIATOR_VARIABLE_NAME, initiatorVariableName);
        }
        startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
        Element timerEventDefinition = startEventElement.element("timerEventDefinition");
        Element messageEventDefinition = startEventElement.element("messageEventDefinition");
        Element signalEventDefinition = startEventElement.element("signalEventDefinition");
        if (timerEventDefinition != null) {
            this.parseTimerStartEventDefinition(timerEventDefinition, startEventActivity, processDefinition);
        } else if (messageEventDefinition != null) {
            startEventActivity.setProperty("type", "messageStartEvent");
            EventSubscriptionDeclaration messageDefinition = this.parseMessageEventDefinition(messageEventDefinition);
            messageDefinition.setActivityId(startEventActivity.getId());
            messageDefinition.setStartEvent(true);
            this.addEventSubscriptionDeclaration(messageDefinition, processDefinition, startEventElement);
        } else if (signalEventDefinition != null) {
            startEventActivity.setProperty("type", "signalStartEvent");
            startEventActivity.setEventScope(scope);
            this.parseSignalCatchEventDefinition(signalEventDefinition, startEventActivity, true);
        }
    }

    protected void parseStartFormHandlers(List<Element> startEventElements, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() != null) {
            for (Element startEventElement : startEventElements) {
                if (!startEventElement.attribute("id").equals(processDefinition.getInitial().getId())) continue;
                String startFormHandlerClassName = startEventElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formHandlerClass");
                StartFormHandler startFormHandler = startFormHandlerClassName != null ? (StartFormHandler)ReflectUtil.instantiate(startFormHandlerClassName) : new DefaultStartFormHandler();
                startFormHandler.parseConfiguration(startEventElement, this.deployment, processDefinition, this);
                processDefinition.setStartFormHandler(new DelegateStartFormHandler(startFormHandler, this.deployment));
            }
        }
    }

    protected void parseScopeStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ActivityImpl scopeActivity) {
        boolean isTriggeredByEvent;
        if (scopeActivity.getProperty(PROPERTYNAME_INITIAL) == null) {
            scopeActivity.setProperty(PROPERTYNAME_INITIAL, startEventActivity);
        } else {
            this.addError("multiple start events not supported for subprocess", startEventElement);
        }
        Element errorEventDefinition = startEventElement.element("errorEventDefinition");
        Element messageEventDefinition = startEventElement.element("messageEventDefinition");
        Element signalEventDefinition = startEventElement.element("signalEventDefinition");
        Element timerEventDefinition = startEventElement.element("timerEventDefinition");
        Element compensateEventDefinition = startEventElement.element("compensateEventDefinition");
        Element escalationEventDefinitionElement = startEventElement.element("escalationEventDefinition");
        Object triggeredByEvent = scopeActivity.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT);
        boolean bl = isTriggeredByEvent = triggeredByEvent != null && (Boolean)triggeredByEvent != false;
        if (isTriggeredByEvent) {
            startEventActivity.setActivityBehavior(new EventSubProcessStartEventActivityBehavior());
            String isInterruptingAttr = startEventElement.attribute("isInterrupting");
            boolean isInterrupting = isInterruptingAttr.equalsIgnoreCase("true");
            if (isInterrupting) {
                scopeActivity.setActivityStartBehavior(ActivityStartBehavior.INTERRUPT_EVENT_SCOPE);
            } else {
                scopeActivity.setActivityStartBehavior(ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE);
            }
            startEventActivity.setEventScope(scopeActivity.getFlowScope());
            if (errorEventDefinition != null) {
                if (!isInterrupting) {
                    this.addError("error start event of event subprocess must be interrupting", startEventElement);
                }
                this.parseErrorStartEventDefinition(errorEventDefinition, startEventActivity);
            } else if (messageEventDefinition != null) {
                startEventActivity.setProperty("type", "messageStartEvent");
                EventSubscriptionDeclaration eventSubscriptionDeclaration = this.parseMessageEventDefinition(messageEventDefinition);
                this.parseEventDefinitionForSubprocess(eventSubscriptionDeclaration, startEventActivity, messageEventDefinition);
            } else if (signalEventDefinition != null) {
                startEventActivity.setProperty("type", "signalStartEvent");
                EventSubscriptionDeclaration eventSubscriptionDeclaration = this.parseSignalEventDefinition(signalEventDefinition);
                this.parseEventDefinitionForSubprocess(eventSubscriptionDeclaration, startEventActivity, signalEventDefinition);
            } else if (timerEventDefinition != null) {
                this.parseTimerStartEventDefinitionForEventSubprocess(timerEventDefinition, startEventActivity, isInterrupting);
            } else if (compensateEventDefinition != null) {
                this.parseCompensationEventSubprocess(startEventActivity, startEventElement, scopeActivity, compensateEventDefinition);
            } else if (escalationEventDefinitionElement != null) {
                startEventActivity.getProperties().set(BpmnProperties.TYPE, "escalationStartEvent");
                EscalationEventDefinition escalationEventDefinition = this.createEscalationEventDefinitionForEscalationHandler(escalationEventDefinitionElement, scopeActivity, isInterrupting);
                this.addEscalationEventDefinition(startEventActivity.getEventScope(), escalationEventDefinition, escalationEventDefinitionElement);
            } else {
                this.addError("start event of event subprocess must be of type 'error', 'message', 'timer', 'signal', 'compensation' or 'escalation'", startEventElement);
            }
        } else {
            Element conditionalEventDefinition = startEventElement.element("conditionalEventDefinition");
            if (conditionalEventDefinition != null) {
                this.addError("conditionalEventDefinition is not allowed on start event within a subprocess", conditionalEventDefinition);
            }
            if (timerEventDefinition != null) {
                this.addError("timerEventDefinition is not allowed on start event within a subprocess", timerEventDefinition);
            }
            if (escalationEventDefinitionElement != null) {
                this.addError("escalationEventDefinition is not allowed on start event within a subprocess", escalationEventDefinitionElement);
            }
            if (compensateEventDefinition != null) {
                this.addError("compensateEventDefinition is not allowed on start event within a subprocess", compensateEventDefinition);
            }
            if (errorEventDefinition != null) {
                this.addError("errorEventDefinition only allowed on start event if subprocess is an event subprocess", errorEventDefinition);
            }
            if (messageEventDefinition != null) {
                this.addError("messageEventDefinition only allowed on start event if subprocess is an event subprocess", messageEventDefinition);
            }
            if (signalEventDefinition != null) {
                this.addError("signalEventDefintion only allowed on start event if subprocess is an event subprocess", messageEventDefinition);
            }
            startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
        }
    }

    protected void parseCompensationEventSubprocess(ActivityImpl startEventActivity, Element startEventElement, ActivityImpl scopeActivity, Element compensateEventDefinition) {
        ScopeImpl subprocess;
        ActivityImpl compensationHandler;
        startEventActivity.setProperty("type", "compensationStartEvent");
        scopeActivity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, Boolean.TRUE);
        if (scopeActivity.getFlowScope() instanceof ProcessDefinitionEntity) {
            this.addError("event subprocess with compensation start event is only supported for embedded subprocess (since throwing compensation through a call activity-induced process hierarchy is not supported)", startEventElement);
        }
        if ((compensationHandler = ((ActivityImpl)(subprocess = scopeActivity.getFlowScope())).findCompensationHandler()) == null) {
            subprocess.setProperty(PROPERTYNAME_COMPENSATION_HANDLER_ID, scopeActivity.getActivityId());
        } else if (compensationHandler.isSubProcessScope()) {
            this.addError("multiple event subprocesses with compensation start event are not supported on the same scope", startEventElement);
        } else {
            this.addError("compensation boundary event and event subprocess with compensation start event are not supported on the same scope", startEventElement);
        }
        this.validateCatchCompensateEventDefinition(compensateEventDefinition);
    }

    protected void parseErrorStartEventDefinition(Element errorEventDefinition, ActivityImpl startEventActivity) {
        startEventActivity.setProperty("type", "errorStartEvent");
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        String eventSubProcessActivity = startEventActivity.getFlowScope().getId();
        ErrorEventDefinition definition = new ErrorEventDefinition(eventSubProcessActivity);
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            String errorCode = error == null ? errorRef : error.getErrorCode();
            definition.setErrorCode(errorCode);
        }
        definition.setPrecedence(10);
        this.setErrorCodeVariableOnErrorEventDefinition(errorEventDefinition, definition);
        this.addErrorEventDefinition(definition, startEventActivity.getEventScope());
    }

    protected void setErrorCodeVariableOnErrorEventDefinition(Element errorEventDefinition, ErrorEventDefinition definition) {
        String errorCodeVar = errorEventDefinition.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "errorCodeVariable");
        if (errorCodeVar != null) {
            definition.setErrorCodeVariable(errorCodeVar);
        }
    }

    protected EventSubscriptionDeclaration parseMessageEventDefinition(Element messageEventDefinition) {
        MessageDefinition messageDefinition;
        String messageRef = messageEventDefinition.attribute("messageRef");
        if (messageRef == null) {
            this.addError("attribute 'messageRef' is required", messageEventDefinition);
        }
        if ((messageDefinition = this.messages.get(this.resolveName(messageRef))) == null) {
            this.addError("Invalid 'messageRef': no message with id '" + messageRef + "' found.", messageEventDefinition);
        }
        return new EventSubscriptionDeclaration(messageDefinition.getName(), "message");
    }

    protected void addEventSubscriptionDeclaration(EventSubscriptionDeclaration subscription, ScopeImpl scope, Element element) {
        ArrayList<EventSubscriptionDeclaration> eventDefinitions;
        if (subscription.getEventType().equals("message") && (subscription.getEventName() == null || "".equalsIgnoreCase(subscription.getEventName().trim()))) {
            this.addError("Cannot have a message event subscription with an empty or missing name", element);
        }
        if ((eventDefinitions = (ArrayList<EventSubscriptionDeclaration>)scope.getProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION)) == null) {
            eventDefinitions = new ArrayList<EventSubscriptionDeclaration>();
            scope.setProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION, eventDefinitions);
        } else {
            if (this.hasMultipleMessageEventDefinitionsWithSameName(subscription, eventDefinitions)) {
                this.addError("Cannot have more than one message event subscription with name '" + subscription.getEventName() + "' for scope '" + scope.getId() + "'", element);
            }
            if (this.hasMultipleSignalEventDefinitionsWithSameName(subscription, eventDefinitions)) {
                this.addError("Cannot have more than one signal event subscription with name '" + subscription.getEventName() + "' for scope '" + scope.getId() + "'", element);
            }
        }
        eventDefinitions.add(subscription);
    }

    protected boolean hasMultipleMessageEventDefinitionsWithSameName(EventSubscriptionDeclaration subscription, List<EventSubscriptionDeclaration> eventDefinitions) {
        return this.hasMultipleEventDefinitionsWithSameName(subscription, eventDefinitions, "message");
    }

    protected boolean hasMultipleSignalEventDefinitionsWithSameName(EventSubscriptionDeclaration subscription, List<EventSubscriptionDeclaration> eventDefinitions) {
        return this.hasMultipleEventDefinitionsWithSameName(subscription, eventDefinitions, "signal");
    }

    protected boolean hasMultipleEventDefinitionsWithSameName(EventSubscriptionDeclaration subscription, List<EventSubscriptionDeclaration> eventDefinitions, String eventType) {
        if (subscription.getEventType().equals(eventType)) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals(eventType) || !eventDefinition.getEventName().equals(subscription.getEventName()) || eventDefinition.isStartEvent() != subscription.isStartEvent()) continue;
                return true;
            }
        }
        return false;
    }

    protected void addEventSubscriptionJobDeclaration(EventSubscriptionJobDeclaration jobDeclaration, ActivityImpl activity, Element element) {
        ArrayList<EventSubscriptionJobDeclaration> jobDeclarationsForActivity = (ArrayList<EventSubscriptionJobDeclaration>)activity.getProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_JOB_DECLARATION);
        if (jobDeclarationsForActivity == null) {
            jobDeclarationsForActivity = new ArrayList<EventSubscriptionJobDeclaration>();
            activity.setProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_JOB_DECLARATION, jobDeclarationsForActivity);
        }
        jobDeclarationsForActivity.add(jobDeclaration);
    }

    public void parseActivities(List<Element> activityElements, Element parentElement, ScopeImpl scopeElement) {
        for (Element activityElement : activityElements) {
            this.parseActivity(activityElement, parentElement, scopeElement);
        }
    }

    protected ActivityImpl parseActivity(Element activityElement, Element parentElement, ScopeImpl scopeElement) {
        ActivityImpl activity = null;
        boolean isMultiInstance = false;
        ScopeImpl miBody = this.parseMultiInstanceLoopCharacteristics(activityElement, scopeElement);
        if (miBody != null) {
            scopeElement = miBody;
            isMultiInstance = true;
        }
        if (activityElement.getTagName().equals("exclusiveGateway")) {
            activity = this.parseExclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("inclusiveGateway")) {
            activity = this.parseInclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("parallelGateway")) {
            activity = this.parseParallelGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("scriptTask")) {
            activity = this.parseScriptTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("serviceTask")) {
            activity = this.parseServiceTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("businessRuleTask")) {
            activity = this.parseBusinessRuleTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("task")) {
            activity = this.parseTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("manualTask")) {
            activity = this.parseManualTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("userTask")) {
            activity = this.parseUserTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("sendTask")) {
            activity = this.parseSendTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("receiveTask")) {
            activity = this.parseReceiveTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("subProcess")) {
            activity = this.parseSubProcess(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("callActivity")) {
            activity = this.parseCallActivity(activityElement, scopeElement, isMultiInstance);
        } else if (activityElement.getTagName().equals("intermediateThrowEvent")) {
            activity = this.parseIntermediateThrowEvent(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("eventBasedGateway")) {
            activity = this.parseEventBasedGateway(activityElement, parentElement, scopeElement);
        } else if (activityElement.getTagName().equals("transaction")) {
            activity = this.parseTransaction(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("adHocSubProcess") || activityElement.getTagName().equals("complexGateway")) {
            this.addWarning("Ignoring unsupported activity type", activityElement);
        }
        if (isMultiInstance) {
            activity.setProperty(PROPERTYNAME_IS_MULTI_INSTANCE, true);
        }
        if (activity != null) {
            activity.setName(activityElement.attribute("name"));
            this.parseActivityInputOutput(activityElement, activity);
        }
        return activity;
    }

    public void validateActivities(List<ActivityImpl> activities) {
        for (ActivityImpl activity : activities) {
            this.validateActivity(activity);
            if (activity.getActivities().size() <= 0) continue;
            this.validateActivities(activity.getActivities());
        }
    }

    protected void validateActivity(ActivityImpl activity) {
        if (activity.getActivityBehavior() instanceof ExclusiveGatewayActivityBehavior) {
            this.validateExclusiveGateway(activity);
        }
        this.validateOutgoingFlows(activity);
    }

    protected void validateOutgoingFlows(ActivityImpl activity) {
        if (activity.isAsyncAfter()) {
            for (PvmTransition transition : activity.getOutgoingTransitions()) {
                if (transition.getId() != null) continue;
                this.addError("Sequence flow with sourceRef='" + activity.getId() + "' must have an id, activity with id '" + activity.getId() + "' uses 'asyncAfter'.", null);
            }
        }
    }

    public void validateExclusiveGateway(ActivityImpl activity) {
        if (activity.getOutgoingTransitions().size() == 0) {
            this.addError("Exclusive Gateway '" + activity.getId() + "' has no outgoing sequence flows.", null);
        } else if (activity.getOutgoingTransitions().size() == 1) {
            PvmTransition flow = activity.getOutgoingTransitions().get(0);
            Condition condition = (Condition)flow.getProperty(PROPERTYNAME_CONDITION);
            if (condition != null) {
                this.addError("Exclusive Gateway '" + activity.getId() + "' has only one outgoing sequence flow ('" + flow.getId() + "'). This is not allowed to have a condition.", null);
            }
        } else {
            String defaultSequenceFlow = (String)activity.getProperty("default");
            boolean hasDefaultFlow = defaultSequenceFlow != null && defaultSequenceFlow.length() > 0;
            ArrayList<PvmTransition> flowsWithoutCondition = new ArrayList<PvmTransition>();
            for (PvmTransition flow : activity.getOutgoingTransitions()) {
                boolean hasConditon;
                Condition condition = (Condition)flow.getProperty(PROPERTYNAME_CONDITION);
                boolean isDefaultFlow = flow.getId() != null && flow.getId().equals(defaultSequenceFlow);
                boolean bl = hasConditon = condition != null;
                if (!hasConditon && !isDefaultFlow) {
                    flowsWithoutCondition.add(flow);
                }
                if (!hasConditon || !isDefaultFlow) continue;
                this.addError("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' which is the default flow but has a condition too.", null);
            }
            if (hasDefaultFlow || flowsWithoutCondition.size() > 1) {
                for (PvmTransition flow : flowsWithoutCondition) {
                    this.addError("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' without condition which is not the default flow.", null);
                }
            } else if (flowsWithoutCondition.size() == 1) {
                PvmTransition flow = (PvmTransition)flowsWithoutCondition.get(0);
                this.addWarning("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' without condition which is not the default flow. We assume it to be the default flow, but it is bad modeling practice, better set the default flow in your gateway.", null);
            }
        }
    }

    public ActivityImpl parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scopeElement, ActivityImpl eventBasedGateway) {
        ActivityImpl nestedActivity = this.createActivityOnScope(intermediateEventElement, scopeElement);
        Element timerEventDefinition = intermediateEventElement.element("timerEventDefinition");
        Element signalEventDefinition = intermediateEventElement.element("signalEventDefinition");
        Element messageEventDefinition = intermediateEventElement.element("messageEventDefinition");
        Element linkEventDefinitionElement = intermediateEventElement.element("linkEventDefinition");
        IntermediateCatchEventActivityBehavior defaultCatchBehaviour = new IntermediateCatchEventActivityBehavior(eventBasedGateway != null);
        this.parseAsynchronousContinuationForActivity(intermediateEventElement, nestedActivity);
        if (eventBasedGateway != null) {
            nestedActivity.setEventScope(eventBasedGateway);
            nestedActivity.setActivityStartBehavior(ActivityStartBehavior.CANCEL_EVENT_SCOPE);
        } else {
            nestedActivity.setEventScope(nestedActivity);
            nestedActivity.setScope(true);
        }
        if (timerEventDefinition != null) {
            nestedActivity.setActivityBehavior(defaultCatchBehaviour);
            this.parseIntermediateTimerEventDefinition(timerEventDefinition, nestedActivity);
        } else if (signalEventDefinition != null) {
            nestedActivity.setActivityBehavior(defaultCatchBehaviour);
            this.parseIntermediateSignalEventDefinition(signalEventDefinition, nestedActivity);
        } else if (messageEventDefinition != null) {
            nestedActivity.setActivityBehavior(defaultCatchBehaviour);
            this.parseIntermediateMessageEventDefinition(messageEventDefinition, nestedActivity);
        } else if (linkEventDefinitionElement != null) {
            if (eventBasedGateway != null) {
                this.addError("IntermediateCatchLinkEvent is not allowed after an EventBasedGateway.", intermediateEventElement);
            }
            nestedActivity.setActivityBehavior(new IntermediateCatchLinkEventActivityBehavior());
            this.parseIntermediateLinkEventCatchBehavior(intermediateEventElement, nestedActivity, linkEventDefinitionElement);
        } else {
            this.addError("Unsupported intermediate catch event type", intermediateEventElement);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateCatchEvent(intermediateEventElement, scopeElement, nestedActivity);
        }
        this.parseExecutionListenersOnScope(intermediateEventElement, nestedActivity);
        return nestedActivity;
    }

    protected void parseIntermediateLinkEventCatchBehavior(Element intermediateEventElement, ActivityImpl activity, Element linkEventDefinitionElement) {
        activity.setProperty("type", "intermediateLinkCatch");
        String linkName = linkEventDefinitionElement.attribute("name");
        String elementName = intermediateEventElement.attribute("name");
        String elementId = intermediateEventElement.attribute("id");
        if (this.eventLinkTargets.containsKey(linkName)) {
            this.addError("Multiple Intermediate Catch Events with the same link event name ('" + linkName + "') are not allowed.", intermediateEventElement);
        } else {
            if (!linkName.equals(elementName)) {
                this.addWarning("Link Event named '" + elementName + "' containes link event definition with name '" + linkName + "' - it is recommended to use the same name for both.", intermediateEventElement);
            }
            this.eventLinkTargets.put(linkName, elementId);
        }
    }

    protected void parseIntermediateMessageEventDefinition(Element messageEventDefinition, ActivityImpl nestedActivity) {
        nestedActivity.setProperty("type", "intermediateMessageCatch");
        EventSubscriptionDeclaration messageDefinition = this.parseMessageEventDefinition(messageEventDefinition);
        messageDefinition.setActivityId(nestedActivity.getId());
        this.addEventSubscriptionDeclaration(messageDefinition, nestedActivity.getEventScope(), messageEventDefinition);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateMessageCatchEventDefinition(messageEventDefinition, nestedActivity);
        }
    }

    public ActivityImpl parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scopeElement) {
        Element signalEventDefinitionElement = intermediateEventElement.element("signalEventDefinition");
        Element compensateEventDefinitionElement = intermediateEventElement.element("compensateEventDefinition");
        Element linkEventDefinitionElement = intermediateEventElement.element("linkEventDefinition");
        Element messageEventDefinitionElement = intermediateEventElement.element("messageEventDefinition");
        Element escalationEventDefinition = intermediateEventElement.element("escalationEventDefinition");
        if (linkEventDefinitionElement != null) {
            String linkName = linkEventDefinitionElement.attribute("name");
            String elementId = intermediateEventElement.attribute("id");
            this.eventLinkSources.put(elementId, linkName);
            return null;
        }
        ActivityImpl nestedActivityImpl = this.createActivityOnScope(intermediateEventElement, scopeElement);
        ActivityBehavior activityBehavior = null;
        this.parseAsynchronousContinuationForActivity(intermediateEventElement, nestedActivityImpl);
        if (signalEventDefinitionElement != null) {
            nestedActivityImpl.setProperty("type", "intermediateSignalThrow");
            EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(signalEventDefinitionElement);
            activityBehavior = new IntermediateThrowSignalEventActivityBehavior(signalDefinition);
        } else if (compensateEventDefinitionElement != null) {
            nestedActivityImpl.setProperty("type", "intermediateCompensationThrowEvent");
            CompensateEventDefinition compensateEventDefinition = this.parseThrowCompensateEventDefinition(compensateEventDefinitionElement, scopeElement);
            activityBehavior = new CompensationEventActivityBehavior(compensateEventDefinition);
            nestedActivityImpl.setProperty(PROPERTYNAME_THROWS_COMPENSATION, true);
            nestedActivityImpl.setScope(true);
        } else if (messageEventDefinitionElement != null) {
            if (this.isServiceTaskLike(messageEventDefinitionElement)) {
                nestedActivityImpl.setProperty("type", "intermediateMessageThrowEvent");
                activityBehavior = this.parseServiceTaskLike("intermediateMessageThrowEvent", messageEventDefinitionElement, scopeElement).getActivityBehavior();
            } else {
                nestedActivityImpl.setProperty("type", "intermediateNoneThrowEvent");
                activityBehavior = new IntermediateThrowNoneEventActivityBehavior();
            }
        } else if (escalationEventDefinition != null) {
            nestedActivityImpl.getProperties().set(BpmnProperties.TYPE, "intermediateEscalationThrowEvent");
            Escalation escalation = this.findEscalationForEscalationEventDefinition(escalationEventDefinition);
            if (escalation != null && escalation.getEscalationCode() == null) {
                this.addError("throwing escalation event must have an 'escalationCode'", escalationEventDefinition);
            }
            activityBehavior = new ThrowEscalationEventActivityBehavior(escalation);
        } else {
            nestedActivityImpl.setProperty("type", "intermediateNoneThrowEvent");
            activityBehavior = new IntermediateThrowNoneEventActivityBehavior();
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateThrowEvent(intermediateEventElement, scopeElement, nestedActivityImpl);
        }
        nestedActivityImpl.setActivityBehavior(activityBehavior);
        this.parseExecutionListenersOnScope(intermediateEventElement, nestedActivityImpl);
        return nestedActivityImpl;
    }

    protected CompensateEventDefinition parseThrowCompensateEventDefinition(Element compensateEventDefinitionElement, ScopeImpl scopeElement) {
        String activityRef = compensateEventDefinitionElement.attribute("activityRef");
        boolean waitForCompletion = "true".equals(compensateEventDefinitionElement.attribute("waitForCompletion", "true"));
        if (activityRef != null && scopeElement.findActivityAtLevelOfSubprocess(activityRef) == null) {
            Boolean isTriggeredByEvent = (Boolean)scopeElement.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT);
            String type = (String)scopeElement.getProperty(PROPERTYNAME_TYPE);
            if (Boolean.TRUE == isTriggeredByEvent && "subProcess".equals(type)) {
                scopeElement = scopeElement.getFlowScope();
            }
            if (scopeElement.findActivityAtLevelOfSubprocess(activityRef) == null) {
                this.addError("Invalid attribute value for 'activityRef': no activity with id '" + activityRef + "' in scope '" + scopeElement.getId() + "'", compensateEventDefinitionElement);
            }
        }
        CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
        compensateEventDefinition.setActivityRef(activityRef);
        compensateEventDefinition.setWaitForCompletion(waitForCompletion);
        if (!waitForCompletion) {
            this.addWarning("Unsupported attribute value for 'waitForCompletion': 'waitForCompletion=false' is not supported. Compensation event will wait for compensation to join.", compensateEventDefinitionElement);
        }
        return compensateEventDefinition;
    }

    protected void validateCatchCompensateEventDefinition(Element compensateEventDefinitionElement) {
        String waitForCompletion;
        String activityRef = compensateEventDefinitionElement.attribute("activityRef");
        if (activityRef != null) {
            this.addWarning("attribute 'activityRef' is not supported on catching compensation event. attribute will be ignored", compensateEventDefinitionElement);
        }
        if ((waitForCompletion = compensateEventDefinitionElement.attribute("waitForCompletion")) != null) {
            this.addWarning("attribute 'waitForCompletion' is not supported on catching compensation event. attribute will be ignored", compensateEventDefinitionElement);
        }
    }

    protected void parseBoundaryCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl activity) {
        activity.setProperty("type", "compensationBoundaryCatch");
        ScopeImpl hostActivity = activity.getEventScope();
        for (ActivityImpl sibling : activity.getFlowScope().getActivities()) {
            if (!sibling.getProperty("type").equals("compensationBoundaryCatch") || !sibling.getEventScope().equals(hostActivity) || sibling == activity) continue;
            this.addError("multiple boundary events with compensateEventDefinition not supported on same activity", compensateEventDefinition);
        }
        this.validateCatchCompensateEventDefinition(compensateEventDefinition);
    }

    protected ActivityBehavior parseBoundaryCancelEventDefinition(Element cancelEventDefinition, ActivityImpl activity) {
        activity.setProperty("type", "cancelBoundaryCatch");
        LegacyBehavior.parseCancelBoundaryEvent(activity);
        ActivityImpl transaction = (ActivityImpl)activity.getEventScope();
        if (transaction.getActivityBehavior() != null && transaction.getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
            transaction = transaction.getActivities().get(0);
        }
        if (!"transaction".equals(transaction.getProperty("type"))) {
            this.addError("boundary event with cancelEventDefinition only supported on transaction subprocesses", cancelEventDefinition);
        }
        for (ActivityImpl sibling : activity.getFlowScope().getActivities()) {
            if (!"cancelBoundaryCatch".equals(sibling.getProperty("type")) || sibling == activity || sibling.getEventScope() != transaction) continue;
            this.addError("multiple boundary events with cancelEventDefinition not supported on same transaction subprocess", cancelEventDefinition);
        }
        for (ActivityImpl childActivity : transaction.getActivities()) {
            ActivityBehavior activityBehavior = childActivity.getActivityBehavior();
            if (activityBehavior == null || !(activityBehavior instanceof CancelEndEventActivityBehavior)) continue;
            ((CancelEndEventActivityBehavior)activityBehavior).setCancelBoundaryEvent(activity);
        }
        return new CancelBoundaryEventActivityBehavior();
    }

    public ScopeImpl parseMultiInstanceLoopCharacteristics(Element activityElement, ScopeImpl scope) {
        Element inputDataItem;
        String elementVariable;
        String loopDataInputRefText;
        Element loopDataInputRef;
        String collection;
        Element completionCondition;
        Element miLoopCharacteristics = activityElement.element("multiInstanceLoopCharacteristics");
        if (miLoopCharacteristics == null) {
            return null;
        }
        String id = activityElement.attribute("id");
        LOG.parsingElement("mi body for activity", id);
        id = BpmnParse.getIdForMiBody(id);
        ActivityImpl miBodyScope = scope.createActivity(id);
        miBodyScope.setProperty(PROPERTYNAME_TYPE, "multiInstanceBody");
        miBodyScope.setScope(true);
        boolean isSequential = this.parseBooleanAttribute(miLoopCharacteristics.attribute("isSequential"), false);
        MultiInstanceActivityBehavior behavior = null;
        behavior = isSequential ? new SequentialMultiInstanceActivityBehavior() : new ParallelMultiInstanceActivityBehavior();
        miBodyScope.setActivityBehavior(behavior);
        Element loopCardinality = miLoopCharacteristics.element("loopCardinality");
        if (loopCardinality != null) {
            String loopCardinalityText = loopCardinality.getText();
            if (loopCardinalityText == null || "".equals(loopCardinalityText)) {
                this.addError("loopCardinality must be defined for a multiInstanceLoopCharacteristics definition ", miLoopCharacteristics);
            }
            behavior.setLoopCardinalityExpression(this.expressionManager.createExpression(loopCardinalityText));
        }
        if ((completionCondition = miLoopCharacteristics.element("completionCondition")) != null) {
            String completionConditionText = completionCondition.getText();
            behavior.setCompletionConditionExpression(this.expressionManager.createExpression(completionConditionText));
        }
        if ((collection = miLoopCharacteristics.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "collection")) != null) {
            if (collection.contains("{")) {
                behavior.setCollectionExpression(this.expressionManager.createExpression(collection));
            } else {
                behavior.setCollectionVariable(collection);
            }
        }
        if ((loopDataInputRef = miLoopCharacteristics.element("loopDataInputRef")) != null && (loopDataInputRefText = loopDataInputRef.getText()) != null) {
            if (loopDataInputRefText.contains("{")) {
                behavior.setCollectionExpression(this.expressionManager.createExpression(loopDataInputRefText));
            } else {
                behavior.setCollectionVariable(loopDataInputRefText);
            }
        }
        if ((elementVariable = miLoopCharacteristics.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "elementVariable")) != null) {
            behavior.setCollectionElementVariable(elementVariable);
        }
        if ((inputDataItem = miLoopCharacteristics.element("inputDataItem")) != null) {
            String inputDataItemName = inputDataItem.attribute("name");
            behavior.setCollectionElementVariable(inputDataItemName);
        }
        if (behavior.getLoopCardinalityExpression() == null && behavior.getCollectionExpression() == null && behavior.getCollectionVariable() == null) {
            this.addError("Either loopCardinality or loopDataInputRef/activiti:collection must been set", miLoopCharacteristics);
        }
        if (behavior.getCollectionExpression() == null && behavior.getCollectionVariable() == null && behavior.getCollectionElementVariable() != null) {
            this.addError("LoopDataInputRef/activiti:collection must be set when using inputDataItem or activiti:elementVariable", miLoopCharacteristics);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseMultiInstanceLoopCharacteristics(activityElement, miLoopCharacteristics, miBodyScope);
        }
        return miBodyScope;
    }

    public static String getIdForMiBody(String id) {
        return id + MULTI_INSTANCE_BODY_ID_SUFFIX;
    }

    public ActivityImpl createActivityOnScope(Element activityElement, ScopeImpl scopeElement) {
        String id = activityElement.attribute("id");
        LOG.parsingElement("activity", id);
        ActivityImpl activity = scopeElement.createActivity(id);
        activity.setProperty("name", activityElement.attribute("name"));
        activity.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(activityElement));
        activity.setProperty("default", activityElement.attribute("default"));
        activity.setProperty("type", activityElement.getTagName());
        activity.setProperty("line", activityElement.getLine());
        activity.setProperty(PROPERTYNAME_JOB_PRIORITY, this.parseJobPriority(activityElement));
        if (this.isCompensationHandler(activityElement)) {
            activity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, true);
        }
        return activity;
    }

    public String parseDocumentation(Element element) {
        List<Element> docElements = element.elements(PROPERTYNAME_DOCUMENTATION);
        ArrayList<String> docStrings = new ArrayList<String>();
        for (Element e : docElements) {
            docStrings.add(e.getText());
        }
        return BpmnParse.parseDocumentation(docStrings);
    }

    public static String parseDocumentation(List<String> docStrings) {
        if (docStrings.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String e : docStrings) {
            if (builder.length() != 0) {
                builder.append("\n\n");
            }
            builder.append(e.trim());
        }
        return builder.toString();
    }

    protected boolean isCompensationHandler(Element activityElement) {
        String isForCompensation = activityElement.attribute(PROPERTYNAME_IS_FOR_COMPENSATION);
        return isForCompensation != null && isForCompensation.equalsIgnoreCase("true");
    }

    public ActivityImpl parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(exclusiveGwElement, scope);
        activity.setActivityBehavior(new ExclusiveGatewayActivityBehavior());
        this.parseAsynchronousContinuationForActivity(exclusiveGwElement, activity);
        this.parseExecutionListenersOnScope(exclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseExclusiveGateway(exclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(inclusiveGwElement, scope);
        activity.setActivityBehavior(new InclusiveGatewayActivityBehavior());
        this.parseAsynchronousContinuationForActivity(inclusiveGwElement, activity);
        this.parseExecutionListenersOnScope(inclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseInclusiveGateway(inclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseEventBasedGateway(Element eventBasedGwElement, Element parentElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(eventBasedGwElement, scope);
        activity.setActivityBehavior(new EventBasedGatewayActivityBehavior());
        activity.setScope(true);
        this.parseAsynchronousContinuationForActivity(eventBasedGwElement, activity);
        if (activity.isAsyncAfter()) {
            this.addError("'asyncAfter' not supported for " + eventBasedGwElement.getTagName() + " elements.", eventBasedGwElement);
        }
        this.parseExecutionListenersOnScope(eventBasedGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseEventBasedGateway(eventBasedGwElement, scope, activity);
        }
        List<Element> sequenceFlows = parentElement.elements("sequenceFlow");
        HashMap<String, Element> siblingsMap = new HashMap<String, Element>();
        List<Element> siblings = parentElement.elements();
        for (Element sibling : siblings) {
            siblingsMap.put(sibling.attribute("id"), sibling);
        }
        for (Element sequenceFlow : sequenceFlows) {
            Element sibling;
            String sourceRef = sequenceFlow.attribute("sourceRef");
            String targetRef = sequenceFlow.attribute("targetRef");
            if (!activity.getId().equals(sourceRef) || (sibling = (Element)siblingsMap.get(targetRef)) == null) continue;
            if (sibling.getTagName().equals("intermediateCatchEvent")) {
                this.parseIntermediateCatchEvent(sibling, scope, activity);
                continue;
            }
            this.addError("Event based gateway can only be connected to elements of type intermediateCatchEvent", sibling);
        }
        return activity;
    }

    public ActivityImpl parseParallelGateway(Element parallelGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(parallelGwElement, scope);
        activity.setActivityBehavior(new ParallelGatewayActivityBehavior());
        this.parseAsynchronousContinuationForActivity(parallelGwElement, activity);
        this.parseExecutionListenersOnScope(parallelGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseParallelGateway(parallelGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseScriptTask(Element scriptTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(scriptTaskElement, scope);
        ScriptTaskActivityBehavior activityBehavior = this.parseScriptTaskElement(scriptTaskElement);
        if (activityBehavior != null) {
            this.parseAsynchronousContinuationForActivity(scriptTaskElement, activity);
            activity.setActivityBehavior(activityBehavior);
            this.parseExecutionListenersOnScope(scriptTaskElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseScriptTask(scriptTaskElement, scope, activity);
            }
        }
        return activity;
    }

    protected ScriptTaskActivityBehavior parseScriptTaskElement(Element scriptTaskElement) {
        String language = scriptTaskElement.attribute("scriptFormat");
        if (language == null) {
            language = "juel";
        }
        String resultVariableName = this.parseResultVariable(scriptTaskElement);
        String scriptSource = null;
        Element scriptElement = scriptTaskElement.element("script");
        if (scriptElement != null) {
            scriptSource = scriptElement.getText();
        }
        String scriptResource = scriptTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "resource");
        try {
            ExecutableScript script = ScriptUtil.getScript(language, scriptSource, scriptResource, this.expressionManager);
            return new ScriptTaskActivityBehavior(script, resultVariableName);
        }
        catch (ProcessEngineException e) {
            this.addError("Unable to process ScriptTask: " + e.getMessage(), scriptElement);
            return null;
        }
    }

    protected String parseResultVariable(Element element) {
        String resultVariableName = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "resultVariable");
        if (resultVariableName == null) {
            resultVariableName = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "resultVariableName");
        }
        return resultVariableName;
    }

    public ActivityImpl parseServiceTask(Element serviceTaskElement, ScopeImpl scope) {
        return this.parseServiceTaskLike("serviceTask", serviceTaskElement, scope);
    }

    public ActivityImpl parseServiceTaskLike(String elementName, Element serviceTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(serviceTaskElement, scope);
        String type = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "type");
        String className = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "class");
        String expression = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "expression");
        String delegateExpression = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "delegateExpression");
        String resultVariableName = this.parseResultVariable(serviceTaskElement);
        this.parseAsynchronousContinuationForActivity(serviceTaskElement, activity);
        if (type != null) {
            if (type.equalsIgnoreCase("mail")) {
                this.parseEmailServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else if (type.equalsIgnoreCase("shell")) {
                this.parseShellServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else if (this.isExternalTaskType(type)) {
                this.parseExternalServiceTask(activity, serviceTaskElement);
            } else {
                this.addError("Invalid usage of type attribute on " + elementName + ": '" + type + "'", serviceTaskElement);
            }
        } else if (className != null && className.trim().length() > 0) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for " + elementName + " elements using 'class'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ClassDelegateActivityBehavior(className, this.parseFieldDeclarations(serviceTaskElement)));
        } else if (delegateExpression != null) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for " + elementName + " elements using 'delegateExpression'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ServiceTaskDelegateExpressionActivityBehavior(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(serviceTaskElement)));
        } else if (expression != null && expression.trim().length() > 0) {
            activity.setActivityBehavior(new ServiceTaskExpressionActivityBehavior(this.expressionManager.createExpression(expression), resultVariableName));
        }
        this.parseExecutionListenersOnScope(serviceTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseServiceTask(serviceTaskElement, scope, activity);
        }
        if (activity.getActivityBehavior() == null) {
            this.addError("One of the attributes 'class', 'delegateExpression', 'type', or 'expression' is mandatory on " + elementName + ".", serviceTaskElement);
        }
        return activity;
    }

    public ActivityImpl parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope) {
        String decisionRef = businessRuleTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "decisionRef");
        if (decisionRef != null) {
            return this.parseDmnBusinessRuleTask(businessRuleTaskElement, scope);
        }
        return this.parseServiceTaskLike("businessRuleTask", businessRuleTaskElement, scope);
    }

    protected ActivityImpl parseDmnBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(businessRuleTaskElement, scope);
        activity.setScope(true);
        this.parseAsynchronousContinuationForActivity(businessRuleTaskElement, activity);
        String decisionRef = businessRuleTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "decisionRef");
        BaseCallableElement callableElement = new BaseCallableElement();
        callableElement.setDeploymentId(this.deployment.getId());
        ParameterValueProvider definitionKeyProvider = this.createParameterValueProvider(decisionRef, this.expressionManager);
        callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
        this.parseBinding(businessRuleTaskElement, activity, callableElement, "decisionRefBinding");
        this.parseVersion(businessRuleTaskElement, activity, callableElement, "decisionRefBinding", "decisionRefVersion");
        String resultVariable = this.parseResultVariable(businessRuleTaskElement);
        DecisionTableResultMapper decisionTableResultMapper = this.parseDecisionResultMapper(businessRuleTaskElement);
        DmnBusinessRuleTaskActivityBehavior behavior = new DmnBusinessRuleTaskActivityBehavior(callableElement, resultVariable, decisionTableResultMapper);
        activity.setActivityBehavior(behavior);
        this.parseExecutionListenersOnScope(businessRuleTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBusinessRuleTask(businessRuleTaskElement, scope, activity);
        }
        return activity;
    }

    protected DecisionTableResultMapper parseDecisionResultMapper(Element businessRuleTaskElement) {
        String decisionResultMapper = businessRuleTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "mapDecisionResult");
        DecisionTableResultMapper mapper = DecisionTableUtil.getDecisionTableResultMapperForName(decisionResultMapper);
        if (mapper == null) {
            this.addError("No decision result mapper found for name '" + decisionResultMapper + "'. Supported mappers are 'singleEntry', 'singleResult', 'collectEntries' and 'resultList'.", businessRuleTaskElement);
        }
        return mapper;
    }

    protected void parseAsynchronousContinuationForActivity(Element activityElement, ActivityImpl activity) {
        ActivityImpl parentFlowScopeActivity = activity.getParentFlowScopeActivity();
        if (parentFlowScopeActivity != null && parentFlowScopeActivity.getActivityBehavior() instanceof MultiInstanceActivityBehavior && !activity.isCompensationHandler()) {
            this.parseAsynchronousContinuation(activityElement, parentFlowScopeActivity);
            Element miLoopCharacteristics = activityElement.element("multiInstanceLoopCharacteristics");
            this.parseAsynchronousContinuation(miLoopCharacteristics, activity);
        } else {
            this.parseAsynchronousContinuation(activityElement, activity);
        }
    }

    protected void parseAsynchronousContinuation(Element element, ActivityImpl activity) {
        MessageJobDeclaration messageJobDeclaration;
        boolean isAsyncBefore = this.isAsyncBefore(element);
        boolean isAsyncAfter = this.isAsyncAfter(element);
        boolean exclusive = this.isExclusive(element);
        activity.setAsyncBefore(isAsyncBefore);
        activity.setAsyncAfter(isAsyncAfter);
        if (isAsyncBefore) {
            messageJobDeclaration = new AsyncBeforeMessageJobDeclaration();
            messageJobDeclaration.setExclusive(exclusive);
            messageJobDeclaration.setActivity(activity);
            messageJobDeclaration.setJobPriorityProvider((ParameterValueProvider)activity.getProperty(PROPERTYNAME_JOB_PRIORITY));
            this.addMessageJobDeclarationToActivity(messageJobDeclaration, activity);
            this.addJobDeclarationToProcessDefinition(messageJobDeclaration, activity.getProcessDefinition());
        }
        if (isAsyncAfter) {
            messageJobDeclaration = new AsyncAfterMessageJobDeclaration();
            messageJobDeclaration.setExclusive(exclusive);
            messageJobDeclaration.setActivity(activity);
            messageJobDeclaration.setJobPriorityProvider((ParameterValueProvider)activity.getProperty(PROPERTYNAME_JOB_PRIORITY));
            this.addMessageJobDeclarationToActivity(messageJobDeclaration, activity);
            this.addJobDeclarationToProcessDefinition(messageJobDeclaration, activity.getProcessDefinition());
        }
    }

    protected ParameterValueProvider parseJobPriority(Element element) {
        String priorityAttribute = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_JOB_PRIORITY);
        if (priorityAttribute == null) {
            return null;
        }
        Object value = priorityAttribute;
        if (!StringUtil.isExpression(priorityAttribute)) {
            try {
                value = Integer.parseInt(priorityAttribute);
            }
            catch (NumberFormatException e) {
                this.addError("Value '" + priorityAttribute + "' for attribute 'jobPriority' is not a valid number", element);
            }
        }
        return this.createParameterValueProvider(value, this.expressionManager);
    }

    protected void addMessageJobDeclarationToActivity(MessageJobDeclaration messageJobDeclaration, ActivityImpl activity) {
        ArrayList<MessageJobDeclaration> messageJobDeclarations = (ArrayList<MessageJobDeclaration>)activity.getProperty(PROPERTYNAME_MESSAGE_JOB_DECLARATION);
        if (messageJobDeclarations == null) {
            messageJobDeclarations = new ArrayList<MessageJobDeclaration>();
            activity.setProperty(PROPERTYNAME_MESSAGE_JOB_DECLARATION, messageJobDeclarations);
        }
        messageJobDeclarations.add(messageJobDeclaration);
    }

    protected void addJobDeclarationToProcessDefinition(JobDeclaration<?, ?> jobDeclaration, ProcessDefinitionImpl processDefinition) {
        ProcessDefinition definition = (ProcessDefinition)((Object)processDefinition);
        String key = definition.getKey();
        List<JobDeclaration<?, ?>> containingJobDeclarations = this.jobDeclarations.get(key);
        if (containingJobDeclarations == null) {
            containingJobDeclarations = new ArrayList();
            this.jobDeclarations.put(key, containingJobDeclarations);
        }
        containingJobDeclarations.add(jobDeclaration);
    }

    public ActivityImpl parseSendTask(Element sendTaskElement, ScopeImpl scope) {
        if (this.isServiceTaskLike(sendTaskElement)) {
            return this.parseServiceTaskLike("sendTask", sendTaskElement, scope);
        }
        ActivityImpl activity = this.createActivityOnScope(sendTaskElement, scope);
        this.parseAsynchronousContinuationForActivity(sendTaskElement, activity);
        String type = sendTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "type");
        if (type != null) {
            if (type.equalsIgnoreCase("mail")) {
                this.parseEmailServiceTask(activity, sendTaskElement, this.parseFieldDeclarations(sendTaskElement));
            } else {
                this.addError("Invalid usage of type attribute: '" + type + "'", sendTaskElement);
            }
        } else {
            this.addError("One of the attributes 'class', 'delegateExpression', 'type', or 'expression' is mandatory on sendTask.", sendTaskElement);
        }
        this.parseExecutionListenersOnScope(sendTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseSendTask(sendTaskElement, scope, activity);
        }
        return activity;
    }

    protected void parseEmailServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForEmail(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((MailActivityBehavior)ClassDelegateUtil.instantiateDelegate(MailActivityBehavior.class, fieldDeclarations));
    }

    protected void parseShellServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForShell(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((ActivityBehavior)ClassDelegateUtil.instantiateDelegate(ShellActivityBehavior.class, fieldDeclarations));
    }

    protected void parseExternalServiceTask(ActivityImpl activity, Element serviceTaskElement) {
        activity.setScope(true);
        String topicName = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "topic");
        if (topicName == null) {
            this.addError("External tasks must specify a 'topic' attribute in the camunda namespace", serviceTaskElement);
        }
        activity.setActivityBehavior(new ExternalTaskActivityBehavior(topicName));
    }

    protected void validateFieldDeclarationsForEmail(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            if (fieldDeclaration.getName().equals("to")) {
                toDefined = true;
            }
            if (fieldDeclaration.getName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (!fieldDeclaration.getName().equals("text")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError("No recipient is defined on the mail activity", serviceTaskElement);
        }
        if (!textOrHtmlDefined) {
            this.addError("Text or html field should be provided", serviceTaskElement);
        }
    }

    protected void validateFieldDeclarationsForShell(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean shellCommandDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            String fieldName = fieldDeclaration.getName();
            FixedValue fieldFixedValue = (FixedValue)fieldDeclaration.getValue();
            String fieldValue = fieldFixedValue.getExpressionText();
            shellCommandDefined |= fieldName.equals("command");
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals("true") || fieldValue.toLowerCase().equals("false")) continue;
            this.addError("undefined value for shell " + fieldName + " parameter :" + fieldValue.toString(), serviceTaskElement);
        }
        if (!shellCommandDefined) {
            this.addError("No shell command is defined on the shell activity", serviceTaskElement);
        }
    }

    public List<FieldDeclaration> parseFieldDeclarations(Element element) {
        List<Element> fieldDeclarationElements;
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        Element elementWithFieldInjections = element.element("extensionElements");
        if (elementWithFieldInjections == null) {
            elementWithFieldInjections = element;
        }
        if ((fieldDeclarationElements = elementWithFieldInjections.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "field")) != null && !fieldDeclarationElements.isEmpty()) {
            for (Element fieldDeclarationElement : fieldDeclarationElements) {
                FieldDeclaration fieldDeclaration = this.parseFieldDeclaration(element, fieldDeclarationElement);
                if (fieldDeclaration == null) continue;
                fieldDeclarations.add(fieldDeclaration);
            }
        }
        return fieldDeclarations;
    }

    protected FieldDeclaration parseFieldDeclaration(Element serviceTaskElement, Element fieldDeclarationElement) {
        String fieldName = fieldDeclarationElement.attribute("name");
        FieldDeclaration fieldDeclaration = this.parseStringFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        if (fieldDeclaration == null) {
            fieldDeclaration = this.parseExpressionFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        }
        if (fieldDeclaration == null) {
            this.addError("One of the following is mandatory on a field declaration: one of attributes stringValue|expression or one of child elements string|expression", serviceTaskElement);
        }
        return fieldDeclaration;
    }

    protected FieldDeclaration parseStringFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String fieldValue = this.getStringValueFromAttributeOrElement("stringValue", "string", fieldDeclarationElement);
            if (fieldValue != null) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), new FixedValue(fieldValue));
            }
        }
        catch (ProcessEngineException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple string field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected FieldDeclaration parseExpressionFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String expression = this.getStringValueFromAttributeOrElement("expression", "expression", fieldDeclarationElement);
            if (expression != null && expression.trim().length() > 0) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), this.expressionManager.createExpression(expression));
            }
        }
        catch (ProcessEngineException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple expression field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected String getStringValueFromAttributeOrElement(String attributeName, String elementName, Element element) {
        String value = null;
        String attributeValue = element.attribute(attributeName);
        Element childElement = element.elementNS(CAMUNDA_BPMN_EXTENSIONS_NS, elementName);
        String stringElementText = null;
        if (attributeValue != null && childElement != null) {
            this.addError("Can't use attribute '" + attributeName + "' and element '" + elementName + "' together, only use one", element);
        } else if (childElement != null) {
            stringElementText = childElement.getText();
            if (stringElementText == null || stringElementText.length() == 0) {
                this.addError("No valid value found in attribute '" + attributeName + "' nor element '" + elementName + "'", element);
            } else {
                value = stringElementText;
            }
        } else if (attributeValue != null && attributeValue.length() > 0) {
            value = attributeValue;
        }
        return value;
    }

    public ActivityImpl parseTask(Element taskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(taskElement, scope);
        activity.setActivityBehavior(new TaskActivityBehavior());
        this.parseAsynchronousContinuationForActivity(taskElement, activity);
        this.parseExecutionListenersOnScope(taskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTask(taskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseManualTask(Element manualTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(manualTaskElement, scope);
        activity.setActivityBehavior(new ManualTaskActivityBehavior());
        this.parseAsynchronousContinuationForActivity(manualTaskElement, activity);
        this.parseExecutionListenersOnScope(manualTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseManualTask(manualTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseReceiveTask(Element receiveTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(receiveTaskElement, scope);
        activity.setActivityBehavior(new ReceiveTaskActivityBehavior());
        this.parseAsynchronousContinuationForActivity(receiveTaskElement, activity);
        this.parseExecutionListenersOnScope(receiveTaskElement, activity);
        if (receiveTaskElement.attribute("messageRef") != null) {
            activity.setScope(true);
            EventSubscriptionDeclaration declaration = this.parseMessageEventDefinition(receiveTaskElement);
            declaration.setActivityId(activity.getActivityId());
            declaration.setEventScopeActivityId(activity.getActivityId());
            this.addEventSubscriptionDeclaration(declaration, activity, receiveTaskElement);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseReceiveTask(receiveTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseUserTask(Element userTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(userTaskElement, scope);
        this.parseAsynchronousContinuationForActivity(userTaskElement, activity);
        TaskDefinition taskDefinition = this.parseTaskDefinition(userTaskElement, activity.getId(), (ProcessDefinitionEntity)scope.getProcessDefinition());
        TaskDecorator taskDecorator = new TaskDecorator(taskDefinition, this.expressionManager);
        UserTaskActivityBehavior userTaskActivity = new UserTaskActivityBehavior(taskDecorator);
        activity.setActivityBehavior(userTaskActivity);
        this.parseProperties(userTaskElement, activity);
        this.parseExecutionListenersOnScope(userTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseUserTask(userTaskElement, scope, activity);
        }
        return activity;
    }

    public TaskDefinition parseTaskDefinition(Element taskElement, String taskDefinitionKey, ProcessDefinitionEntity processDefinition) {
        String descriptionStr;
        String name;
        String taskFormHandlerClassName = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formHandlerClass");
        TaskFormHandler taskFormHandler = taskFormHandlerClassName != null ? (TaskFormHandler)ReflectUtil.instantiate(taskFormHandlerClassName) : new DefaultTaskFormHandler();
        taskFormHandler.parseConfiguration(taskElement, this.deployment, processDefinition, this);
        TaskDefinition taskDefinition = new TaskDefinition(new DelegateTaskFormHandler(taskFormHandler, this.deployment));
        taskDefinition.setKey(taskDefinitionKey);
        processDefinition.getTaskDefinitions().put(taskDefinitionKey, taskDefinition);
        String formKeyAttribute = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formKey");
        if (formKeyAttribute != null) {
            taskDefinition.setFormKey(this.expressionManager.createExpression(formKeyAttribute));
        }
        if ((name = taskElement.attribute("name")) != null) {
            taskDefinition.setNameExpression(this.expressionManager.createExpression(name));
        }
        if ((descriptionStr = this.parseDocumentation(taskElement)) != null) {
            taskDefinition.setDescriptionExpression(this.expressionManager.createExpression(descriptionStr));
        }
        this.parseHumanPerformer(taskElement, taskDefinition);
        this.parsePotentialOwner(taskElement, taskDefinition);
        this.parseUserTaskCustomExtensions(taskElement, taskDefinition);
        return taskDefinition;
    }

    protected void parseHumanPerformer(Element taskElement, TaskDefinition taskDefinition) {
        Element humanPerformerElement;
        List<Element> humanPerformerElements = taskElement.elements(HUMAN_PERFORMER);
        if (humanPerformerElements.size() > 1) {
            this.addError("Invalid task definition: multiple humanPerformer sub elements defined for " + taskDefinition.getNameExpression(), taskElement);
        } else if (humanPerformerElements.size() == 1 && (humanPerformerElement = humanPerformerElements.get(0)) != null) {
            this.parseHumanPerformerResourceAssignment(humanPerformerElement, taskDefinition);
        }
    }

    protected void parsePotentialOwner(Element taskElement, TaskDefinition taskDefinition) {
        List<Element> potentialOwnerElements = taskElement.elements(POTENTIAL_OWNER);
        for (Element potentialOwnerElement : potentialOwnerElements) {
            this.parsePotentialOwnerResourceAssignment(potentialOwnerElement, taskDefinition);
        }
    }

    protected void parseHumanPerformerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(feElement.getText()));
        }
    }

    protected void parsePotentialOwnerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            List<String> assignmentExpressions = this.parseCommaSeparatedList(feElement.getText());
            for (String assignmentExpression : assignmentExpressions) {
                if ((assignmentExpression = assignmentExpression.trim()).startsWith(USER_PREFIX)) {
                    String userAssignementId = this.getAssignmentId(assignmentExpression, USER_PREFIX);
                    taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(userAssignementId));
                    continue;
                }
                if (assignmentExpression.startsWith(GROUP_PREFIX)) {
                    String groupAssignementId = this.getAssignmentId(assignmentExpression, GROUP_PREFIX);
                    taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(groupAssignementId));
                    continue;
                }
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(assignmentExpression));
            }
        }
    }

    protected String getAssignmentId(String expression, String prefix) {
        return expression.substring(prefix.length(), expression.length() - 1).trim();
    }

    protected void parseUserTaskCustomExtensions(Element taskElement, TaskDefinition taskDefinition) {
        String priorityExpression;
        String followUpDateExpression;
        String candidateGroupsString;
        String candidateUsersString;
        String assignee = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, ASSIGNEE_EXTENSION);
        if (assignee != null) {
            if (taskDefinition.getAssigneeExpression() == null) {
                taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(assignee));
            } else {
                this.addError("Invalid usage: duplicate assignee declaration for task " + taskDefinition.getNameExpression(), taskElement);
            }
        }
        if ((candidateUsersString = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_USERS_EXTENSION)) != null) {
            List<String> candidateUsers = this.parseCommaSeparatedList(candidateUsersString);
            for (String candidateUser : candidateUsers) {
                taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(candidateUser.trim()));
            }
        }
        if ((candidateGroupsString = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_GROUPS_EXTENSION)) != null) {
            List<String> candidateGroups = this.parseCommaSeparatedList(candidateGroupsString);
            for (String candidateGroup : candidateGroups) {
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(candidateGroup.trim()));
            }
        }
        this.parseTaskListeners(taskElement, taskDefinition);
        String dueDateExpression = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, DUE_DATE_EXTENSION);
        if (dueDateExpression != null) {
            taskDefinition.setDueDateExpression(this.expressionManager.createExpression(dueDateExpression));
        }
        if ((followUpDateExpression = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, FOLLOW_UP_DATE_EXTENSION)) != null) {
            taskDefinition.setFollowUpDateExpression(this.expressionManager.createExpression(followUpDateExpression));
        }
        if ((priorityExpression = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PRIORITY_EXTENSION)) != null) {
            taskDefinition.setPriorityExpression(this.expressionManager.createExpression(priorityExpression));
        }
    }

    protected List<String> parseCommaSeparatedList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null && !"".equals(s)) {
            StringCharacterIterator iterator = new StringCharacterIterator(s);
            char c = iterator.first();
            StringBuilder strb = new StringBuilder();
            boolean insideExpression = false;
            while (c != '\uffff') {
                if (c == '{' || c == '$') {
                    insideExpression = true;
                } else if (c == '}') {
                    insideExpression = false;
                } else if (c == ',' && !insideExpression) {
                    result.add(strb.toString().trim());
                    strb.delete(0, strb.length());
                }
                if (c != ',' || insideExpression) {
                    strb.append(c);
                }
                c = iterator.next();
            }
            if (strb.length() > 0) {
                result.add(strb.toString().trim());
            }
        }
        return result;
    }

    protected void parseTaskListeners(Element userTaskElement, TaskDefinition taskDefinition) {
        Element extentionsElement = userTaskElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> taskListenerElements = extentionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "taskListener");
            for (Element taskListenerElement : taskListenerElements) {
                String eventName = taskListenerElement.attribute("event");
                if (eventName != null) {
                    if ("create".equals(eventName) || "assignment".equals(eventName) || "complete".equals(eventName) || "delete".equals(eventName)) {
                        TaskListener taskListener = this.parseTaskListener(taskListenerElement);
                        taskDefinition.addTaskListener(eventName, taskListener);
                        continue;
                    }
                    this.addError("Attribute 'event' must be one of {create|assignment|complete|delete}", userTaskElement);
                    continue;
                }
                this.addError("Attribute 'event' is mandatory on taskListener", userTaskElement);
            }
        }
    }

    protected TaskListener parseTaskListener(Element taskListenerElement) {
        TaskListener taskListener = null;
        String className = taskListenerElement.attribute("class");
        String expression = taskListenerElement.attribute("expression");
        String delegateExpression = taskListenerElement.attribute("delegateExpression");
        Element scriptElement = taskListenerElement.elementNS(CAMUNDA_BPMN_EXTENSIONS_NS, "script");
        if (className != null) {
            taskListener = new ClassDelegateTaskListener(className, this.parseFieldDeclarations(taskListenerElement));
        } else if (expression != null) {
            taskListener = new ExpressionTaskListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            taskListener = new DelegateExpressionTaskListener(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(taskListenerElement));
        } else if (scriptElement != null) {
            try {
                ExecutableScript executableScript = BpmnParseUtil.parseCamundaScript(scriptElement);
                if (executableScript != null) {
                    taskListener = new ScriptTaskListener(executableScript);
                }
            }
            catch (BpmnParseException e) {
                this.addError(e);
            }
        } else {
            this.addError("Element 'class', 'expression', 'delegateExpression' or 'script' is mandatory on taskListener", taskListenerElement);
        }
        return taskListener;
    }

    public void parseEndEvents(Element parentElement, ScopeImpl scope) {
        for (Element endEventElement : parentElement.elements("endEvent")) {
            ActivityImpl activity = this.createActivityOnScope(endEventElement, scope);
            Element errorEventDefinition = endEventElement.element("errorEventDefinition");
            Element cancelEventDefinition = endEventElement.element("cancelEventDefinition");
            Element terminateEventDefinition = endEventElement.element("terminateEventDefinition");
            Element messageEventDefinitionElement = endEventElement.element("messageEventDefinition");
            Element signalEventDefinition = endEventElement.element("signalEventDefinition");
            Element compensateEventDefinitionElement = endEventElement.element("compensateEventDefinition");
            Element escalationEventDefinition = endEventElement.element("escalationEventDefinition");
            if (errorEventDefinition != null) {
                String errorRef = errorEventDefinition.attribute("errorRef");
                if (errorRef == null || "".equals(errorRef)) {
                    this.addError("'errorRef' attribute is mandatory on error end event", errorEventDefinition);
                } else {
                    Error error = this.errors.get(errorRef);
                    if (error != null && (error.getErrorCode() == null || "".equals(error.getErrorCode()))) {
                        this.addError("'errorCode' is mandatory on errors referenced by throwing error event definitions, but the error '" + error.getId() + "' does not define one.", errorEventDefinition);
                    }
                    activity.setProperty("type", "errorEndEvent");
                    activity.setActivityBehavior(new ErrorEndEventActivityBehavior(error != null ? error.getErrorCode() : errorRef));
                }
            } else if (cancelEventDefinition != null) {
                if (scope.getProperty("type") == null || !scope.getProperty("type").equals("transaction")) {
                    this.addError("end event with cancelEventDefinition only supported inside transaction subprocess", cancelEventDefinition);
                } else {
                    activity.setProperty("type", "cancelEndEvent");
                    activity.setActivityBehavior(new CancelEndEventActivityBehavior());
                    activity.setActivityStartBehavior(ActivityStartBehavior.INTERRUPT_FLOW_SCOPE);
                    activity.setProperty(PROPERTYNAME_THROWS_COMPENSATION, true);
                    activity.setScope(true);
                }
            } else if (terminateEventDefinition != null) {
                activity.setProperty("type", "terminateEndEvent");
                activity.setActivityBehavior(new TerminateEndEventActivityBehavior());
                activity.setActivityStartBehavior(ActivityStartBehavior.INTERRUPT_FLOW_SCOPE);
            } else if (messageEventDefinitionElement != null) {
                if (this.isServiceTaskLike(messageEventDefinitionElement)) {
                    activity.setProperty("type", "messageEndEvent");
                    activity.setActivityBehavior(this.parseServiceTaskLike("messageEndEvent", messageEventDefinitionElement, scope).getActivityBehavior());
                } else {
                    activity.setActivityBehavior(new IntermediateThrowNoneEventActivityBehavior());
                }
            } else if (signalEventDefinition != null) {
                activity.setProperty("type", "signalEndEvent");
                EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(signalEventDefinition);
                activity.setActivityBehavior(new SignalEndEventActivityBehavior(signalDefinition));
            } else if (compensateEventDefinitionElement != null) {
                activity.setProperty("type", "compensationEndEvent");
                CompensateEventDefinition compensateEventDefinition = this.parseThrowCompensateEventDefinition(compensateEventDefinitionElement, scope);
                activity.setActivityBehavior(new CompensationEventActivityBehavior(compensateEventDefinition));
                activity.setProperty(PROPERTYNAME_THROWS_COMPENSATION, true);
                activity.setScope(true);
            } else if (escalationEventDefinition != null) {
                activity.getProperties().set(BpmnProperties.TYPE, "escalationEndEvent");
                Escalation escalation = this.findEscalationForEscalationEventDefinition(escalationEventDefinition);
                if (escalation != null && escalation.getEscalationCode() == null) {
                    this.addError("escalation end event must have an 'escalationCode'", escalationEventDefinition);
                }
                activity.setActivityBehavior(new ThrowEscalationEventActivityBehavior(escalation));
            } else {
                activity.setProperty("type", "noneEndEvent");
                activity.setActivityBehavior(new NoneEndEventActivityBehavior());
            }
            if (activity != null) {
                this.parseActivityInputOutput(endEventElement, activity);
            }
            this.parseAsynchronousContinuationForActivity(endEventElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseEndEvent(endEventElement, scope, activity);
            }
            this.parseExecutionListenersOnScope(endEventElement, activity);
        }
    }

    public void parseBoundaryEvents(Element parentElement, ScopeImpl flowScope) {
        for (Element boundaryEventElement : parentElement.elements("boundaryEvent")) {
            String attachedToRef = boundaryEventElement.attribute("attachedToRef");
            if (attachedToRef == null || attachedToRef.equals("")) {
                this.addError("AttachedToRef is required when using a timerEventDefinition", boundaryEventElement);
            }
            String id = boundaryEventElement.attribute("id");
            LOG.parsingElement("boundary event", id);
            Element timerEventDefinition = boundaryEventElement.element("timerEventDefinition");
            Element errorEventDefinition = boundaryEventElement.element("errorEventDefinition");
            Element signalEventDefinition = boundaryEventElement.element("signalEventDefinition");
            Element cancelEventDefinition = boundaryEventElement.element("cancelEventDefinition");
            Element compensateEventDefinition = boundaryEventElement.element("compensateEventDefinition");
            Element messageEventDefinition = boundaryEventElement.element("messageEventDefinition");
            Element escalationEventDefinition = boundaryEventElement.element("escalationEventDefinition");
            ActivityImpl boundaryEventActivity = this.createActivityOnScope(boundaryEventElement, flowScope);
            ActivityImpl attachedActivity = flowScope.findActivityAtLevelOfSubprocess(attachedToRef);
            if (attachedActivity == null) {
                this.addError("Invalid reference in boundary event. Make sure that the referenced activity is defined in the same scope as the boundary event", boundaryEventElement);
            }
            if (compensateEventDefinition == null) {
                ActivityImpl multiInstanceScope = this.getMultiInstanceScope(attachedActivity);
                if (multiInstanceScope != null) {
                    boundaryEventActivity.setEventScope(multiInstanceScope);
                } else {
                    attachedActivity.setScope(true);
                    boundaryEventActivity.setEventScope(attachedActivity);
                }
            } else {
                boundaryEventActivity.setEventScope(attachedActivity);
            }
            String cancelActivityAttr = boundaryEventElement.attribute("cancelActivity", "true");
            boolean isCancelActivity = Boolean.valueOf(cancelActivityAttr);
            if (isCancelActivity) {
                boundaryEventActivity.setActivityStartBehavior(ActivityStartBehavior.CANCEL_EVENT_SCOPE);
            } else {
                boundaryEventActivity.setActivityStartBehavior(ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE);
            }
            ActivityBehavior behavior = new BoundaryEventActivityBehavior();
            if (timerEventDefinition != null) {
                this.parseBoundaryTimerEventDefinition(timerEventDefinition, isCancelActivity, boundaryEventActivity);
            } else if (errorEventDefinition != null) {
                this.parseBoundaryErrorEventDefinition(errorEventDefinition, boundaryEventActivity);
            } else if (signalEventDefinition != null) {
                this.parseBoundarySignalEventDefinition(signalEventDefinition, isCancelActivity, boundaryEventActivity);
            } else if (cancelEventDefinition != null) {
                behavior = this.parseBoundaryCancelEventDefinition(cancelEventDefinition, boundaryEventActivity);
            } else if (compensateEventDefinition != null) {
                this.parseBoundaryCompensateEventDefinition(compensateEventDefinition, boundaryEventActivity);
            } else if (messageEventDefinition != null) {
                this.parseBoundaryMessageEventDefinition(messageEventDefinition, isCancelActivity, boundaryEventActivity);
            } else if (escalationEventDefinition != null) {
                if (attachedActivity.isSubProcessScope() || attachedActivity.getActivityBehavior() instanceof CallActivityBehavior) {
                    this.parseBoundaryEscalationEventDefinition(escalationEventDefinition, isCancelActivity, boundaryEventActivity);
                } else {
                    this.addError("An escalation boundary event should only be attached to a subprocess or a call activity", boundaryEventElement);
                }
            } else {
                this.addError("Unsupported boundary event type", boundaryEventElement);
            }
            this.ensureNoIoMappingDefined(boundaryEventElement);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseBoundaryEvent(boundaryEventElement, flowScope, boundaryEventActivity);
            }
            boundaryEventActivity.setActivityBehavior(behavior);
            this.parseExecutionListenersOnScope(boundaryEventElement, boundaryEventActivity);
        }
    }

    protected ActivityImpl getMultiInstanceScope(ActivityImpl activity) {
        if (activity.isMultiInstance()) {
            return activity.getParentFlowScopeActivity();
        }
        return null;
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl boundaryActivity) {
        boundaryActivity.setProperty("type", "boundaryTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, boundaryActivity, "timer-transition");
        if (interrupting) {
            timerDeclaration.setInterruptingTimer(true);
            Element timeCycleElement = timerEventDefinition.element("timeCycle");
            if (timeCycleElement != null) {
                this.addTimeCycleWarning(timeCycleElement, "cancelling boundary");
            }
        }
        this.addTimerDeclaration(boundaryActivity.getEventScope(), timerDeclaration);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryTimerEventDefinition(timerEventDefinition, interrupting, boundaryActivity);
        }
    }

    public void parseBoundarySignalEventDefinition(Element element, boolean interrupting, ActivityImpl signalActivity) {
        signalActivity.setProperty("type", "boundarySignal");
        EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(element);
        if (signalActivity.getId() == null) {
            this.addError("boundary event has no id", element);
        }
        signalDefinition.setActivityId(signalActivity.getId());
        this.addEventSubscriptionDeclaration(signalDefinition, signalActivity.getEventScope(), element);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundarySignalEventDefinition(element, interrupting, signalActivity);
        }
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl messageActivity) {
        messageActivity.setProperty("type", "boundaryMessage");
        EventSubscriptionDeclaration messageEventDefinition = this.parseMessageEventDefinition(element);
        if (messageActivity.getId() == null) {
            this.addError("boundary event has no id", element);
        }
        messageEventDefinition.setActivityId(messageActivity.getId());
        this.addEventSubscriptionDeclaration(messageEventDefinition, messageActivity.getEventScope(), element);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryMessageEventDefinition(element, interrupting, messageActivity);
        }
    }

    protected void parseTimerStartEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity, ProcessDefinitionEntity processDefinition) {
        timerActivity.setProperty("type", "startTimerEvent");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-start-event");
        timerDeclaration.setJobHandlerConfiguration(processDefinition.getKey());
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)processDefinition.getProperty(PROPERTYNAME_START_TIMER);
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            processDefinition.setProperty(PROPERTYNAME_START_TIMER, timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }

    protected void parseTimerStartEventDefinitionForEventSubprocess(Element timerEventDefinition, ActivityImpl timerActivity, boolean interrupting) {
        Element timeCycleElement;
        timerActivity.setProperty("type", "startTimerEvent");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-start-event-subprocess");
        timerDeclaration.setActivity(timerActivity);
        timerDeclaration.setEventScopeActivityId(timerActivity.getEventScope().getId());
        timerDeclaration.setJobHandlerConfiguration(timerActivity.getFlowScope().getId());
        timerDeclaration.setInterruptingTimer(interrupting);
        if (interrupting && (timeCycleElement = timerEventDefinition.element("timeCycle")) != null) {
            this.addTimeCycleWarning(timeCycleElement, "interrupting start");
        }
        this.addTimerDeclaration(timerActivity.getEventScope(), timerDeclaration);
    }

    protected void parseEventDefinitionForSubprocess(EventSubscriptionDeclaration subscriptionDeclaration, ActivityImpl activity, Element element) {
        subscriptionDeclaration.setActivityId(activity.getId());
        subscriptionDeclaration.setEventScopeActivityId(activity.getEventScope().getId());
        subscriptionDeclaration.setStartEvent(false);
        this.addEventSubscriptionDeclaration(subscriptionDeclaration, activity.getEventScope(), element);
    }

    protected void parseIntermediateSignalEventDefinition(Element element, ActivityImpl signalActivity) {
        signalActivity.setProperty("type", "intermediateSignalCatch");
        this.parseSignalCatchEventDefinition(element, signalActivity, false);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateSignalCatchEventDefinition(element, signalActivity);
        }
    }

    protected void parseSignalCatchEventDefinition(Element element, ActivityImpl signalActivity, boolean isStartEvent) {
        EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(element);
        signalDefinition.setActivityId(signalActivity.getId());
        signalDefinition.setStartEvent(isStartEvent);
        this.addEventSubscriptionDeclaration(signalDefinition, signalActivity.getEventScope(), element);
        EventSubscriptionJobDeclaration catchingAsyncDeclaration = new EventSubscriptionJobDeclaration(signalDefinition);
        catchingAsyncDeclaration.setJobPriorityProvider((ParameterValueProvider)signalActivity.getProperty(PROPERTYNAME_JOB_PRIORITY));
        catchingAsyncDeclaration.setActivity(signalActivity);
        signalDefinition.setJobDeclaration(catchingAsyncDeclaration);
        this.addEventSubscriptionJobDeclaration(catchingAsyncDeclaration, signalActivity, element);
    }

    protected EventSubscriptionDeclaration parseSignalEventDefinition(Element signalEventDefinitionElement) {
        String signalRef = signalEventDefinitionElement.attribute("signalRef");
        if (signalRef == null) {
            this.addError("signalEventDefinition does not have required property 'signalRef'", signalEventDefinitionElement);
            return null;
        }
        SignalDefinition signalDefinition = this.signals.get(this.resolveName(signalRef));
        if (signalDefinition == null) {
            this.addError("Could not find signal with id '" + signalRef + "'", signalEventDefinitionElement);
        }
        EventSubscriptionDeclaration signalEventDefinition = new EventSubscriptionDeclaration(signalDefinition.getName(), "signal");
        boolean throwingAsynch = "true".equals(signalEventDefinitionElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "async", "false"));
        signalEventDefinition.setAsync(throwingAsynch);
        return signalEventDefinition;
    }

    protected void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity) {
        timerActivity.setProperty("type", "intermediateTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-intermediate-transition");
        Element timeCycleElement = timerEventDefinition.element("timeCycle");
        if (timeCycleElement != null) {
            this.addTimeCycleWarning(timeCycleElement, "intermediate catch");
        }
        this.addTimerDeclaration(timerActivity.getEventScope(), timerDeclaration);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateTimerEventDefinition(timerEventDefinition, timerActivity);
        }
    }

    protected TimerDeclarationImpl parseTimer(Element timerEventDefinition, ActivityImpl timerActivity, String jobHandlerType) {
        TimerDeclarationType type = TimerDeclarationType.DATE;
        Expression expression = this.parseExpression(timerEventDefinition, "timeDate");
        if (expression == null) {
            type = TimerDeclarationType.CYCLE;
            expression = this.parseExpression(timerEventDefinition, "timeCycle");
        }
        if (expression == null) {
            type = TimerDeclarationType.DURATION;
            expression = this.parseExpression(timerEventDefinition, "timeDuration");
        }
        if (expression == null) {
            this.addError("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed).", timerEventDefinition);
        }
        TimerDeclarationImpl timerDeclaration = new TimerDeclarationImpl(expression, type, jobHandlerType);
        timerDeclaration.setJobHandlerConfiguration(timerActivity.getId());
        timerDeclaration.setExclusive("true".equals(timerEventDefinition.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "exclusive", String.valueOf(true))));
        if (timerActivity.getId() == null) {
            this.addError("Attribute \"id\" is required!", timerEventDefinition);
        }
        timerDeclaration.setActivity(timerActivity);
        timerDeclaration.setJobConfiguration(type.toString() + ": " + expression.getExpressionText());
        this.addJobDeclarationToProcessDefinition(timerDeclaration, timerActivity.getProcessDefinition());
        timerDeclaration.setJobPriorityProvider((ParameterValueProvider)timerActivity.getProperty(PROPERTYNAME_JOB_PRIORITY));
        return timerDeclaration;
    }

    protected Expression parseExpression(Element parent, String name) {
        Element value = parent.element(name);
        if (value != null) {
            String expressionText = value.getText().trim();
            return this.expressionManager.createExpression(expressionText);
        }
        return null;
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, ActivityImpl boundaryEventActivity) {
        boundaryEventActivity.setProperty("type", "boundaryError");
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        ErrorEventDefinition definition = new ErrorEventDefinition(boundaryEventActivity.getId());
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            definition.setErrorCode(error == null ? errorRef : error.getErrorCode());
        }
        this.setErrorCodeVariableOnErrorEventDefinition(errorEventDefinition, definition);
        this.addErrorEventDefinition(definition, boundaryEventActivity.getEventScope());
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryErrorEventDefinition(errorEventDefinition, true, (ActivityImpl)boundaryEventActivity.getEventScope(), boundaryEventActivity);
        }
    }

    protected void addErrorEventDefinition(ErrorEventDefinition errorEventDefinition, ScopeImpl catchingScope) {
        catchingScope.getProperties().addListItem(BpmnProperties.ERROR_EVENT_DEFINITIONS, errorEventDefinition);
        List<ErrorEventDefinition> errorEventDefinitions = catchingScope.getProperties().get(BpmnProperties.ERROR_EVENT_DEFINITIONS);
        Collections.sort(errorEventDefinitions, ErrorEventDefinition.comparator);
    }

    protected void parseBoundaryEscalationEventDefinition(Element escalationEventDefinitionElement, boolean cancelActivity, ActivityImpl boundaryEventActivity) {
        boundaryEventActivity.getProperties().set(BpmnProperties.TYPE, "boundaryEscalation");
        EscalationEventDefinition escalationEventDefinition = this.createEscalationEventDefinitionForEscalationHandler(escalationEventDefinitionElement, boundaryEventActivity, cancelActivity);
        this.addEscalationEventDefinition(boundaryEventActivity.getEventScope(), escalationEventDefinition, escalationEventDefinitionElement);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryEscalationEventDefinition(escalationEventDefinitionElement, cancelActivity, boundaryEventActivity);
        }
    }

    protected Escalation findEscalationForEscalationEventDefinition(Element escalationEventDefinition) {
        String escalationRef = escalationEventDefinition.attribute("escalationRef");
        if (escalationRef == null) {
            this.addError("escalationEventDefinition does not have required attribute 'escalationRef'", escalationEventDefinition);
        } else if (!this.escalations.containsKey(escalationRef)) {
            this.addError("could not find escalation with id '" + escalationRef + "'", escalationEventDefinition);
        } else {
            return this.escalations.get(escalationRef);
        }
        return null;
    }

    protected EscalationEventDefinition createEscalationEventDefinitionForEscalationHandler(Element escalationEventDefinitionElement, ActivityImpl escalationHandler, boolean cancelActivity) {
        String escalationCodeVariable;
        EscalationEventDefinition escalationEventDefinition = new EscalationEventDefinition(escalationHandler, cancelActivity);
        String escalationRef = escalationEventDefinitionElement.attribute("escalationRef");
        if (escalationRef != null) {
            if (!this.escalations.containsKey(escalationRef)) {
                this.addError("could not find escalation with id '" + escalationRef + "'", escalationEventDefinitionElement);
            } else {
                Escalation escalation = this.escalations.get(escalationRef);
                escalationEventDefinition.setEscalationCode(escalation.getEscalationCode());
            }
        }
        if ((escalationCodeVariable = escalationEventDefinitionElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "escalationCodeVariable")) != null) {
            escalationEventDefinition.setEscalationCodeVariable(escalationCodeVariable);
        }
        return escalationEventDefinition;
    }

    protected void addEscalationEventDefinition(ScopeImpl catchingScope, EscalationEventDefinition escalationEventDefinition, Element element) {
        for (EscalationEventDefinition existingEscalationEventDefinition : catchingScope.getProperties().get(BpmnProperties.ESCALATION_EVENT_DEFINITIONS)) {
            if (existingEscalationEventDefinition.getEscalationHandler().isSubProcessScope() && escalationEventDefinition.getEscalationHandler().isSubProcessScope()) {
                if (existingEscalationEventDefinition.getEscalationCode() == null && escalationEventDefinition.getEscalationCode() == null) {
                    this.addError("The same scope can not contains more than one escalation event subprocess without escalation code. An escalation event subprocess without escalation code catch all escalation events.", element);
                    continue;
                }
                if (existingEscalationEventDefinition.getEscalationCode() == null || escalationEventDefinition.getEscalationCode() == null) {
                    this.addError("The same scope can not contains an escalation event subprocess without escalation code and another one with escalation code. The escalation event subprocess without escalation code catch all escalation events.", element);
                    continue;
                }
                if (!existingEscalationEventDefinition.getEscalationCode().equals(escalationEventDefinition.getEscalationCode())) continue;
                this.addError("multiple escalation event subprocesses with the same escalationCode '" + escalationEventDefinition.getEscalationCode() + "' are not supported on same scope", element);
                continue;
            }
            if (existingEscalationEventDefinition.getEscalationHandler().isSubProcessScope() || escalationEventDefinition.getEscalationHandler().isSubProcessScope()) continue;
            if (existingEscalationEventDefinition.getEscalationCode() == null && escalationEventDefinition.getEscalationCode() == null) {
                this.addError("The same scope can not contains more than one escalation boundary event without escalation code. An escalation boundary event without escalation code catch all escalation events.", element);
                continue;
            }
            if (existingEscalationEventDefinition.getEscalationCode() == null || escalationEventDefinition.getEscalationCode() == null) {
                this.addError("The same scope can not contains an escalation boundary event without escalation code and another one with escalation code. The escalation boundary event without escalation code catch all escalation events.", element);
                continue;
            }
            if (!existingEscalationEventDefinition.getEscalationCode().equals(escalationEventDefinition.getEscalationCode())) continue;
            this.addError("multiple escalation boundary events with the same escalationCode '" + escalationEventDefinition.getEscalationCode() + "' are not supported on same scope", element);
        }
        catchingScope.getProperties().addListItem(BpmnProperties.ESCALATION_EVENT_DEFINITIONS, escalationEventDefinition);
    }

    protected void addTimerDeclaration(ScopeImpl scope, TimerDeclarationImpl timerDeclaration) {
        if (!scope.getProperties().contains(BpmnProperties.TIMER_DECLARATIONS)) {
            scope.getProperties().set(BpmnProperties.TIMER_DECLARATIONS, new ArrayList());
        }
        List<TimerDeclarationImpl> timerDeclarations = scope.getProperties().get(BpmnProperties.TIMER_DECLARATIONS);
        timerDeclarations.add(timerDeclaration);
    }

    protected void addVariableDeclaration(ScopeImpl scope, VariableDeclaration variableDeclaration) {
        ArrayList<VariableDeclaration> variableDeclarations = (ArrayList<VariableDeclaration>)scope.getProperty(PROPERTYNAME_VARIABLE_DECLARATIONS);
        if (variableDeclarations == null) {
            variableDeclarations = new ArrayList<VariableDeclaration>();
            scope.setProperty(PROPERTYNAME_VARIABLE_DECLARATIONS, variableDeclarations);
        }
        variableDeclarations.add(variableDeclaration);
    }

    public ActivityImpl parseSubProcess(Element subProcessElement, ScopeImpl scope) {
        ActivityImpl subProcessActivity = this.createActivityOnScope(subProcessElement, scope);
        subProcessActivity.setSubProcessScope(true);
        this.parseAsynchronousContinuationForActivity(subProcessElement, subProcessActivity);
        Boolean isTriggeredByEvent = this.parseBooleanAttribute(subProcessElement.attribute(PROPERTYNAME_TRIGGERED_BY_EVENT), false);
        subProcessActivity.setProperty(PROPERTYNAME_TRIGGERED_BY_EVENT, isTriggeredByEvent);
        subProcessActivity.setProperty(PROPERTYNAME_CONSUMES_COMPENSATION, isTriggeredByEvent == false);
        subProcessActivity.setScope(true);
        if (isTriggeredByEvent.booleanValue()) {
            subProcessActivity.setActivityBehavior(new EventSubProcessActivityBehavior());
            subProcessActivity.setEventScope(scope);
        } else {
            subProcessActivity.setActivityBehavior(new SubProcessActivityBehavior());
        }
        this.parseScope(subProcessElement, subProcessActivity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseSubProcess(subProcessElement, scope, subProcessActivity);
        }
        return subProcessActivity;
    }

    protected ActivityImpl parseTransaction(Element transactionElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(transactionElement, scope);
        this.parseAsynchronousContinuationForActivity(transactionElement, activity);
        activity.setScope(true);
        activity.setSubProcessScope(true);
        activity.setActivityBehavior(new TransactionActivityBehavior());
        activity.setProperty(PROPERTYNAME_TRIGGERED_BY_EVENT, false);
        this.parseScope(transactionElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTransaction(transactionElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseCallActivity(Element callActivityElement, ScopeImpl scope, boolean isMultiInstance) {
        ParameterValueProvider definitionKeyProvider;
        ActivityImpl activity = this.createActivityOnScope(callActivityElement, scope);
        this.parseAsynchronousContinuationForActivity(callActivityElement, activity);
        String calledElement = callActivityElement.attribute("calledElement");
        String caseRef = callActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "caseRef");
        if (calledElement == null && caseRef == null) {
            this.addError("Missing attribute 'calledElement' or 'caseRef'", callActivityElement);
        } else if (calledElement != null && caseRef != null) {
            this.addError("The attributes 'calledElement' or 'caseRef' cannot be used together: Use either 'calledElement' or 'caseRef'", callActivityElement);
        }
        String bindingAttributeName = "calledElementBinding";
        String versionAttributeName = "calledElementVersion";
        String deploymentId = this.deployment.getId();
        CallableElement callableElement = new CallableElement();
        callableElement.setDeploymentId(deploymentId);
        CallableElementActivityBehavior behavior = null;
        if (calledElement != null) {
            behavior = new CallActivityBehavior();
            definitionKeyProvider = this.createParameterValueProvider(calledElement, this.expressionManager);
            callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
        } else {
            behavior = new CaseCallActivityBehavior();
            definitionKeyProvider = this.createParameterValueProvider(caseRef, this.expressionManager);
            callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
            bindingAttributeName = "caseBinding";
            versionAttributeName = "caseVersion";
        }
        behavior.setCallableElement(callableElement);
        this.parseBinding(callActivityElement, activity, callableElement, bindingAttributeName);
        this.parseVersion(callActivityElement, activity, callableElement, bindingAttributeName, versionAttributeName);
        this.parseInputParameter(callActivityElement, activity, callableElement);
        this.parseOutputParameter(callActivityElement, activity, callableElement);
        if (!isMultiInstance) {
            activity.setScope(true);
        }
        activity.setActivityBehavior(behavior);
        this.parseExecutionListenersOnScope(callActivityElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseCallActivity(callActivityElement, scope, activity);
        }
        return activity;
    }

    protected void parseBinding(Element callActivityElement, ActivityImpl activity, BaseCallableElement callableElement, String bindingAttributeName) {
        String binding = callActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, bindingAttributeName);
        if (BaseCallableElement.CallableElementBinding.DEPLOYMENT.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.DEPLOYMENT);
        } else if (BaseCallableElement.CallableElementBinding.LATEST.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.LATEST);
        } else if (BaseCallableElement.CallableElementBinding.VERSION.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.VERSION);
        }
    }

    protected void parseVersion(Element callingActivityElement, ActivityImpl activity, BaseCallableElement callableElement, String bindingAttributeName, String versionAttributeName) {
        String version = null;
        BaseCallableElement.CallableElementBinding binding = callableElement.getBinding();
        version = callingActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, versionAttributeName);
        if (binding != null && binding.equals((Object)BaseCallableElement.CallableElementBinding.VERSION) && version == null) {
            this.addError("Missing attribute '" + versionAttributeName + "' when '" + bindingAttributeName + "' has value '" + BaseCallableElement.CallableElementBinding.VERSION.getValue() + "'", callingActivityElement);
        }
        ParameterValueProvider versionProvider = this.createParameterValueProvider(version, this.expressionManager);
        callableElement.setVersionValueProvider(versionProvider);
    }

    protected void parseInputParameter(Element callActivityElement, ActivityImpl activity, CallableElement callableElement) {
        Element extensionsElement = callActivityElement.element("extensionElements");
        if (extensionsElement != null) {
            for (Element inElement : extensionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "in")) {
                String businessKey = inElement.attribute("businessKey");
                if (businessKey != null && !businessKey.isEmpty()) {
                    ParameterValueProvider businessKeyValueProvider = this.createParameterValueProvider(businessKey, this.expressionManager);
                    callableElement.setBusinessKeyValueProvider(businessKeyValueProvider);
                    continue;
                }
                CallableElementParameter parameter = this.parseCallableElementProvider(inElement);
                if (this.attributeValueEquals(inElement, "local", "true")) {
                    parameter.setReadLocal(true);
                }
                callableElement.addInput(parameter);
            }
        }
    }

    protected void parseOutputParameter(Element callActivityElement, ActivityImpl activity, CallableElement callableElement) {
        Element extensionsElement = callActivityElement.element("extensionElements");
        if (extensionsElement != null) {
            for (Element outElement : extensionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "out")) {
                CallableElementParameter parameter = this.parseCallableElementProvider(outElement);
                if (this.attributeValueEquals(outElement, "local", "true")) {
                    callableElement.addOutputLocal(parameter);
                    continue;
                }
                callableElement.addOutput(parameter);
            }
        }
    }

    protected boolean attributeValueEquals(Element element, String attribute, String comparisonValue) {
        String value = element.attribute(attribute);
        return comparisonValue.equals(value);
    }

    protected CallableElementParameter parseCallableElementProvider(Element parameterElement) {
        CallableElementParameter parameter = new CallableElementParameter();
        String variables = parameterElement.attribute("variables");
        if ("all".equals(variables)) {
            parameter.setAllVariables(true);
        } else {
            ParameterValueProvider sourceValueProvider = new NullValueProvider();
            String source = parameterElement.attribute("source");
            if (source != null && !source.isEmpty()) {
                sourceValueProvider = new ConstantValueProvider(source);
            } else {
                source = parameterElement.attribute("sourceExpression");
                if (source != null && !source.isEmpty()) {
                    Expression expression = this.expressionManager.createExpression(source);
                    sourceValueProvider = new ElValueProvider(expression);
                }
            }
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = parameterElement.attribute("target");
            if (source != null && !source.isEmpty() && target == null) {
                this.addError("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", parameterElement);
            }
            parameter.setTarget(target);
        }
        return parameter;
    }

    public void parseProperties(Element element, ActivityImpl activity) {
        List<Element> propertyElements = element.elements("property");
        for (Element propertyElement : propertyElements) {
            this.parseProperty(propertyElement, activity);
        }
    }

    public void parseProperty(Element propertyElement, ActivityImpl activity) {
        String id = propertyElement.attribute("id");
        String name = propertyElement.attribute("name");
        if (name == null) {
            if (id == null) {
                this.addError("Invalid property usage on line " + propertyElement.getLine() + ": no id or name specified.", propertyElement);
            } else {
                name = id;
            }
        }
        String type = null;
        this.parsePropertyCustomExtensions(activity, propertyElement, name, type);
    }

    public void parsePropertyCustomExtensions(ActivityImpl activity, Element propertyElement, String propertyName, String propertyType) {
        String linkExpr;
        String link;
        String destExpr;
        String dst;
        String srcExpr;
        if (propertyType == null) {
            String type = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "type");
            propertyType = type != null ? type : "string";
        }
        VariableDeclaration variableDeclaration = new VariableDeclaration(propertyName, propertyType);
        this.addVariableDeclaration(activity, variableDeclaration);
        activity.setScope(true);
        String src = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "src");
        if (src != null) {
            variableDeclaration.setSourceVariableName(src);
        }
        if ((srcExpr = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "srcExpr")) != null) {
            Expression sourceExpression = this.expressionManager.createExpression(srcExpr);
            variableDeclaration.setSourceExpression(sourceExpression);
        }
        if ((dst = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "dst")) != null) {
            variableDeclaration.setDestinationVariableName(dst);
        }
        if ((destExpr = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "dstExpr")) != null) {
            Expression destinationExpression = this.expressionManager.createExpression(destExpr);
            variableDeclaration.setDestinationExpression(destinationExpression);
        }
        if ((link = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "link")) != null) {
            variableDeclaration.setLink(link);
        }
        if ((linkExpr = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "linkExpr")) != null) {
            Expression linkExpression = this.expressionManager.createExpression(linkExpr);
            variableDeclaration.setLinkExpression(linkExpression);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProperty(propertyElement, variableDeclaration, activity);
        }
    }

    public void parseSequenceFlow(Element processElement, ScopeImpl scope, Map<String, Element> compensationHandlers) {
        for (Element sequenceFlowElement : processElement.elements("sequenceFlow")) {
            String linkName;
            String id = sequenceFlowElement.attribute("id");
            String sourceRef = sequenceFlowElement.attribute("sourceRef");
            String destinationRef = sequenceFlowElement.attribute("targetRef");
            if (this.eventLinkSources.containsKey(destinationRef) && (destinationRef = this.eventLinkTargets.get(linkName = this.eventLinkSources.get(destinationRef))) == null) {
                this.addError("sequence flow points to link event source with name '" + linkName + "' but no event target with that name exists. Most probably your link events are not configured correctly.", sequenceFlowElement);
                return;
            }
            ActivityImpl sourceActivity = scope.findActivityAtLevelOfSubprocess(sourceRef);
            ActivityImpl destinationActivity = scope.findActivityAtLevelOfSubprocess(destinationRef);
            if (sourceActivity == null && compensationHandlers.containsKey(sourceRef) || sourceActivity != null && sourceActivity.isCompensationHandler()) {
                this.addError("Invalid outgoing sequence flow of compensation activity '" + sourceRef + "'. A compensation activity should not have an incoming or outgoing sequence flow.", sequenceFlowElement);
                continue;
            }
            if (destinationActivity == null && compensationHandlers.containsKey(destinationRef) || destinationActivity != null && destinationActivity.isCompensationHandler()) {
                this.addError("Invalid incoming sequence flow of compensation activity '" + destinationRef + "'. A compensation activity should not have an incoming or outgoing sequence flow.", sequenceFlowElement);
                continue;
            }
            if (sourceActivity == null) {
                this.addError("Invalid source '" + sourceRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (destinationActivity == null) {
                this.addError("Invalid destination '" + destinationRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (sourceActivity.getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) continue;
            if (destinationActivity.getActivityBehavior() instanceof IntermediateCatchEventActivityBehavior && destinationActivity.getEventScope() != null && destinationActivity.getEventScope().getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) {
                this.addError("Invalid incoming sequenceflow for intermediateCatchEvent with id '" + destinationActivity.getId() + "' connected to an event-based gateway.", sequenceFlowElement);
                continue;
            }
            if (sourceActivity.getActivityBehavior() instanceof SubProcessActivityBehavior && ((Boolean)sourceActivity.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT)).booleanValue()) {
                this.addError("Invalid outgoing sequence flow of event subprocess", sequenceFlowElement);
                continue;
            }
            if (destinationActivity.getActivityBehavior() instanceof SubProcessActivityBehavior && ((Boolean)destinationActivity.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT)).booleanValue()) {
                this.addError("Invalid incoming sequence flow of event subprocess", sequenceFlowElement);
                continue;
            }
            if (this.getMultiInstanceScope(sourceActivity) != null) {
                sourceActivity = this.getMultiInstanceScope(sourceActivity);
            }
            if (this.getMultiInstanceScope(destinationActivity) != null) {
                destinationActivity = this.getMultiInstanceScope(destinationActivity);
            }
            TransitionImpl transition = sourceActivity.createOutgoingTransition(id);
            this.sequenceFlows.put(id, transition);
            transition.setProperty("name", sequenceFlowElement.attribute("name"));
            transition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(sequenceFlowElement));
            transition.setDestination(destinationActivity);
            this.parseSequenceFlowConditionExpression(sequenceFlowElement, transition);
            this.parseExecutionListenersOnTransition(sequenceFlowElement, transition);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseSequenceFlow(sequenceFlowElement, scope, transition);
            }
        }
    }

    public void parseSequenceFlowConditionExpression(Element seqFlowElement, TransitionImpl seqFlow) {
        Element conditionExprElement = seqFlowElement.element("conditionExpression");
        if (conditionExprElement != null) {
            String expression = conditionExprElement.getText().trim();
            String type = conditionExprElement.attributeNS(XSI_NS, "type");
            String language = conditionExprElement.attribute("language");
            String resource = conditionExprElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "resource");
            if (type != null) {
                String value;
                String string = value = type.contains(":") ? this.resolveName(type) : "http://www.omg.org/spec/BPMN/20100524/MODEL:" + type;
                if (!value.equals(ATTRIBUTEVALUE_T_FORMAL_EXPRESSION)) {
                    this.addError("Invalid type, only tFormalExpression is currently supported", conditionExprElement);
                }
            }
            Condition condition = null;
            if (language == null) {
                condition = new UelExpressionCondition(this.expressionManager.createExpression(expression));
            } else {
                try {
                    ExecutableScript script = ScriptUtil.getScript(language, expression, resource, this.expressionManager);
                    condition = new ScriptCondition(script);
                }
                catch (ProcessEngineException e) {
                    this.addError("Unable to process condition expression:" + e.getMessage(), conditionExprElement);
                }
            }
            seqFlow.setProperty(PROPERTYNAME_CONDITION_TEXT, expression);
            seqFlow.setProperty(PROPERTYNAME_CONDITION, condition);
        }
    }

    public void parseExecutionListenersOnScope(Element scopeElement, ScopeImpl scope) {
        Element extentionsElement = scopeElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> listenerElements = extentionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener;
                String eventName = listenerElement.attribute("event");
                if (!this.isValidEventNameForScope(eventName, listenerElement) || (listener = this.parseExecutionListener(listenerElement)) == null) continue;
                scope.addExecutionListener(eventName, listener);
            }
        }
    }

    protected boolean isValidEventNameForScope(String eventName, Element listenerElement) {
        if (eventName != null && eventName.trim().length() > 0) {
            if ("start".equals(eventName) || "end".equals(eventName)) {
                return true;
            }
            this.addError("Attribute 'event' must be one of {start|end}", listenerElement);
        } else {
            this.addError("Attribute 'event' is mandatory on listener", listenerElement);
        }
        return false;
    }

    public void parseExecutionListenersOnTransition(Element activitiElement, TransitionImpl activity) {
        Element extensionElements = activitiElement.element("extensionElements");
        if (extensionElements != null) {
            List<Element> listenerElements = extensionElements.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener = this.parseExecutionListener(listenerElement);
                if (listener == null) continue;
                activity.addExecutionListener(listener);
            }
        }
    }

    public ExecutionListener parseExecutionListener(Element executionListenerElement) {
        ExecutionListener executionListener = null;
        String className = executionListenerElement.attribute("class");
        String expression = executionListenerElement.attribute("expression");
        String delegateExpression = executionListenerElement.attribute("delegateExpression");
        Element scriptElement = executionListenerElement.elementNS(CAMUNDA_BPMN_EXTENSIONS_NS, "script");
        if (className != null) {
            executionListener = new ClassDelegateExecutionListener(className, this.parseFieldDeclarations(executionListenerElement));
        } else if (expression != null) {
            executionListener = new ExpressionExecutionListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            executionListener = new DelegateExpressionExecutionListener(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(executionListenerElement));
        } else if (scriptElement != null) {
            try {
                ExecutableScript executableScript = BpmnParseUtil.parseCamundaScript(scriptElement);
                if (executableScript != null) {
                    executionListener = new ScriptExecutionListener(executableScript);
                }
            }
            catch (BpmnParseException e) {
                this.addError(e);
            }
        } else {
            this.addError("Element 'class', 'expression', 'delegateExpression' or 'script' is mandatory on executionListener", executionListenerElement);
        }
        return executionListener;
    }

    public void parseDiagramInterchangeElements() {
        List<Element> diagrams = this.rootElement.elementsNS(BPMN_DI_NS, "BPMNDiagram");
        if (!diagrams.isEmpty()) {
            for (Element diagramElement : diagrams) {
                this.parseBPMNDiagram(diagramElement);
            }
        }
    }

    public void parseBPMNDiagram(Element bpmndiagramElement) {
        Element bpmnPlane = bpmndiagramElement.elementNS(BPMN_DI_NS, "BPMNPlane");
        if (bpmnPlane != null) {
            this.parseBPMNPlane(bpmnPlane);
        }
    }

    public void parseBPMNPlane(Element bpmnPlaneElement) {
        String bpmnElement = bpmnPlaneElement.attribute("bpmnElement");
        if (bpmnElement != null && !"".equals(bpmnElement)) {
            if (this.getProcessDefinition(bpmnElement) != null) {
                this.getProcessDefinition(bpmnElement).setGraphicalNotationDefined(true);
            }
            List<Element> shapes = bpmnPlaneElement.elementsNS(BPMN_DI_NS, "BPMNShape");
            for (Element shape : shapes) {
                this.parseBPMNShape(shape);
            }
            List<Element> edges = bpmnPlaneElement.elementsNS(BPMN_DI_NS, "BPMNEdge");
            for (Element edge : edges) {
                this.parseBPMNEdge(edge);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNPlane ", bpmnPlaneElement);
        }
    }

    public void parseBPMNShape(Element bpmnShapeElement) {
        String bpmnElement = bpmnShapeElement.attribute("bpmnElement");
        if (bpmnElement != null && !"".equals(bpmnElement)) {
            if (this.participantProcesses.get(bpmnElement) != null) {
                ProcessDefinitionEntity procDef = this.getProcessDefinition(this.participantProcesses.get(bpmnElement));
                procDef.setGraphicalNotationDefined(true);
                this.parseDIBounds(bpmnShapeElement, procDef.getParticipantProcess());
                return;
            }
            for (ProcessDefinitionEntity processDefinition : this.getProcessDefinitions()) {
                ActivityImpl activity = processDefinition.findActivity(bpmnElement);
                if (activity != null) {
                    this.parseDIBounds(bpmnShapeElement, activity);
                    String isExpanded = bpmnShapeElement.attribute(PROPERTYNAME_ISEXPANDED);
                    if (isExpanded == null) continue;
                    activity.setProperty(PROPERTYNAME_ISEXPANDED, this.parseBooleanAttribute(isExpanded));
                    continue;
                }
                Lane lane = processDefinition.getLaneForId(bpmnElement);
                if (lane != null) {
                    this.parseDIBounds(bpmnShapeElement, lane);
                    continue;
                }
                if (this.elementIds.contains(bpmnElement)) continue;
                this.addError("Invalid reference in 'bpmnElement' attribute, activity " + bpmnElement + "not found", bpmnShapeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNShape", bpmnShapeElement);
        }
    }

    protected void parseDIBounds(Element bpmnShapeElement, HasDIBounds target) {
        Element bounds = bpmnShapeElement.elementNS(BPMN_DC_NS, "Bounds");
        if (bounds != null) {
            target.setX(this.parseDoubleAttribute(bpmnShapeElement, "x", bounds.attribute("x"), true).intValue());
            target.setY(this.parseDoubleAttribute(bpmnShapeElement, "y", bounds.attribute("y"), true).intValue());
            target.setWidth(this.parseDoubleAttribute(bpmnShapeElement, "width", bounds.attribute("width"), true).intValue());
            target.setHeight(this.parseDoubleAttribute(bpmnShapeElement, "height", bounds.attribute("height"), true).intValue());
        } else {
            this.addError("'Bounds' element is required", bpmnShapeElement);
        }
    }

    public void parseBPMNEdge(Element bpmnEdgeElement) {
        String sequenceFlowId = bpmnEdgeElement.attribute("bpmnElement");
        if (sequenceFlowId != null && !"".equals(sequenceFlowId)) {
            if (this.sequenceFlows != null && this.sequenceFlows.containsKey(sequenceFlowId)) {
                TransitionImpl sequenceFlow = this.sequenceFlows.get(sequenceFlowId);
                List<Element> waypointElements = bpmnEdgeElement.elementsNS(OMG_DI_NS, "waypoint");
                if (waypointElements.size() >= 2) {
                    ArrayList<Integer> waypoints = new ArrayList<Integer>();
                    for (Element waypointElement : waypointElements) {
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "x", waypointElement.attribute("x"), true).intValue());
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "y", waypointElement.attribute("y"), true).intValue());
                    }
                    sequenceFlow.setWaypoints(waypoints);
                } else {
                    this.addError("Minimum 2 waypoint elements must be definted for a 'BPMNEdge'", bpmnEdgeElement);
                }
            } else if (!this.elementIds.contains(sequenceFlowId)) {
                this.addError("Invalid reference in 'bpmnElement' attribute, sequenceFlow " + sequenceFlowId + "not found", bpmnEdgeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNEdge", bpmnEdgeElement);
        }
    }

    public List<ProcessDefinitionEntity> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey) {
        for (ProcessDefinitionEntity processDefinition : this.processDefinitions) {
            if (!processDefinition.getKey().equals(processDefinitionKey)) continue;
            return processDefinition;
        }
        return null;
    }

    @Override
    public BpmnParse name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public BpmnParse sourceInputStream(InputStream inputStream) {
        super.sourceInputStream(inputStream);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource, ClassLoader classLoader) {
        super.sourceResource(resource, classLoader);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource) {
        super.sourceResource(resource);
        return this;
    }

    @Override
    public BpmnParse sourceString(String string) {
        super.sourceString(string);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(String url) {
        super.sourceUrl(url);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(URL url) {
        super.sourceUrl(url);
        return this;
    }

    public Boolean parseBooleanAttribute(String booleanText, boolean defaultValue) {
        if (booleanText == null) {
            return defaultValue;
        }
        return this.parseBooleanAttribute(booleanText);
    }

    public Boolean parseBooleanAttribute(String booleanText) {
        if ("true".equals(booleanText) || "enabled".equals(booleanText) || "on".equals(booleanText) || "active".equals(booleanText) || "yes".equals(booleanText)) {
            return Boolean.TRUE;
        }
        if ("false".equals(booleanText) || "disabled".equals(booleanText) || "off".equals(booleanText) || "inactive".equals(booleanText) || "no".equals(booleanText)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Double parseDoubleAttribute(Element element, String attributename, String doubleText, boolean required) {
        if (required && (doubleText == null || "".equals(doubleText))) {
            this.addError(attributename + " is required", element);
        } else {
            try {
                return Double.parseDouble(doubleText);
            }
            catch (NumberFormatException e) {
                this.addError("Cannot parse " + attributename + ": " + e.getMessage(), element);
            }
        }
        return -1.0;
    }

    protected boolean isExclusive(Element element) {
        return "true".equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "exclusive", String.valueOf(true)));
    }

    protected boolean isAsyncBefore(Element element) {
        return "true".equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "async")) || "true".equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "asyncBefore"));
    }

    protected boolean isAsyncAfter(Element element) {
        return "true".equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "asyncAfter"));
    }

    private boolean isServiceTaskLike(Element element) {
        return element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "class") != null || element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "expression") != null || element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "delegateExpression") != null || this.isExternalTaskType(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "type"));
    }

    protected boolean isExternalTaskType(String type) {
        return "external".equalsIgnoreCase(type);
    }

    public Map<String, List<JobDeclaration<?, ?>>> getJobDeclarations() {
        return this.jobDeclarations;
    }

    public List<JobDeclaration<?, ?>> getJobDeclarationsByKey(String processDefinitionKey) {
        return this.jobDeclarations.get(processDefinitionKey);
    }

    protected void parseActivityInputOutput(Element activityElement, ActivityImpl activity) {
        Element extensionElements = activityElement.element("extensionElements");
        if (extensionElements != null) {
            IoMapping inputOutput = null;
            try {
                inputOutput = BpmnParseUtil.parseInputOutput(extensionElements);
            }
            catch (BpmnParseException e) {
                this.addError(e);
            }
            if (inputOutput != null && this.checkActivityInputOutputSupported(activityElement, activity, inputOutput)) {
                activity.setIoMapping(inputOutput);
                if (this.getMultiInstanceScope(activity) == null) {
                    activity.setScope(true);
                }
            }
        }
    }

    protected boolean checkActivityInputOutputSupported(Element activityElement, ActivityImpl activity, IoMapping inputOutput) {
        String tagName = activityElement.getTagName();
        if (!(tagName.contains("Task") || tagName.contains("Event") || tagName.equals("transaction") || tagName.equals("subProcess") || tagName.equals("callActivity"))) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + tagName + "'.", activityElement);
            return false;
        }
        if (tagName.equals("subProcess") && "true".equals(activityElement.attribute(PROPERTYNAME_TRIGGERED_BY_EVENT))) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + tagName + "' with attribute 'triggeredByEvent = true'.", activityElement);
            return false;
        }
        if (!inputOutput.getOutputParameters().isEmpty()) {
            return this.checkActivityOutputParameterSupported(activityElement, activity);
        }
        return true;
    }

    protected boolean checkActivityOutputParameterSupported(Element activityElement, ActivityImpl activity) {
        String tagName = activityElement.getTagName();
        if (tagName.equals("endEvent")) {
            this.addError("camunda:outputParameter not allowed for element type '" + tagName + "'.", activityElement);
            return true;
        }
        if (this.getMultiInstanceScope(activity) != null) {
            this.addError("camunda:outputParameter not allowed for multi-instance constructs", activityElement);
            return false;
        }
        return true;
    }

    protected void ensureNoIoMappingDefined(Element element) {
        Element inputOutput = BpmnParseUtil.findCamundaExtensionElement(element, "inputOutput");
        if (inputOutput != null) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + element.getTagName() + "'.", element);
        }
    }

    protected ParameterValueProvider createParameterValueProvider(Object value, ExpressionManager expressionManager) {
        if (value == null) {
            return new NullValueProvider();
        }
        if (value instanceof String && StringUtil.isExpression((String)value)) {
            Expression expression = expressionManager.createExpression((String)value);
            return new ElValueProvider(expression);
        }
        return new ConstantValueProvider(value);
    }

    protected void addTimeCycleWarning(Element timeCycleElement, String type) {
        String warning = "It is not recommended to use a " + type + " timer event with a time cycle.";
        this.addWarning(warning, timeCycleElement);
    }
}

