/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractCorrelateMessageCmd {
    protected final String messageName;
    protected final String businessKey;
    protected final Map<String, Object> correlationKeys;
    protected final Map<String, Object> processVariables;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected boolean isExclusiveCorrelation = false;

    protected AbstractCorrelateMessageCmd(String messageName, String businessKey, Map<String, Object> correlationKeys, Map<String, Object> processVariables) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.correlationKeys = correlationKeys;
        this.processVariables = processVariables;
    }

    protected AbstractCorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        this.messageName = messageCorrelationBuilderImpl.getMessageName();
        this.processVariables = messageCorrelationBuilderImpl.getPayloadProcessInstanceVariables();
        this.correlationKeys = messageCorrelationBuilderImpl.getCorrelationProcessInstanceVariables();
        this.businessKey = messageCorrelationBuilderImpl.getBusinessKey();
        this.processInstanceId = messageCorrelationBuilderImpl.getProcessInstanceId();
        this.processDefinitionId = messageCorrelationBuilderImpl.getProcessDefinitionId();
        this.isExclusiveCorrelation = messageCorrelationBuilderImpl.isExclusiveCorrelation();
    }

    protected void triggerExecution(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        String executionId = correlationResult.getExecutionEntity().getId();
        MessageEventReceivedCmd command = new MessageEventReceivedCmd(this.messageName, executionId, this.processVariables, this.isExclusiveCorrelation);
        command.execute(commandContext);
    }

    protected ProcessInstance instantiateProcess(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        ProcessDefinitionEntity processDefinitionEntity = correlationResult.getProcessDefinitionEntity();
        ActivityImpl messageStartEvent = processDefinitionEntity.findActivity(correlationResult.getStartEventActivityId());
        ExecutionEntity processInstance = processDefinitionEntity.createProcessInstance(this.businessKey, messageStartEvent);
        processInstance.start(this.processVariables);
        return processInstance;
    }

    protected void checkAuthorization(MessageCorrelationResult correlation) {
        AuthorizationManager authorizationManager = Context.getCommandContext().getAuthorizationManager();
        if ("execution".equals(correlation.getResultType())) {
            ExecutionEntity execution = correlation.getExecutionEntity();
            authorizationManager.checkUpdateProcessInstanceById(execution.getProcessInstanceId());
        } else {
            ProcessDefinitionEntity definition = correlation.getProcessDefinitionEntity();
            authorizationManager.checkCreateProcessInstance(definition);
        }
    }
}

