/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.application.impl.ProcessApplicationIdentifier;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;

public class CommandLogger
extends ProcessEngineLogger {
    public void debugCreatingNewDeployment() {
        this.logDebug("001", "Creating new deployment", new Object[0]);
    }

    public void usingExistingDeployment() {
        this.logDebug("002", "Using existing deployment", new Object[0]);
    }

    public void debugModificationInstruction(String processInstanceId, int i, String describe) {
        this.logDebug("003", "Modifying process instance '{}': Instruction {}: {}", new Object[]{processInstanceId, i, describe});
    }

    public void debugStartingInstruction(String processInstanceId, int i, String describe) {
        this.logDebug("004", "Starting process instance '{}': Instruction {}: {}", new Object[]{processInstanceId, i, describe});
    }

    public void debugStartingCommand(Command<?> cmd) {
        this.logDebug("005", "Starting command -------------------- {} ----------------------", new Object[]{ClassNameUtil.getClassNameWithoutPackage(cmd)});
    }

    public void debugFinishingCommand(Command<?> cmd) {
        this.logDebug("006", "Finishing command -------------------- {} ----------------------", new Object[]{ClassNameUtil.getClassNameWithoutPackage(cmd)});
    }

    public void debugWaitingFor(long waitTime) {
        this.logDebug("007", "Waiting for {} before retrying command", new Object[]{waitTime});
    }

    public void debugCaughtOptimisticLockingException(OptimisticLockingException e) {
        this.logDebug("008", "caught optimistic locking excpetion", new Object[]{e});
    }

    public void debugOpeningNewCommandContext() {
        this.logDebug("009", "opening new command context", new Object[0]);
    }

    public void debugReusingExistingCommandContext() {
        this.logDebug("010", "reusing existing command context", new Object[0]);
    }

    public void closingCommandContext() {
        this.logDebug("011", "closing existing command context", new Object[0]);
    }

    public void calledInsideTransaction() {
        this.logDebug("012", "called inside transaction skipping", new Object[0]);
    }

    public void maskedExceptionInCommandContext(Throwable throwable) {
        this.logDebug("013", "masked exception in command context. for root cause, see below as it will be rethrown later.", new Object[]{throwable});
    }

    public void exceptionWhileRollingBackTransaction(Exception e) {
        this.logError("014", "exception while rolling back transaction", new Object[]{e});
    }

    public void exceptionWhileGettingValueForVariable(Exception t) {
        this.logDebug("015", "exception while getting value for variable {}", new Object[]{t.getMessage(), t});
    }

    public void couldNotFindProcessDefinitionForEventSubscription(MessageEventSubscriptionEntity messageEventSubscription, String processDefinitionId) {
        this.logDebug("016", "Found event subscription with {} but process definition {} could not be found.", new Object[]{messageEventSubscription, processDefinitionId});
    }

    public void debugIgnoringEventSubscription(EventSubscriptionEntity eventSubscription, String processDefinitionId) {
        this.logDebug("017", "Found event subscription with {} but process definition {} could not be found.", new Object[]{eventSubscription, processDefinitionId});
    }

    public void debugProcessingDeployment(String name) {
        this.logDebug("018", "Processing deployment {}", new Object[]{name});
    }

    public void debugProcessingResource(String name) {
        this.logDebug("019", "Processing resource {}", new Object[]{name});
    }

    public ProcessEngineException paWithNameNotRegistered(String name) {
        return new ProcessEngineException(this.exceptionMessage("020", "A process application with name '{}' is not registered", new Object[]{name}));
    }

    public ProcessEngineException cannotReolvePa(ProcessApplicationIdentifier processApplicationIdentifier) {
        return new ProcessEngineException(this.exceptionMessage("021", "Cannot resolve process application based on {}", new Object[]{processApplicationIdentifier}));
    }

    public void warnDisabledDeploymentLock() {
        this.logWarn("022", "No exclusive lock is aquired while deploying because it is disabled. This can lead to problems when multiple process engines use the same data source (i.e. in cluster mode).", new Object[0]);
    }

    public BadUserRequestException exceptionStartProcessInstanceByIdAndTenantId() {
        return new BadUserRequestException(this.exceptionMessage("023", "Cannot specify a tenant-id when start a process instance by process definition id.", new Object[0]));
    }

    public BadUserRequestException exceptionStartProcessInstanceAtStartActivityAndSkipListenersOrMapping() {
        return new BadUserRequestException(this.exceptionMessage("024", "Cannot skip custom listeners or input/output mappings when start a process instance at default start activity.", new Object[0]));
    }

    public BadUserRequestException exceptionCorrelateMessageWithProcessDefinitionId() {
        return new BadUserRequestException(this.exceptionMessage("025", "Cannot specify a process definition id when correlate a message, except for explicit correlation of a start message.", new Object[0]));
    }

    public BadUserRequestException exceptionCorrelateStartMessageWithCorrelationVariables() {
        return new BadUserRequestException(this.exceptionMessage("026", "Cannot specify correlation variables of a process instance when correlate a start message.", new Object[0]));
    }
}

