/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CorrelateAllMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<Void> {
    public CorrelateAllMessageCmd(String messageName, String businessKey, Map<String, Object> correlationKeys, Map<String, Object> processVariables) {
        super(messageName, businessKey, correlationKeys, processVariables);
    }

    public CorrelateAllMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        super(messageCorrelationBuilderImpl);
    }

    @Override
    public Void execute(final CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.businessKey, this.correlationKeys, this.processInstanceId);
        final CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        final CorrelationSet correlationSet = new CorrelationSet(this.businessKey, this.processInstanceId, this.correlationKeys, null);
        List<MessageCorrelationResult> correlationResults = commandContext.runWithoutAuthorization(new Callable<List<MessageCorrelationResult>>(){

            @Override
            public List<MessageCorrelationResult> call() throws Exception {
                return correlationHandler.correlateMessages(commandContext, CorrelateAllMessageCmd.this.messageName, correlationSet);
            }
        });
        for (MessageCorrelationResult correlationResult : correlationResults) {
            this.checkAuthorization(correlationResult);
        }
        for (MessageCorrelationResult correlationResult : correlationResults) {
            if ("execution".equals(correlationResult.getResultType())) {
                this.triggerExecution(commandContext, correlationResult);
                continue;
            }
            this.instantiateProcess(commandContext, correlationResult);
        }
        return null;
    }
}

