/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.DefaultMigrationPlanGenerator;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.MigrationPlanBuilderImpl;
import org.camunda.bpm.engine.impl.migration.MigrationPlanImpl;
import org.camunda.bpm.engine.impl.migration.validation.DefaultMigrationPlanValidator;
import org.camunda.bpm.engine.impl.migration.validation.MigrationPlanValidationReportImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EngineUtilLogger;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class CreateMigrationPlanCmd
implements Command<MigrationPlan> {
    public static final MigrationLogger LOG = EngineUtilLogger.MIGRATION_LOGGER;
    protected MigrationPlanBuilderImpl migrationBuilder;

    public CreateMigrationPlanCmd(MigrationPlanBuilderImpl migrationPlanBuilderImpl) {
        this.migrationBuilder = migrationPlanBuilderImpl;
    }

    @Override
    public MigrationPlan execute(CommandContext commandContext) {
        String sourceProcessDefinitionId = this.migrationBuilder.getSourceProcessDefinitionId();
        String targetProcessDefinitionId = this.migrationBuilder.getTargetProcessDefinitionId();
        MigrationPlanImpl migrationPlan = new MigrationPlanImpl(sourceProcessDefinitionId, targetProcessDefinitionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "sourceProcessDefinitionId", (Object)sourceProcessDefinitionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "targetProcessDefinitionId", (Object)targetProcessDefinitionId);
        ProcessDefinitionEntity sourceProcessDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findProcessDefinitionFromCache(sourceProcessDefinitionId);
        ProcessDefinitionEntity targetProcessDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findProcessDefinitionFromCache(targetProcessDefinitionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "source process definition with id " + sourceProcessDefinitionId + " does not exist", "sourceProcessDefinition", (Object)sourceProcessDefinition);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "target process definition with id " + targetProcessDefinitionId + " does not exist", "targetProcessDefinition", (Object)targetProcessDefinition);
        ArrayList<MigrationInstruction> instructions = new ArrayList<MigrationInstruction>();
        if (this.migrationBuilder.isMapEqualActivities()) {
            instructions.addAll(new DefaultMigrationPlanGenerator().generate(sourceProcessDefinition, targetProcessDefinition));
        }
        instructions.addAll(this.migrationBuilder.getExplicitMigrationInstructions());
        migrationPlan.setInstructions(instructions);
        MigrationPlanValidationReportImpl validationReport = new MigrationPlanValidationReportImpl(migrationPlan);
        DefaultMigrationPlanValidator validator = new DefaultMigrationPlanValidator();
        validator.validateMigrationPlan(sourceProcessDefinition, targetProcessDefinition, migrationPlan, validationReport);
        if (validationReport.hasFailures()) {
            throw LOG.failingMigrationPlanValidation(validationReport);
        }
        return migrationPlan;
    }
}

