/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cfg.TransactionLogger;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentFailListener;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessApplicationDeploymentImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.repository.ProcessApplicationDeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.instance.Case;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    private static final TransactionLogger TX_LOG = ProcessEngineLogger.TX_LOGGER;
    private static final long serialVersionUID = 1L;
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deployment execute(CommandContext commandContext) {
        Class<ProcessEngine> clazz = ProcessEngine.class;
        synchronized (ProcessEngine.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.doExecute(commandContext);
        }
    }

    protected Deployment doExecute(final CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getDeploymentManager();
        Set<String> deploymentIds = this.getAllDeploymentIds(this.deploymentBuilder);
        if (!deploymentIds.isEmpty()) {
            String[] deploymentIdArray = deploymentIds.toArray(new String[deploymentIds.size()]);
            List<DeploymentEntity> deployments = deploymentManager.findDeploymentsByIds(deploymentIdArray);
            this.ensureDeploymentsWithIdsExists(deploymentIds, deployments);
        }
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCreateDeployment();
        this.checkReadDeployments(authorizationManager, deploymentIds);
        String nameFromDeployment = this.deploymentBuilder.getNameFromDeployment();
        this.setDeploymentName(nameFromDeployment, this.deploymentBuilder, commandContext);
        List<ResourceEntity> resources = this.getResources(this.deploymentBuilder, commandContext);
        this.addResources(resources, this.deploymentBuilder);
        Collection<String> resourceNames = this.deploymentBuilder.getResourceNames();
        if (resourceNames == null || resourceNames.isEmpty()) {
            throw new NotValidException("No deployment resources contained to deploy.");
        }
        Deployment deployment = commandContext.runWithoutAuthorization(new Callable<Deployment>(){

            @Override
            public Deployment call() throws Exception {
                DeployCmd.this.acquireExclusiveLock(commandContext);
                DeploymentEntity deployment = DeployCmd.this.initDeployment();
                Map<String, ResourceEntity> resourcesToDeploy = DeployCmd.this.resolveResourcesToDeploy(commandContext, deployment);
                HashMap<String, ResourceEntity> resourcesToIgnore = new HashMap<String, ResourceEntity>(deployment.getResources());
                resourcesToIgnore.keySet().removeAll(resourcesToDeploy.keySet());
                if (!resourcesToDeploy.isEmpty()) {
                    LOG.debugCreatingNewDeployment();
                    deployment.setResources(resourcesToDeploy);
                    DeployCmd.this.deploy(deployment);
                } else {
                    LOG.usingExistingDeployment();
                    deployment = DeployCmd.this.getExistingDeployment(commandContext, deployment.getName());
                }
                DeployCmd.this.scheduleProcessDefinitionActivation(commandContext, deployment);
                if (DeployCmd.this.deploymentBuilder instanceof ProcessApplicationDeploymentBuilder) {
                    Set<String> processesToRegisterFor = DeployCmd.this.retrieveProcessKeysFromResources(resourcesToIgnore);
                    ProcessApplicationRegistration registration = DeployCmd.this.registerProcessApplication(commandContext, deployment, processesToRegisterFor);
                    return new ProcessApplicationDeploymentImpl(deployment, registration);
                }
                DeployCmd.this.registerWithJobExecutor(commandContext, deployment);
                return deployment;
            }
        });
        this.createUserOperationLog(this.deploymentBuilder, deployment, commandContext);
        return deployment;
    }

    protected void createUserOperationLog(DeploymentBuilderImpl deploymentBuilder, Deployment deployment, CommandContext commandContext) {
        UserOperationLogManager logManager = commandContext.getOperationLogManager();
        ArrayList<PropertyChange> properties = new ArrayList<PropertyChange>();
        PropertyChange filterDuplicate = new PropertyChange("duplicateFilterEnabled", null, deploymentBuilder.isDuplicateFilterEnabled());
        properties.add(filterDuplicate);
        if (deploymentBuilder.isDuplicateFilterEnabled()) {
            PropertyChange deployChangedOnly = new PropertyChange("deployChangedOnly", null, deploymentBuilder.isDeployChangedOnly());
            properties.add(deployChangedOnly);
        }
        logManager.logDeploymentOperation("Create", deployment.getId(), properties);
    }

    protected void setDeploymentName(String deploymentId, DeploymentBuilderImpl deploymentBuilder, CommandContext commandContext) {
        if (deploymentId != null && !deploymentId.isEmpty()) {
            DeploymentManager deploymentManager = commandContext.getDeploymentManager();
            DeploymentEntity deployment = deploymentManager.findDeploymentById(deploymentId);
            deploymentBuilder.getDeployment().setName(deployment.getName());
        }
    }

    protected List<ResourceEntity> getResources(DeploymentBuilderImpl deploymentBuilder, CommandContext commandContext) {
        ArrayList<ResourceEntity> resources = new ArrayList<ResourceEntity>();
        Set<String> deploymentIds = deploymentBuilder.getDeployments();
        resources.addAll(this.getResourcesByDeploymentId(deploymentIds, commandContext));
        Map<String, Set<String>> deploymentResourcesById = deploymentBuilder.getDeploymentResourcesById();
        resources.addAll(this.getResourcesById(deploymentResourcesById, commandContext));
        Map<String, Set<String>> deploymentResourcesByName = deploymentBuilder.getDeploymentResourcesByName();
        resources.addAll(this.getResourcesByName(deploymentResourcesByName, commandContext));
        this.checkDuplicateResourceName(resources);
        return resources;
    }

    protected List<ResourceEntity> getResourcesByDeploymentId(Set<String> deploymentIds, CommandContext commandContext) {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        if (!deploymentIds.isEmpty()) {
            DeploymentManager deploymentManager = commandContext.getDeploymentManager();
            for (String deploymentId : deploymentIds) {
                DeploymentEntity deployment = deploymentManager.findDeploymentById(deploymentId);
                Map<String, ResourceEntity> resources = deployment.getResources();
                Collection<ResourceEntity> values = resources.values();
                result.addAll(values);
            }
        }
        return result;
    }

    protected List<ResourceEntity> getResourcesById(Map<String, Set<String>> resourcesById, CommandContext commandContext) {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        ResourceManager resourceManager = commandContext.getResourceManager();
        for (String deploymentId : resourcesById.keySet()) {
            Set<String> resourceIds = resourcesById.get(deploymentId);
            String[] resourceIdArray = resourceIds.toArray(new String[resourceIds.size()]);
            List<ResourceEntity> resources = resourceManager.findResourceByDeploymentIdAndResourceIds(deploymentId, resourceIdArray);
            this.ensureResourcesWithIdsExist(deploymentId, resourceIds, resources);
            result.addAll(resources);
        }
        return result;
    }

    protected List<ResourceEntity> getResourcesByName(Map<String, Set<String>> resourcesByName, CommandContext commandContext) {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        ResourceManager resourceManager = commandContext.getResourceManager();
        for (String deploymentId : resourcesByName.keySet()) {
            Set<String> resourceNames = resourcesByName.get(deploymentId);
            String[] resourceNameArray = resourceNames.toArray(new String[resourceNames.size()]);
            List<ResourceEntity> resources = resourceManager.findResourceByDeploymentIdAndResourceNames(deploymentId, resourceNameArray);
            this.ensureResourcesWithNamesExist(deploymentId, resourceNames, resources);
            result.addAll(resources);
        }
        return result;
    }

    protected void addResources(List<ResourceEntity> resources, DeploymentBuilderImpl deploymentBuilder) {
        DeploymentEntity deployment = deploymentBuilder.getDeployment();
        Map<String, ResourceEntity> existingResources = deployment.getResources();
        for (ResourceEntity resource : resources) {
            String resourceName = resource.getName();
            if (existingResources != null && existingResources.containsKey(resourceName)) {
                String message = String.format("Cannot add resource with id '%s' and name '%s' from deployment with id '%s' to new deployment because the new deployment contains already a resource with same name.", resource.getId(), resourceName, resource.getDeploymentId());
                throw new NotValidException(message);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
            deploymentBuilder.addInputStream(resourceName, inputStream);
        }
    }

    protected void checkDuplicateResourceName(List<ResourceEntity> resources) {
        HashMap<String, ResourceEntity> resourceMap = new HashMap<String, ResourceEntity>();
        for (ResourceEntity resource : resources) {
            String deploymentId;
            String name = resource.getName();
            ResourceEntity duplicate = (ResourceEntity)resourceMap.get(name);
            if (duplicate != null && !(deploymentId = resource.getDeploymentId()).equals(duplicate.getDeploymentId())) {
                String message = String.format("The deployments with id '%s' and '%s' contain a resource with same name '%s'.", deploymentId, duplicate.getDeploymentId(), name);
                throw new NotValidException(message);
            }
            resourceMap.put(name, resource);
        }
    }

    protected void ensureDeploymentsWithIdsExists(Set<String> expected, List<DeploymentEntity> actual) {
        HashMap<String, DeploymentEntity> deploymentMap = new HashMap<String, DeploymentEntity>();
        for (DeploymentEntity deployment : actual) {
            deploymentMap.put(deployment.getId(), deployment);
        }
        List<String> missingDeployments = this.getMissingElements(expected, deploymentMap);
        if (!missingDeployments.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("The following deployments are not found by id: ");
            boolean first = true;
            for (String missingDeployment : missingDeployments) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(missingDeployment);
            }
            throw new NotFoundException(builder.toString());
        }
    }

    protected void ensureResourcesWithIdsExist(String deploymentId, Set<String> expectedIds, List<ResourceEntity> actual) {
        HashMap<String, ResourceEntity> resources = new HashMap<String, ResourceEntity>();
        for (ResourceEntity resource : actual) {
            resources.put(resource.getId(), resource);
        }
        this.ensureResourcesWithKeysExist(deploymentId, expectedIds, resources, "id");
    }

    protected void ensureResourcesWithNamesExist(String deploymentId, Set<String> expectedNames, List<ResourceEntity> actual) {
        HashMap<String, ResourceEntity> resources = new HashMap<String, ResourceEntity>();
        for (ResourceEntity resource : actual) {
            resources.put(resource.getName(), resource);
        }
        this.ensureResourcesWithKeysExist(deploymentId, expectedNames, resources, "name");
    }

    protected void ensureResourcesWithKeysExist(String deploymentId, Set<String> expectedKeys, Map<String, ResourceEntity> actual, String valueProperty) {
        List<String> missingResources = this.getMissingElements(expectedKeys, actual);
        if (!missingResources.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("The deployment with id '");
            builder.append(deploymentId);
            builder.append("' does not contain the following resources with ");
            builder.append(valueProperty);
            builder.append(": ");
            boolean first = true;
            for (String missingResource : missingResources) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(missingResource);
            }
            throw new NotFoundException(builder.toString());
        }
    }

    protected List<String> getMissingElements(Set<String> expected, Map<String, ?> actual) {
        ArrayList<String> missingElements = new ArrayList<String>();
        for (String value : expected) {
            if (actual.containsKey(value)) continue;
            missingElements.add(value);
        }
        return missingElements;
    }

    protected Set<String> getAllDeploymentIds(DeploymentBuilderImpl deploymentBuilder) {
        HashSet<String> result = new HashSet<String>();
        String nameFromDeployment = deploymentBuilder.getNameFromDeployment();
        if (nameFromDeployment != null && !nameFromDeployment.isEmpty()) {
            result.add(nameFromDeployment);
        }
        Set<String> deployments = deploymentBuilder.getDeployments();
        result.addAll(deployments);
        deployments = deploymentBuilder.getDeploymentResourcesById().keySet();
        result.addAll(deployments);
        deployments = deploymentBuilder.getDeploymentResourcesByName().keySet();
        result.addAll(deployments);
        return result;
    }

    protected void checkReadDeployments(AuthorizationManager authorizationManager, Set<String> deploymentIds) {
        for (String deploymentId : deploymentIds) {
            authorizationManager.checkReadDeployment(deploymentId);
        }
    }

    protected void acquireExclusiveLock(CommandContext commandContext) {
        if (Context.getProcessEngineConfiguration().isDeploymentLockUsed()) {
            commandContext.getPropertyManager().acquireExclusiveLock();
        } else {
            LOG.warnDisabledDeploymentLock();
        }
    }

    protected DeploymentEntity initDeployment() {
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(ClockUtil.getCurrentTime());
        return deployment;
    }

    protected Map<String, ResourceEntity> resolveResourcesToDeploy(CommandContext commandContext, DeploymentEntity deployment) {
        Map<Object, Object> resourcesToDeploy = new HashMap();
        Map<String, ResourceEntity> containedResources = deployment.getResources();
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            String source = deployment.getSource();
            if (source == null || source.isEmpty()) {
                source = "process application";
            }
            Map<String, ResourceEntity> existingResources = commandContext.getResourceManager().findLatestResourcesByDeploymentName(deployment.getName(), containedResources.keySet(), source, deployment.getTenantId());
            for (ResourceEntity deployedResource : containedResources.values()) {
                String resourceName = deployedResource.getName();
                ResourceEntity existingResource = existingResources.get(resourceName);
                if (existingResource != null && !existingResource.isGenerated() && !this.resourcesDiffer(deployedResource, existingResource)) continue;
                if (this.deploymentBuilder.isDeployChangedOnly()) {
                    resourcesToDeploy.put(resourceName, deployedResource);
                    continue;
                }
                resourcesToDeploy = containedResources;
                break;
            }
        } else {
            resourcesToDeploy = containedResources;
        }
        return resourcesToDeploy;
    }

    protected boolean resourcesDiffer(ResourceEntity resource, ResourceEntity existing) {
        byte[] savedBytes;
        byte[] bytes = resource.getBytes();
        return !Arrays.equals(bytes, savedBytes = existing.getBytes());
    }

    protected void deploy(DeploymentEntity deployment) {
        deployment.setNew(true);
        Context.getCommandContext().getDeploymentManager().insertDeployment(deployment);
    }

    protected DeploymentEntity getExistingDeployment(CommandContext commandContext, String deploymentName) {
        return commandContext.getDeploymentManager().findLatestDeploymentByName(deploymentName);
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
                SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null);
                suspendProcessDefinitionCmd.execute(commandContext);
                ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, false, this.deploymentBuilder.getProcessDefinitionsActivationDate());
                activateProcessDefinitionCmd.execute(commandContext);
            }
        }
    }

    protected ProcessApplicationRegistration registerProcessApplication(CommandContext commandContext, DeploymentEntity deployment, Set<String> processKeysToRegisterFor) {
        ProcessApplicationDeploymentBuilderImpl appDeploymentBuilder = (ProcessApplicationDeploymentBuilderImpl)this.deploymentBuilder;
        ProcessApplicationReference appReference = appDeploymentBuilder.getProcessApplicationReference();
        HashSet<String> deploymentsToRegister = new HashSet<String>(Collections.singleton(deployment.getId()));
        if (appDeploymentBuilder.isResumePreviousVersions()) {
            if ("process-definition-key".equals(appDeploymentBuilder.getResumePreviousVersionsBy())) {
                deploymentsToRegister.addAll(this.resumePreviousByProcessDefinitionKey(commandContext, deployment, processKeysToRegisterFor));
            } else if ("deployment-name".equals(appDeploymentBuilder.getResumePreviousVersionsBy())) {
                deploymentsToRegister.addAll(this.resumePreviousByDeploymentName(commandContext, deployment));
            }
        }
        return new RegisterProcessApplicationCmd(deploymentsToRegister, appReference).execute(commandContext);
    }

    protected Set<String> resumePreviousByProcessDefinitionKey(CommandContext commandContext, DeploymentEntity deployment, Set<String> processKeysToRegisterFor) {
        HashSet<String> processDefinitionKeys = new HashSet<String>(processKeysToRegisterFor);
        List<ProcessDefinition> deployedProcesses = this.getDeployedProcesses(deployment);
        for (ProcessDefinition deployedProcess : deployedProcesses) {
            if (deployedProcess.getVersion() <= 1) continue;
            processDefinitionKeys.add(deployedProcess.getKey());
        }
        return this.findDeploymentIdsForProcessDefinitions(commandContext, processDefinitionKeys);
    }

    protected Set<String> resumePreviousByDeploymentName(CommandContext commandContext, DeploymentEntity deployment) {
        List previousDeployments = new DeploymentQueryImpl().deploymentName(deployment.getName()).list();
        HashSet<String> deploymentIds = new HashSet<String>(previousDeployments.size());
        for (Deployment d : previousDeployments) {
            deploymentIds.add(d.getId());
        }
        return deploymentIds;
    }

    protected List<? extends ProcessDefinition> getDeployedProcesses(DeploymentEntity deployment) {
        List<ProcessDefinition> deployedProcessDefinitions = deployment.getDeployedArtifacts(ProcessDefinitionEntity.class);
        if (deployedProcessDefinitions == null) {
            CommandContext commandContext = Context.getCommandContext();
            ProcessDefinitionManager manager = commandContext.getProcessDefinitionManager();
            deployedProcessDefinitions = manager.findProcessDefinitionsByDeploymentId(deployment.getId());
        }
        return deployedProcessDefinitions;
    }

    protected Set<String> retrieveProcessKeysFromResources(Map<String, ResourceEntity> resources) {
        HashSet<String> keys = new HashSet<String>();
        for (ResourceEntity resource : resources.values()) {
            BpmnModelInstance model;
            ByteArrayInputStream byteStream;
            if (this.isBpmnResource(resource)) {
                byteStream = new ByteArrayInputStream(resource.getBytes());
                model = Bpmn.readModelFromStream((InputStream)byteStream);
                for (Process process : model.getDefinitions().getChildElementsByType(Process.class)) {
                    keys.add(process.getId());
                }
                continue;
            }
            if (!this.isCmmnResource(resource)) continue;
            byteStream = new ByteArrayInputStream(resource.getBytes());
            model = Cmmn.readModelFromStream((InputStream)byteStream);
            for (Case cmmnCase : model.getDefinitions().getCases()) {
                keys.add(cmmnCase.getId());
            }
        }
        return keys;
    }

    protected boolean isBpmnResource(ResourceEntity resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), BpmnDeployer.BPMN_RESOURCE_SUFFIXES);
    }

    protected boolean isCmmnResource(ResourceEntity resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), CmmnDeployer.CMMN_RESOURCE_SUFFIXES);
    }

    protected Set<String> findDeploymentIdsForProcessDefinitions(CommandContext commandContext, Set<String> processDefinitionKeys) {
        HashSet<String> deploymentsToRegister = new HashSet<String>();
        if (!processDefinitionKeys.isEmpty()) {
            String[] keys = processDefinitionKeys.toArray(new String[processDefinitionKeys.size()]);
            ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
            List<ProcessDefinition> previousDefinitions = processDefinitionManager.findProcessDefinitionsByKeyIn(keys);
            for (ProcessDefinition definition : previousDefinitions) {
                deploymentsToRegister.add(definition.getDeploymentId());
            }
        }
        return deploymentsToRegister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithJobExecutor(CommandContext commandContext, DeploymentEntity deployment) {
        try {
            new RegisterDeploymentCmd(deployment.getId()).execute(commandContext);
        }
        finally {
            DeploymentFailListener listener = new DeploymentFailListener(deployment.getId());
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                TX_LOG.debugTransactionOperation("Could not register transaction synchronization. Probably the TX has already been rolled back by application code.");
                listener.execute(commandContext);
            }
        }
    }
}

