/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class StartProcessInstanceAtActivitiesCmd
implements Command<ProcessInstance> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstantiationBuilderImpl instantiationBuilder;

    public StartProcessInstanceAtActivitiesCmd(ProcessInstantiationBuilderImpl instantiationBuilder) {
        this.instantiationBuilder = instantiationBuilder;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = new GetDeployedProcessDefinitionCmd(this.instantiationBuilder, false).execute(commandContext);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCreateProcessInstance(processDefinition);
        ProcessInstanceModificationBuilderImpl modificationBuilder = this.instantiationBuilder.getModificationBuilder();
        EnsureUtil.ensureNotEmpty("At least one instantiation instruction required (e.g. by invoking startBefore(..), startAfter(..) or startTransition(..))", "instructions", modificationBuilder.getModificationOperations());
        ActivityImpl initialActivity = this.determineFirstActivity(processDefinition, modificationBuilder);
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.instantiationBuilder.getBusinessKey(), this.instantiationBuilder.getCaseInstanceId(), initialActivity);
        processInstance.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
        processInstance.startWithoutExecuting();
        processInstance.setActivity(null);
        processInstance.setActivityInstanceId(processInstance.getId());
        processInstance.setVariables((Map<String, ? extends Object>)modificationBuilder.getProcessVariables());
        processInstance.setPreserveScope(true);
        List<AbstractProcessInstanceModificationCommand> instructions = modificationBuilder.getModificationOperations();
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractProcessInstanceModificationCommand instruction = instructions.get(i);
            LOG.debugStartingInstruction(processInstance.getId(), i, instruction.describe());
            instruction.setProcessInstanceId(processInstance.getId());
            instruction.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
            instruction.setSkipIoMappings(modificationBuilder.isSkipIoMappings());
            instruction.execute(commandContext);
        }
        if (!processInstance.hasChildren() && processInstance.isEnded()) {
            processInstance.propagateEnd();
        }
        return processInstance;
    }

    protected ActivityImpl determineFirstActivity(ProcessDefinitionImpl processDefinition, ProcessInstanceModificationBuilderImpl modificationBuilder) {
        AbstractProcessInstanceModificationCommand firstInstruction = modificationBuilder.getModificationOperations().get(0);
        if (firstInstruction instanceof AbstractInstantiationCmd) {
            AbstractInstantiationCmd instantiationInstruction = (AbstractInstantiationCmd)firstInstruction;
            CoreModelElement targetElement = instantiationInstruction.getTargetElement(processDefinition);
            EnsureUtil.ensureNotNull(NotValidException.class, "Element '" + instantiationInstruction.getTargetElementId() + "' does not exist in process " + processDefinition.getId(), "targetElement", (Object)targetElement);
            if (targetElement instanceof ActivityImpl) {
                return (ActivityImpl)targetElement;
            }
            if (targetElement instanceof TransitionImpl) {
                return (ActivityImpl)((TransitionImpl)targetElement).getDestination();
            }
        }
        return null;
    }
}

