/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.model;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class BaseCallableElement {
    protected ParameterValueProvider definitionKeyValueProvider;
    protected CallableElementBinding binding;
    protected ParameterValueProvider versionValueProvider;
    protected String deploymentId;

    public String getDefinitionKey(VariableScope variableScope) {
        Object result = this.definitionKeyValueProvider.getValue(variableScope);
        if (result != null && !(result instanceof String)) {
            throw new ClassCastException("Cannot cast '" + result + "' to String");
        }
        return (String)result;
    }

    public ParameterValueProvider getDefinitionKeyValueProvider() {
        return this.definitionKeyValueProvider;
    }

    public void setDefinitionKeyValueProvider(ParameterValueProvider definitionKey) {
        this.definitionKeyValueProvider = definitionKey;
    }

    public CallableElementBinding getBinding() {
        return this.binding;
    }

    public void setBinding(CallableElementBinding binding) {
        this.binding = binding;
    }

    public boolean isLatestBinding() {
        CallableElementBinding binding = this.getBinding();
        return binding == null || CallableElementBinding.LATEST.equals((Object)binding);
    }

    public boolean isDeploymentBinding() {
        CallableElementBinding binding = this.getBinding();
        return CallableElementBinding.DEPLOYMENT.equals((Object)binding);
    }

    public boolean isVersionBinding() {
        CallableElementBinding binding = this.getBinding();
        return CallableElementBinding.VERSION.equals((Object)binding);
    }

    public Integer getVersion(VariableScope variableScope) {
        Object result = this.versionValueProvider.getValue(variableScope);
        if (result != null) {
            if (result instanceof String) {
                return Integer.valueOf((String)result);
            }
            if (result instanceof Integer) {
                return (Integer)result;
            }
            throw new ProcessEngineException("It is not possible to transform '" + result + "' into an integer.");
        }
        return null;
    }

    public ParameterValueProvider getVersionValueProvider() {
        return this.versionValueProvider;
    }

    public void setVersionValueProvider(ParameterValueProvider version) {
        this.versionValueProvider = version;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDefinitionTenantId(CoreExecution execution) {
        if (execution instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)executionEntity.getProcessDefinition();
            return processDefinition.getTenantId();
        }
        if (execution instanceof CaseExecutionEntity) {
            CaseExecutionEntity caseExecution = (CaseExecutionEntity)execution;
            CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)caseExecution.getCaseDefinition();
            return caseDefinition.getTenantId();
        }
        throw new IllegalArgumentException("Unexpected execution of type " + execution.getClass().getName());
    }

    public static enum CallableElementBinding {
        LATEST("latest"),
        DEPLOYMENT("deployment"),
        VERSION("version");

        private String value;

        private CallableElementBinding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

