/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.entity.repository;

import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryProperty;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;

public class DecisionDefinitionQueryImpl
extends AbstractQuery<DecisionDefinitionQuery, DecisionDefinition>
implements DecisionDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;
    protected String[] tenantIds;

    public DecisionDefinitionQueryImpl() {
    }

    public DecisionDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionId(String decisionDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionDefinitionId", (Object)decisionDefinitionId);
        this.id = decisionDefinitionId;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionIdIn(String ... ids) {
        this.ids = ids;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionCategory(String decisionDefinitionCategory) {
        EnsureUtil.ensureNotNull(NotValidException.class, "category", (Object)decisionDefinitionCategory);
        this.category = decisionDefinitionCategory;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionCategoryLike(String decisionDefinitionCategoryLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "categoryLike", (Object)decisionDefinitionCategoryLike);
        this.categoryLike = decisionDefinitionCategoryLike;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionName(String decisionDefinitionName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "name", (Object)decisionDefinitionName);
        this.name = decisionDefinitionName;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionNameLike(String decisionDefinitionNameLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "nameLike", (Object)decisionDefinitionNameLike);
        this.nameLike = decisionDefinitionNameLike;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionKey(String decisionDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "key", (Object)decisionDefinitionKey);
        this.key = decisionDefinitionKey;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionKeyLike(String decisionDefinitionKeyLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "keyLike", (Object)decisionDefinitionKeyLike);
        this.keyLike = decisionDefinitionKeyLike;
        return this;
    }

    @Override
    public DecisionDefinitionQuery deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionVersion(Integer decisionDefinitionVersion) {
        EnsureUtil.ensureNotNull(NotValidException.class, "version", (Object)decisionDefinitionVersion);
        EnsureUtil.ensurePositive(NotValidException.class, "version", (Long)decisionDefinitionVersion.longValue());
        this.version = decisionDefinitionVersion;
        return this;
    }

    @Override
    public DecisionDefinitionQuery latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionResourceName(String resourceName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceName", (Object)resourceName);
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public DecisionDefinitionQuery decisionDefinitionResourceNameLike(String resourceNameLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceNameLike", (Object)resourceNameLike);
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public DecisionDefinitionQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public DecisionDefinitionQuery orderByDecisionDefinitionCategory() {
        this.orderBy(DecisionDefinitionQueryProperty.DECISION_DEFINITION_CATEGORY);
        return this;
    }

    @Override
    public DecisionDefinitionQuery orderByDecisionDefinitionKey() {
        this.orderBy(DecisionDefinitionQueryProperty.DECISION_DEFINITION_KEY);
        return this;
    }

    @Override
    public DecisionDefinitionQuery orderByDecisionDefinitionId() {
        this.orderBy(DecisionDefinitionQueryProperty.DECISION_DEFINITION_ID);
        return this;
    }

    @Override
    public DecisionDefinitionQuery orderByDecisionDefinitionVersion() {
        this.orderBy(DecisionDefinitionQueryProperty.DECISION_DEFINITION_VERSION);
        return this;
    }

    @Override
    public DecisionDefinitionQuery orderByDecisionDefinitionName() {
        this.orderBy(DecisionDefinitionQueryProperty.DECISION_DEFINITION_NAME);
        return this;
    }

    @Override
    public DecisionDefinitionQuery orderByDeploymentId() {
        this.orderBy(DecisionDefinitionQueryProperty.DEPLOYMENT_ID);
        return this;
    }

    @Override
    public DecisionDefinitionQuery orderByTenantId() {
        return (DecisionDefinitionQuery)this.orderBy(DecisionDefinitionQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getDecisionDefinitionManager().findDecisionDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<DecisionDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getDecisionDefinitionManager().findDecisionDefinitionsByQueryCriteria(this, page);
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.name != null || this.nameLike != null || this.version != null || this.deploymentId != null)) {
            throw new NotValidException("Calling latest() can only be used in combination with key(String) and keyLike(String)");
        }
    }

    public String getId() {
        return this.id;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }
}

