/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class JobExecutorLogger
extends ProcessEngineLogger {
    public void debugAcquiredJobNotFound(String jobId) {
        this.logDebug("001", "Acquired job with id '{}' not found.", new Object[]{jobId});
    }

    public void exceptionWhileExecutingJob(JobEntity job, RuntimeException exception) {
        this.logWarn("002", "Exception while executing job {}: ", new Object[]{job, exception});
    }

    public void debugFallbackToDefaultRetryStrategy() {
        this.logDebug("003", "Falling back to default retry stratefy", new Object[0]);
    }

    public void debugDecrementingRetriesForJob(String id) {
        this.logDebug("004", "Decrementing retries of job {}", new Object[]{id});
    }

    public void debugInitiallyAppyingRetryCycleForJob(String id, int times) {
        this.logDebug("005", "Applying job retry time cycle for the first time for job {}, retires {}", new Object[]{id, times});
    }

    public void exceptionWhileExecutingJob(String nextJobId, Throwable t) {
        this.logWarn("006", "Exception while executing job {}: ", new Object[]{nextJobId, t});
    }

    public void couldNotDeterminePriority(ExecutionEntity execution, Object value, ProcessEngineException e) {
        this.logWarn("007", "Could not determine priority for job created in context of execution {}. Using default priority {}", new Object[]{execution, value, e});
    }

    public void debugAddingNewExclusiveJobToJobExecutorCOntext(String jobId) {
        this.logInfo("008", "Adding new exclusive job to job executor context. Job Id='{}'", new Object[]{jobId});
    }

    public void timeoutDuringShutdown() {
        this.logWarn("009", "Timeout during shutdown of job executor. The current running jobs could not end within 60 seconds after shutdown operation", new Object[0]);
    }

    public void interruptedWhileShuttingDownjobExecutor(InterruptedException e) {
        this.logWarn("010", "Interrupted while shutting down the job executor", new Object[]{e});
    }

    public void debugJobAcquisitionThreadSleeping(long millis) {
        this.logDebug("011", "Job acquisition thread sleeping for {} millis", new Object[]{millis});
    }

    public void jobExecutorThreadWokeUp() {
        this.logDebug("012", "Job acquisition thread woke up", new Object[0]);
    }

    public void jobExecutionWaitInterrupted() {
        this.logDebug("013", "Job Execution wait interrupted", new Object[0]);
    }

    public void startingUpJobExecutor(String name) {
        this.logInfo("014", "Starting up the JobExecutor[{}].", new Object[]{name});
    }

    public void shuttingDownTheJobExecutor(String name) {
        this.logInfo("015", "Shutting down the JobExecutor[{}]", new Object[]{name});
    }

    public void ignoringSuspendedJob(ProcessDefinition processDefinition) {
        this.logDebug("016", "Ignoring job of suspended {}", new Object[]{processDefinition});
    }

    public void debugNotifyingJobExecutor(String string) {
        this.logDebug("017", "Notofing Job Executor of new job {}", new Object[]{string});
    }

    public void startingToAacquireJobs(String name) {
        this.logInfo("018", "{} starting to acquire jobs", new Object[]{name});
    }

    public void exceptionDuringJobAcquisition(Exception e) {
        this.logError("019", "Exection during job acquistion {}", new Object[]{e.getMessage(), e});
    }

    public void stoppedJobAcquisition(String name) {
        this.logInfo("020", "{} stopped job acquisition", new Object[]{name});
    }
}

