/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public abstract class TimerChangeJobDefinitionSuspensionStateJobHandler
implements JobHandler {
    protected static final String JOB_HANDLER_CFG_BY = "by";
    protected static final String JOB_HANDLER_CFG_JOB_DEFINITION_ID = "jobDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String JOB_HANDLER_CFG_INCLUDE_JOBS = "includeJobs";

    public static String createJobHandlerConfigurationByJobDefinitionId(String jobDefinitionId, boolean includeJobs) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_JOB_DEFINITION_ID);
        json.put(JOB_HANDLER_CFG_JOB_DEFINITION_ID, jobDefinitionId);
        json.put(JOB_HANDLER_CFG_INCLUDE_JOBS, includeJobs);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionId(String processDefinitionId, boolean includeJobs) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID, processDefinitionId);
        json.put(JOB_HANDLER_CFG_INCLUDE_JOBS, includeJobs);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionKey(String processDefinitionKey, boolean includeJobs) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, processDefinitionKey);
        json.put(JOB_HANDLER_CFG_INCLUDE_JOBS, includeJobs);
        return json.toString();
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        AbstractSetJobDefinitionStateCmd cmd = this.getCommand(configuration);
        cmd.disableLogUserOperation();
        cmd.execute(commandContext);
    }

    protected String getJobDefinitionId(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_JOB_DEFINITION_ID);
    }

    protected String getProcessDefinitionId(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
    }

    protected String getProcessDefinitionKey(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
    }

    protected boolean getIncludeJobs(JSONObject configuration) {
        return configuration.getBoolean(JOB_HANDLER_CFG_INCLUDE_JOBS);
    }

    protected String getBy(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_BY);
    }

    protected abstract AbstractSetJobDefinitionStateCmd getCommand(String var1);
}

