/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.impl.cmd.AbstractSetProcessDefinitionStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public abstract class TimerChangeProcessDefinitionSuspensionStateJobHandler
implements JobHandler {
    protected static final String JOB_HANDLER_CFG_BY = "by";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES = "includeProcessInstances";

    public static String createJobHandlerConfigurationByProcessDefinitionId(String processDefinitionId, boolean includeProcessInstances) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID, processDefinitionId);
        json.put(JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES, includeProcessInstances);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionKey(String processDefinitionKey, boolean includeProcessInstances) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, processDefinitionKey);
        json.put(JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES, includeProcessInstances);
        return json.toString();
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        AbstractSetProcessDefinitionStateCmd cmd = this.getCommand(configuration);
        cmd.disableLogUserOperation();
        cmd.execute(commandContext);
    }

    protected String getProcessDefinitionId(JSONObject config) {
        return config.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
    }

    protected String getProcessDefinitionKey(JSONObject config) {
        return config.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
    }

    protected String getBy(JSONObject config) {
        return config.getString(JOB_HANDLER_CFG_BY);
    }

    protected boolean getIncludeProcessInstances(JSONObject config) {
        return config.getBoolean(JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES);
    }

    protected abstract AbstractSetProcessDefinitionStateCmd getCommand(String var1);
}

