/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.migration.MigrationInstructionGenerator;
import org.camunda.bpm.engine.impl.migration.MigrationInstructionImpl;
import org.camunda.bpm.engine.impl.migration.validation.MigrationActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.MigrationActivityValidators;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionValidators;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class DefaultMigrationPlanGenerator
implements MigrationInstructionGenerator {
    public static final List<MigrationActivityValidator> sourceActivityValidators = Arrays.asList(MigrationActivityValidators.SUPPORTED_ACTIVITY, MigrationActivityValidators.SUPPORTED_BOUNDARY_EVENT, MigrationActivityValidators.NOT_MULTI_INSTANCE_CHILD, MigrationActivityValidators.NOT_EVENT_SUB_PROCESS_CHILD, MigrationActivityValidators.HAS_NO_EVENT_SUB_PROCESS_CHILD);
    public static final List<MigrationActivityValidator> targetActivityValidators = Arrays.asList(MigrationActivityValidators.SUPPORTED_ACTIVITY, MigrationActivityValidators.SUPPORTED_BOUNDARY_EVENT, MigrationActivityValidators.NOT_MULTI_INSTANCE_CHILD, MigrationActivityValidators.NOT_EVENT_SUB_PROCESS_CHILD, MigrationActivityValidators.HAS_NO_EVENT_SUB_PROCESS_CHILD);
    public static final List<MigrationInstructionValidator> instructionValidators = Arrays.asList(MigrationInstructionValidators.SAME_ID_VALIDATOR, MigrationInstructionValidators.SAME_SCOPE, MigrationInstructionValidators.SAME_EVENT_SCOPE);

    @Override
    public List<MigrationInstruction> generate(ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
        ArrayList<MigrationInstruction> migrationInstructions = new ArrayList<MigrationInstruction>();
        this.generate(sourceProcessDefinition, targetProcessDefinition, sourceProcessDefinition, targetProcessDefinition, migrationInstructions);
        return migrationInstructions;
    }

    public void generate(ScopeImpl sourceScope, ScopeImpl targetScope, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition, List<MigrationInstruction> migrationInstructions) {
        for (ActivityImpl sourceActivity : sourceScope.getActivities()) {
            for (ActivityImpl targetActivity : targetScope.getActivities()) {
                MigrationInstructionImpl migrationInstruction = new MigrationInstructionImpl(sourceActivity.getId(), targetActivity.getId());
                if (!this.canBeMigrated(sourceActivity, sourceProcessDefinition, sourceActivityValidators) || !this.canBeMigrated(targetActivity, targetProcessDefinition, targetActivityValidators) || !this.isValidInstruction(migrationInstruction, sourceProcessDefinition, targetProcessDefinition)) continue;
                migrationInstructions.add(migrationInstruction);
                if (!sourceActivity.isScope() || !targetActivity.isScope()) continue;
                this.generate(sourceActivity, targetActivity, sourceProcessDefinition, targetProcessDefinition, migrationInstructions);
            }
        }
    }

    protected boolean canBeMigrated(ActivityImpl activity, ProcessDefinitionImpl processDefinition, List<MigrationActivityValidator> activityValidators) {
        for (MigrationActivityValidator activityValidator : activityValidators) {
            if (activityValidator.canBeMigrated(activity, processDefinition)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidInstruction(MigrationInstructionImpl instruction, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
        for (MigrationInstructionValidator instructionValidator : instructionValidators) {
            if (instructionValidator.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition)) continue;
            return false;
        }
        return true;
    }
}

