/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstanceWalker;
import org.camunda.bpm.engine.impl.migration.instance.MigratingExecutionBranch;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.validation.AdditionalFlowScopeValidator;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionInstanceValidator;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.impl.tree.TreeWalker;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigrateProcessInstanceCmd
implements Command<Void> {
    protected MigrationPlan migrationPlan;
    protected List<String> processInstanceIds;
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;

    public MigrateProcessInstanceCmd(MigrationPlan migrationPlan, List<String> processInstanceIds) {
        this.migrationPlan = migrationPlan;
        this.processInstanceIds = processInstanceIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessDefinitionEntity targetProcessDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.migrationPlan.getTargetProcessDefinitionId());
        for (String processInstanceId : this.processInstanceIds) {
            this.migrateProcessInstance(commandContext, processInstanceId, targetProcessDefinition);
        }
        return null;
    }

    public Void migrateProcessInstance(CommandContext commandContext, String processInstanceId, ProcessDefinitionEntity targetProcessDefinition) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        MigratingProcessInstance migratingProcessInstance = MigratingProcessInstance.initializeFrom(commandContext, this.migrationPlan, processInstance, targetProcessDefinition);
        this.validateInstructions(migratingProcessInstance);
        this.deleteUnmappedActivityInstances(migratingProcessInstance);
        this.migrateProcessInstance(migratingProcessInstance);
        return null;
    }

    protected void deleteUnmappedActivityInstances(MigratingProcessInstance migratingProcessInstance) {
        final HashSet visitedActivityInstances = new HashSet();
        Set<MigratingActivityInstance> leafInstances = this.collectLeafInstances(migratingProcessInstance);
        for (MigratingActivityInstance leafInstance : leafInstances) {
            MigratingActivityInstanceWalker walker = new MigratingActivityInstanceWalker(leafInstance);
            walker.addPreVisitor(new TreeVisitor<MigratingActivityInstance>(){

                @Override
                public void visit(MigratingActivityInstance currentInstance) {
                    visitedActivityInstances.add(currentInstance);
                    if (!currentInstance.migrates()) {
                        Set<MigratingActivityInstance> children = currentInstance.getChildren();
                        MigratingActivityInstance parent = currentInstance.getParent();
                        for (MigratingActivityInstance child : children) {
                            child.detachState();
                        }
                        currentInstance.remove();
                        for (MigratingActivityInstance child : children) {
                            child.attachState(parent.resolveRepresentativeExecution());
                            parent.getChildren().add(child);
                            child.setParent(parent);
                        }
                    } else {
                        currentInstance.removeUnmappedDependentInstances();
                    }
                }
            });
            walker.walkUntil(new TreeWalker.WalkCondition<MigratingActivityInstance>(){

                @Override
                public boolean isFulfilled(MigratingActivityInstance element) {
                    return element == null || !visitedActivityInstances.containsAll(element.getChildren());
                }
            });
        }
    }

    protected Set<MigratingActivityInstance> collectLeafInstances(MigratingProcessInstance migratingProcessInstance) {
        HashSet<MigratingActivityInstance> leafInstances = new HashSet<MigratingActivityInstance>();
        for (MigratingActivityInstance migratingActivityInstance : migratingProcessInstance.getMigratingActivityInstances()) {
            if (!migratingActivityInstance.getChildren().isEmpty()) continue;
            leafInstances.add(migratingActivityInstance);
        }
        return leafInstances;
    }

    protected void validateInstructions(MigratingProcessInstance migratingProcessInstance) {
        List<AdditionalFlowScopeValidator> validators = Collections.singletonList(new AdditionalFlowScopeValidator());
        MigrationInstructionInstanceValidationReportImpl validationReport = new MigrationInstructionInstanceValidationReportImpl(migratingProcessInstance);
        for (MigratingActivityInstance migratingActivityInstance : migratingProcessInstance.getMigratingActivityInstances()) {
            for (MigrationInstructionInstanceValidator migrationInstructionInstanceValidator : validators) {
                migrationInstructionInstanceValidator.validate(migratingProcessInstance, migratingActivityInstance, validationReport);
            }
        }
        if (validationReport.hasFailures()) {
            throw LOGGER.failingInstructionInstanceValidation(validationReport);
        }
    }

    protected void migrateProcessInstance(MigratingProcessInstance migratingProcessInstance) {
        MigratingActivityInstance rootActivityInstance = migratingProcessInstance.getMigratingInstance(migratingProcessInstance.getProcessInstanceId());
        MigratingExecutionBranch scopeExecutionContext = new MigratingExecutionBranch();
        scopeExecutionContext.visited(rootActivityInstance);
        this.migrateActivityInstance(migratingProcessInstance, scopeExecutionContext, rootActivityInstance);
    }

    protected void migrateActivityInstance(MigratingProcessInstance migratingProcessInstance, MigratingExecutionBranch migratingExecutionBranch, MigratingActivityInstance migratingActivityInstance) {
        ActivityInstance activityInstance = migratingActivityInstance.getActivityInstance();
        if (!activityInstance.getId().equals(activityInstance.getProcessInstanceId())) {
            ScopeImpl parentActivityInstanceTargetScope;
            MigratingActivityInstance parentMigratingInstance = migratingActivityInstance.getParent();
            ScopeImpl targetScope = migratingActivityInstance.getTargetScope();
            ScopeImpl targetFlowScope = targetScope.getFlowScope();
            if (targetFlowScope != (parentActivityInstanceTargetScope = parentMigratingInstance.getTargetScope())) {
                migratingActivityInstance.detachState();
                List<ScopeImpl> nonExistingScopes = this.collectNonExistingFlowScopes(targetFlowScope, migratingExecutionBranch);
                ScopeImpl existingScope = nonExistingScopes.isEmpty() ? targetFlowScope : nonExistingScopes.get(0).getFlowScope();
                ExecutionEntity ancestorScopeExecution = migratingExecutionBranch.getExecution(existingScope);
                this.instantiateScopes(ancestorScopeExecution, migratingExecutionBranch, nonExistingScopes);
                ExecutionEntity targetFlowScopeExecution = migratingExecutionBranch.getExecution(targetFlowScope);
                migratingActivityInstance.attachState(targetFlowScopeExecution);
            }
        }
        migratingActivityInstance.migrateState();
        migratingActivityInstance.migrateDependentEntities();
        migratingExecutionBranch = migratingExecutionBranch.copy();
        migratingExecutionBranch.visited(migratingActivityInstance);
        for (MigratingActivityInstance childInstance : migratingActivityInstance.getChildren()) {
            this.migrateActivityInstance(migratingProcessInstance, migratingExecutionBranch, childInstance);
        }
    }

    protected List<ScopeImpl> collectNonExistingFlowScopes(ScopeImpl scope, final MigratingExecutionBranch migratingExecutionBranch) {
        FlowScopeWalker walker = new FlowScopeWalker(scope);
        final LinkedList<ScopeImpl> result = new LinkedList<ScopeImpl>();
        walker.addPreVisitor(new TreeVisitor<ScopeImpl>(){

            @Override
            public void visit(ScopeImpl obj) {
                result.add(0, obj);
            }
        });
        walker.walkWhile(new TreeWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                return migratingExecutionBranch.hasExecution(element);
            }
        });
        return result;
    }

    protected void instantiateScopes(ExecutionEntity ancestorScopeExecution, MigratingExecutionBranch executionBranch, List<ScopeImpl> scopesToInstantiate) {
        if (scopesToInstantiate.isEmpty()) {
            return;
        }
        ExecutionEntity newParentExecution = ancestorScopeExecution;
        if (!ancestorScopeExecution.getNonEventScopeExecutions().isEmpty() || ancestorScopeExecution.getActivity() != null) {
            newParentExecution = (ExecutionEntity)ancestorScopeExecution.createConcurrentExecution();
        }
        Map<PvmActivity, PvmExecutionImpl> createdExecutions = newParentExecution.instantiateScopes(scopesToInstantiate);
        for (ScopeImpl scope : scopesToInstantiate) {
            ExecutionEntity createdExecution = (ExecutionEntity)createdExecutions.get(scope);
            createdExecution.setActivity(null);
            executionBranch.registerExecution(scope, createdExecution);
        }
    }
}

