/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.MigrationPlanValidationReportImpl;
import org.camunda.bpm.engine.migration.MigrationInstructionInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigrationLogger
extends ProcessEngineLogger {
    public ProcessEngineException unmappedActivityInstances(String processInstanceId, Set<ActivityInstance> unmappedInstances) {
        return new ProcessEngineException(this.exceptionMessage("001", "Process instance '{}' cannot be migrated. There are no migration instructions that apply to the following activity instances: {}", new Object[]{processInstanceId, this.formatActivityInstances(unmappedInstances)}));
    }

    public BadUserRequestException invalidMigrationPlan(MigrationPlan migrationPlan, List<String> errorMessages) {
        return new BadUserRequestException(this.exceptionMessage("002", "The provided migration plan is invalid: {}\n{}", new Object[]{migrationPlan, this.formatMigrationPlanErrors(errorMessages)}));
    }

    public MigrationInstructionInstanceValidationException failingInstructionInstanceValidation(MigrationInstructionInstanceValidationReportImpl validationReport) {
        StringBuilder sb = new StringBuilder();
        validationReport.writeTo(sb);
        return new MigrationInstructionInstanceValidationException(this.exceptionMessage("003", "Cannot migrate process instance {}: {}", new Object[]{validationReport.getMigratingProcessInstance().getProcessInstanceId(), sb.toString()}), validationReport);
    }

    public MigrationPlanValidationException failingMigrationPlanValidation(MigrationPlanValidationReportImpl validationReport) {
        StringBuilder sb = new StringBuilder();
        validationReport.writeTo(sb);
        return new MigrationPlanValidationException(this.exceptionMessage("004", "Cannot migrate process definition {} to {}: {}", new Object[]{validationReport.getMigrationPlan().getSourceProcessDefinitionId(), validationReport.getMigrationPlan().getTargetProcessDefinitionId(), sb.toString()}), validationReport);
    }

    protected String formatActivityInstances(Collection<ActivityInstance> activityInstances) {
        StringBuilder sb = new StringBuilder();
        Iterator<ActivityInstance> iterator = activityInstances.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next().getId());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    protected String formatMigrationPlanErrors(List<String> errorMessages) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = errorMessages.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

