/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.MigrationPlanBuilder;
import org.camunda.bpm.engine.impl.cmd.CreateMigrationPlanCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.migration.MigrationInstructionImpl;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class MigrationPlanBuilderImpl
implements MigrationPlanBuilder {
    protected CommandExecutor commandExecutor;
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected boolean mapEqualActivities = false;
    protected List<MigrationInstructionImpl> explicitMigrationInstructions;

    public MigrationPlanBuilderImpl(CommandExecutor commandExecutor, String sourceProcessDefinitionId, String targetProcessDefinitionId) {
        this.commandExecutor = commandExecutor;
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
        this.targetProcessDefinitionId = targetProcessDefinitionId;
        this.explicitMigrationInstructions = new ArrayList<MigrationInstructionImpl>();
    }

    @Override
    public MigrationPlanBuilder mapEqualActivities() {
        this.mapEqualActivities = true;
        return this;
    }

    @Override
    public MigrationPlanBuilder mapActivities(String sourceActivityId, String targetActivityId) {
        return this.mapActivities(Collections.singletonList(sourceActivityId), Collections.singletonList(targetActivityId));
    }

    @Override
    public MigrationPlanBuilder mapActivities(List<String> sourceActivityIds, List<String> targetActivityIds) {
        this.explicitMigrationInstructions.add(new MigrationInstructionImpl(sourceActivityIds, targetActivityIds));
        return this;
    }

    public String getSourceProcessDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public String getTargetProcessDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public boolean isMapEqualActivities() {
        return this.mapEqualActivities;
    }

    public List<MigrationInstructionImpl> getExplicitMigrationInstructions() {
        return this.explicitMigrationInstructions;
    }

    @Override
    public MigrationPlan build() {
        return this.commandExecutor.execute(new CreateMigrationPlanCmd(this));
    }
}

