/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.migration.instance.EmergingInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingInstance;
import org.camunda.bpm.engine.impl.migration.instance.RemovingInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigratingActivityInstance
implements MigratingInstance,
RemovingInstance {
    protected MigrationInstruction migrationInstruction;
    protected ActivityInstance activityInstance;
    protected ExecutionEntity representativeExecution;
    protected List<RemovingInstance> removingDependentInstances = new ArrayList<RemovingInstance>();
    protected List<MigratingInstance> migratingDependentInstances = new ArrayList<MigratingInstance>();
    protected List<EmergingInstance> emergingDependentInstances = new ArrayList<EmergingInstance>();
    protected ScopeImpl sourceScope;
    protected ScopeImpl targetScope;
    protected Set<MigratingActivityInstance> childInstances;
    protected MigratingActivityInstance parentInstance;
    protected MigratingActivityInstanceBehavior instanceBehavior;

    public MigratingActivityInstance(ActivityInstance activityInstance, MigrationInstruction migrationInstruction, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        this.activityInstance = activityInstance;
        this.migrationInstruction = migrationInstruction;
        this.sourceScope = sourceScope;
        this.targetScope = targetScope;
        this.representativeExecution = scopeExecution;
        this.instanceBehavior = sourceScope.isScope() ? new MigratingScopeActivityInstanceBehavior() : new MigratingNonScopeActivityInstanceBehavior();
    }

    @Override
    public void detachState() {
        this.instanceBehavior.detachState();
    }

    @Override
    public void attachState(ExecutionEntity newScopeExecution) {
        this.instanceBehavior.attachState(newScopeExecution);
    }

    @Override
    public void migrateDependentEntities() {
        for (MigratingInstance migratingInstance : this.migratingDependentInstances) {
            migratingInstance.migrateState();
            migratingInstance.migrateDependentEntities();
        }
        ExecutionEntity representativeExecution = this.resolveRepresentativeExecution();
        for (EmergingInstance emergingInstance : this.emergingDependentInstances) {
            emergingInstance.create(representativeExecution);
        }
    }

    public ExecutionEntity resolveRepresentativeExecution() {
        return this.instanceBehavior.resolveRepresentativeExecution();
    }

    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.migratingDependentInstances.add(migratingInstance);
    }

    public void addRemovingDependentInstance(RemovingInstance removingInstance) {
        this.removingDependentInstances.add(removingInstance);
    }

    public void addEmergingDependentInstance(EmergingInstance emergingInstance) {
        this.emergingDependentInstances.add(emergingInstance);
    }

    public ActivityInstance getActivityInstance() {
        return this.activityInstance;
    }

    public ScopeImpl getSourceScope() {
        return this.sourceScope;
    }

    public ScopeImpl getTargetScope() {
        return this.targetScope;
    }

    public Set<MigratingActivityInstance> getChildren() {
        return this.childInstances;
    }

    public MigratingActivityInstance getParent() {
        return this.parentInstance;
    }

    public void setParent(MigratingActivityInstance parentInstance) {
        this.parentInstance = parentInstance;
    }

    public MigrationInstruction getMigrationInstruction() {
        return this.migrationInstruction;
    }

    public boolean migrates() {
        return this.targetScope != null;
    }

    public void removeUnmappedDependentInstances() {
        for (RemovingInstance removingInstance : this.removingDependentInstances) {
            removingInstance.remove();
        }
    }

    @Override
    public void remove() {
        this.instanceBehavior.remove();
    }

    @Override
    public void migrateState() {
        this.instanceBehavior.migrateState();
    }

    protected class MigratingScopeActivityInstanceBehavior
    implements MigratingActivityInstanceBehavior {
        protected MigratingScopeActivityInstanceBehavior() {
        }

        @Override
        public void detachState() {
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            ExecutionEntity parentExecution = currentScopeExecution.getParent();
            ExecutionEntity parentScopeExecution = parentExecution.isConcurrent() ? parentExecution.getParent() : parentExecution;
            currentScopeExecution.setParent(null);
            if (parentExecution.isConcurrent()) {
                parentExecution.remove();
                parentScopeExecution.tryPruneLastConcurrentChild();
                parentScopeExecution.forceUpdate();
            } else if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof CompositeActivityBehavior) {
                parentExecution.leaveActivityInstance();
            }
        }

        @Override
        public void attachState(ExecutionEntity newScopeExecution) {
            ExecutionEntity newParentExecution = newScopeExecution;
            if (!newScopeExecution.getNonEventScopeExecutions().isEmpty()) {
                newParentExecution = (ExecutionEntity)newScopeExecution.createConcurrentExecution();
                newScopeExecution.forceUpdate();
            }
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            currentScopeExecution.setParent(newParentExecution);
            if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof CompositeActivityBehavior) {
                newParentExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            }
        }

        @Override
        public void migrateState() {
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            currentScopeExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            ExecutionEntity parentExecution = currentScopeExecution.getParent();
            if (parentExecution != null && parentExecution.isConcurrent()) {
                parentExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            }
            if (!MigratingActivityInstance.this.targetScope.isScope()) {
                this.becomeNonScope();
                currentScopeExecution = this.resolveRepresentativeExecution();
            }
            if (this.isLeafActivity(MigratingActivityInstance.this.targetScope)) {
                currentScopeExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.targetScope));
            }
        }

        protected void becomeNonScope() {
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.detachState();
            }
            ExecutionEntity parentExecution = MigratingActivityInstance.this.representativeExecution.getParent();
            parentExecution.setActivity(MigratingActivityInstance.this.representativeExecution.getActivity());
            parentExecution.setActivityInstanceId(MigratingActivityInstance.this.representativeExecution.getActivityInstanceId());
            MigratingActivityInstance.this.representativeExecution.remove();
            MigratingActivityInstance.this.representativeExecution = parentExecution;
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.attachState(MigratingActivityInstance.this.representativeExecution);
            }
            MigratingActivityInstance.this.instanceBehavior = new MigratingNonScopeActivityInstanceBehavior();
        }

        protected boolean isLeafActivity(ScopeImpl scope) {
            return scope.getActivities().isEmpty();
        }

        @Override
        public ExecutionEntity resolveRepresentativeExecution() {
            return MigratingActivityInstance.this.representativeExecution;
        }

        @Override
        public void remove() {
            MigratingActivityInstance.this.parentInstance.getChildren().remove(MigratingActivityInstance.this);
            for (MigratingActivityInstance child : MigratingActivityInstance.this.childInstances) {
                child.parentInstance = null;
            }
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            ExecutionEntity parentExecution = currentExecution.getParent();
            currentExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.sourceScope));
            currentExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            currentExecution.deleteCascade("migration");
            if (parentExecution.isConcurrent()) {
                ExecutionEntity grandParent = parentExecution.getParent();
                parentExecution.remove();
                grandParent.tryPruneLastConcurrentChild();
                grandParent.forceUpdate();
            }
        }
    }

    protected class MigratingNonScopeActivityInstanceBehavior
    implements MigratingActivityInstanceBehavior {
        protected MigratingNonScopeActivityInstanceBehavior() {
        }

        @Override
        public void detachState() {
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution.setActivity(null);
            currentExecution.leaveActivityInstance();
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.detachState();
            }
            if (!currentExecution.isScope()) {
                ExecutionEntity parent = currentExecution.getParent();
                currentExecution.remove();
                parent.tryPruneLastConcurrentChild();
                parent.forceUpdate();
            }
        }

        @Override
        public void attachState(ExecutionEntity newScopeExecution) {
            MigratingActivityInstance.this.representativeExecution = newScopeExecution;
            if (!newScopeExecution.getNonEventScopeExecutions().isEmpty() || newScopeExecution.getActivity() != null) {
                MigratingActivityInstance.this.representativeExecution = (ExecutionEntity)newScopeExecution.createConcurrentExecution();
                newScopeExecution.forceUpdate();
            }
            MigratingActivityInstance.this.representativeExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.sourceScope));
            MigratingActivityInstance.this.representativeExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.attachState(MigratingActivityInstance.this.representativeExecution);
            }
        }

        @Override
        public void migrateState() {
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            currentExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.targetScope));
            if (MigratingActivityInstance.this.targetScope.isScope()) {
                this.becomeScope();
            }
        }

        protected void becomeScope() {
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.detachState();
            }
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution = currentExecution.createExecution();
            ExecutionEntity parent = currentExecution.getParent();
            parent.setActivity(null);
            if (!parent.isConcurrent()) {
                parent.leaveActivityInstance();
            }
            MigratingActivityInstance.this.representativeExecution = currentExecution;
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.attachState(currentExecution);
            }
            MigratingActivityInstance.this.instanceBehavior = new MigratingScopeActivityInstanceBehavior();
        }

        @Override
        public ExecutionEntity resolveRepresentativeExecution() {
            if (MigratingActivityInstance.this.representativeExecution.getReplacedBy() != null) {
                return MigratingActivityInstance.this.representativeExecution.resolveReplacedBy();
            }
            return MigratingActivityInstance.this.representativeExecution;
        }

        @Override
        public void remove() {
        }
    }

    protected static interface MigratingActivityInstanceBehavior {
        public void detachState();

        public void attachState(ExecutionEntity var1);

        public void migrateState();

        public void remove();

        public ExecutionEntity resolveRepresentativeExecution();
    }
}

