/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.ActivityExecutionTreeMapping;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingEventSubscriptionInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingFailedJobIncident;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTaskInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTimerJobInstance;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Incident;

public class MigratingProcessInstance {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected String processInstanceId;
    protected Map<String, MigratingActivityInstance> migratingActivityInstances;

    public MigratingProcessInstance(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.migratingActivityInstances = new HashMap<String, MigratingActivityInstance>();
    }

    public Collection<MigratingActivityInstance> getMigratingActivityInstances() {
        return this.migratingActivityInstances.values();
    }

    public MigratingActivityInstance getMigratingInstance(String activityInstanceId) {
        return this.migratingActivityInstances.get(activityInstanceId);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    protected MigratingActivityInstance addActivityInstance(MigrationInstruction migrationInstruction, ActivityInstance activityInstance, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        MigratingActivityInstance migratingActivityInstance = new MigratingActivityInstance(activityInstance, migrationInstruction, sourceScope, targetScope, scopeExecution);
        this.migratingActivityInstances.put(activityInstance.getId(), migratingActivityInstance);
        return migratingActivityInstance;
    }

    public static MigratingProcessInstance initializeFrom(CommandContext commandContext, MigrationPlan migrationPlan, ExecutionEntity processInstance, ProcessDefinitionImpl targetProcessDefinition) {
        MigratingProcessInstance migratingProcessInstance = new MigratingProcessInstance(processInstance.getId());
        ProcessDefinitionImpl sourceProcessDefinition = processInstance.getProcessDefinition();
        ActivityExecutionTreeMapping mapping = new ActivityExecutionTreeMapping(commandContext, processInstance.getId());
        ActivityInstance activityInstanceTree = new GetActivityInstanceCmd(processInstance.getId()).execute(commandContext);
        Set<ActivityInstance> activityInstances = MigratingProcessInstance.flatten(activityInstanceTree);
        HashSet<ActivityInstance> unmappedLeafInstances = new HashSet<ActivityInstance>();
        migratingProcessInstance.addActivityInstance(null, activityInstanceTree, sourceProcessDefinition, targetProcessDefinition, processInstance);
        activityInstances.remove(activityInstanceTree);
        Map<String, List<MigrationInstruction>> organizedInstructions = MigratingProcessInstance.organizeInstructionsBySourceScope(migrationPlan);
        for (ActivityInstance instance : activityInstances) {
            MigratingActivityInstance migratingInstance;
            ActivityImpl sourceActivity = sourceProcessDefinition.findActivity(instance.getActivityId());
            MigrationInstruction applyingInstruction = MigratingProcessInstance.findMigrationInstructionForActivityId(sourceActivity.getId(), organizedInstructions);
            ActivityImpl targetActivity = null;
            if (applyingInstruction != null) {
                targetActivity = MigratingProcessInstance.findTargetActivityForInstruction(applyingInstruction, targetProcessDefinition);
            } else if (MigratingProcessInstance.isLeafActivity(instance)) {
                unmappedLeafInstances.add(instance);
            }
            if (!(migratingInstance = migratingProcessInstance.addActivityInstance(applyingInstruction, instance, sourceActivity, targetActivity, mapping.getExecution(instance))).migrates()) continue;
            MigratingProcessInstance.initializeDependentInstances(migratingInstance, sourceActivity, targetProcessDefinition, organizedInstructions);
        }
        if (!unmappedLeafInstances.isEmpty()) {
            throw LOGGER.unmappedActivityInstances(processInstance.getId(), unmappedLeafInstances);
        }
        MigratingProcessInstance.initializeParentChildRelationships(migratingProcessInstance);
        return migratingProcessInstance;
    }

    protected static boolean isLeafActivity(ActivityInstance instance) {
        return instance.getChildActivityInstances().length == 0;
    }

    protected static void initializeDependentInstances(MigratingActivityInstance migratingInstance, ActivityImpl sourceActivity, ProcessDefinitionImpl targetProcessDefinition, Map<String, List<MigrationInstruction>> organizedInstructions) {
        MigratingProcessInstance.initializeDependentTaskInstances(migratingInstance, sourceActivity);
        MigratingProcessInstance.initializeDependentEventSubscriptionInstances(migratingInstance, targetProcessDefinition, organizedInstructions);
        MigratingProcessInstance.initializeDependentTimerJobInstances(migratingInstance, targetProcessDefinition, organizedInstructions);
    }

    protected static void initializeDependentTaskInstances(MigratingActivityInstance migratingInstance, ActivityImpl sourceActivity) {
        if (sourceActivity.getActivityBehavior() instanceof UserTaskActivityBehavior) {
            List<TaskEntity> tasks = migratingInstance.representativeExecution.getTasks();
            migratingInstance.addMigratingDependentInstance(new MigratingTaskInstance(tasks.get(0), migratingInstance));
        }
    }

    protected static void initializeDependentEventSubscriptionInstances(MigratingActivityInstance migratingInstance, ProcessDefinitionImpl targetProcessDefinition, Map<String, List<MigrationInstruction>> organizedInstructions) {
        ArrayList<String> migratedEventSubscriptionTargetActivityIds = new ArrayList<String>();
        for (EventSubscriptionEntity eventSubscription : migratingInstance.representativeExecution.getEventSubscriptions()) {
            MigrationInstruction eventSubscriptionMigrationInstruction = MigratingProcessInstance.findMigrationInstructionForActivityId(eventSubscription.getActivityId(), organizedInstructions);
            if (eventSubscriptionMigrationInstruction != null) {
                ActivityImpl eventSubscriptionTargetActivity = MigratingProcessInstance.findTargetActivityForInstruction(eventSubscriptionMigrationInstruction, targetProcessDefinition);
                migratedEventSubscriptionTargetActivityIds.add(eventSubscriptionTargetActivity.getId());
                migratingInstance.addMigratingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscription, eventSubscriptionTargetActivity));
                continue;
            }
            migratingInstance.addRemovingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscription));
        }
        List<EventSubscriptionDeclaration> emergingEventSubscriptionDeclarations = MigratingProcessInstance.findEmergingEventSubscriptionDeclarations(migratingInstance, migratedEventSubscriptionTargetActivityIds);
        for (EventSubscriptionDeclaration emergingEventSubscriptionDeclaration : emergingEventSubscriptionDeclarations) {
            migratingInstance.addEmergingDependentInstance(new MigratingEventSubscriptionInstance(emergingEventSubscriptionDeclaration));
        }
    }

    protected static List<EventSubscriptionDeclaration> findEmergingEventSubscriptionDeclarations(MigratingActivityInstance migratingInstance, List<String> migratedEventSubscriptionTargetActivityIds) {
        ArrayList<EventSubscriptionDeclaration> emergingEventSubscriptionDeclarations = new ArrayList<EventSubscriptionDeclaration>();
        for (EventSubscriptionDeclaration eventSubscriptionDeclaration : EventSubscriptionDeclaration.getDeclarationsForScope(migratingInstance.getTargetScope())) {
            if (migratedEventSubscriptionTargetActivityIds.contains(eventSubscriptionDeclaration.getActivityId())) continue;
            emergingEventSubscriptionDeclarations.add(eventSubscriptionDeclaration);
        }
        return emergingEventSubscriptionDeclarations;
    }

    protected static void initializeDependentTimerJobInstances(MigratingActivityInstance migratingInstance, ProcessDefinitionImpl targetProcessDefinition, Map<String, List<MigrationInstruction>> organizedInstructions) {
        Map<String, JobDefinitionEntity> jobDefinitionsByActivityId = MigratingProcessInstance.collectJobDefinitionsForActivityIds(targetProcessDefinition.getId());
        ArrayList<String> migratedTimerJobTargetActivityIds = new ArrayList<String>();
        for (JobEntity job : migratingInstance.representativeExecution.getJobs()) {
            if (!MigratingProcessInstance.isTimerJob(job)) continue;
            MigrationInstruction timerJobMigrationInstruction = MigratingProcessInstance.findMigrationInstructionForActivityId(job.getActivityId(), organizedInstructions);
            if (timerJobMigrationInstruction != null) {
                ActivityImpl timerJobTargetActivity = MigratingProcessInstance.findTargetActivityForInstruction(timerJobMigrationInstruction, targetProcessDefinition);
                migratedTimerJobTargetActivityIds.add(timerJobTargetActivity.getId());
                JobDefinitionEntity jobDefinitionEntity = jobDefinitionsByActivityId.get(timerJobTargetActivity.getActivityId());
                MigratingTimerJobInstance migratingTimerJobInstance = new MigratingTimerJobInstance(job, jobDefinitionEntity, timerJobTargetActivity);
                MigratingProcessInstance.addFailingJobIncidentsAsDependentInstances(job, migratingInstance.getTargetScope(), migratingTimerJobInstance);
                migratingInstance.addMigratingDependentInstance(migratingTimerJobInstance);
                continue;
            }
            migratingInstance.addRemovingDependentInstance(new MigratingTimerJobInstance(job));
        }
        for (TimerDeclarationImpl emergingTimerDeclaration : MigratingProcessInstance.findEmergingTimerDeclarations(migratingInstance, migratedTimerJobTargetActivityIds)) {
            migratingInstance.addEmergingDependentInstance(new MigratingTimerJobInstance(emergingTimerDeclaration));
        }
    }

    protected static List<TimerDeclarationImpl> findEmergingTimerDeclarations(MigratingActivityInstance migratingInstance, List<String> migratedTimerJobTargetActivityIds) {
        ArrayList<TimerDeclarationImpl> emergingTimerDeclarations = new ArrayList<TimerDeclarationImpl>();
        for (TimerDeclarationImpl timerDeclaration : TimerDeclarationImpl.getDeclarationsForScope(migratingInstance.getTargetScope())) {
            if (migratedTimerJobTargetActivityIds.contains(timerDeclaration.getActivityId())) continue;
            emergingTimerDeclarations.add(timerDeclaration);
        }
        return emergingTimerDeclarations;
    }

    protected static void addFailingJobIncidentsAsDependentInstances(JobEntity job, ScopeImpl targetScope, MigratingTimerJobInstance migratingTimerJobInstance) {
        List<Incident> incidents = Context.getCommandContext().getIncidentManager().findIncidentByConfigurationAndIncidentType(job.getId(), "failedJob");
        for (Incident incident : incidents) {
            MigratingFailedJobIncident migratingIncident = new MigratingFailedJobIncident((IncidentEntity)incident, targetScope);
            migratingTimerJobInstance.addMigratingDependentInstance(migratingIncident);
        }
    }

    protected static Set<ActivityInstance> flatten(ActivityInstance activityInstance) {
        HashSet<ActivityInstance> instances = new HashSet<ActivityInstance>();
        instances.add(activityInstance);
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            instances.addAll(MigratingProcessInstance.flatten(childInstance));
        }
        return instances;
    }

    protected static Map<String, List<MigrationInstruction>> organizeInstructionsBySourceScope(MigrationPlan migrationPlan) {
        HashMap<String, List<MigrationInstruction>> organizedInstructions = new HashMap<String, List<MigrationInstruction>>();
        for (MigrationInstruction instruction : migrationPlan.getInstructions()) {
            CollectionUtil.addToMapOfLists(organizedInstructions, instruction.getSourceActivityIds().get(0), instruction);
        }
        return organizedInstructions;
    }

    protected static ActivityImpl findTargetActivityForInstruction(MigrationInstruction instruction, ProcessDefinitionImpl processDefinition) {
        String activityId = instruction.getTargetActivityIds().get(0);
        return processDefinition.findActivity(activityId);
    }

    protected static Map<String, JobDefinitionEntity> collectJobDefinitionsForActivityIds(String processDefinitionId) {
        List<JobDefinitionEntity> jobDefinitions = Context.getCommandContext().getJobDefinitionManager().findByProcessDefinitionId(processDefinitionId);
        HashMap<String, JobDefinitionEntity> jobDefinitionsByActivityId = new HashMap<String, JobDefinitionEntity>();
        for (JobDefinitionEntity jobDefinition : jobDefinitions) {
            jobDefinitionsByActivityId.put(jobDefinition.getActivityId(), jobDefinition);
        }
        return jobDefinitionsByActivityId;
    }

    protected static MigrationInstruction findMigrationInstructionForActivityId(String activityId, Map<String, List<MigrationInstruction>> organizedInstructions) {
        List<MigrationInstruction> migrationInstructions = organizedInstructions.get(activityId);
        if (migrationInstructions != null && !migrationInstructions.isEmpty()) {
            return migrationInstructions.get(0);
        }
        return null;
    }

    protected static boolean isTimerJob(JobEntity job) {
        return job != null && job.getType().equals("timer");
    }

    protected static void initializeParentChildRelationships(MigratingProcessInstance migratingProcessInstance) {
        for (MigratingActivityInstance migratingActivityInstance : migratingProcessInstance.migratingActivityInstances.values()) {
            ActivityInstance activityInstance = migratingActivityInstance.getActivityInstance();
            migratingActivityInstance.parentInstance = migratingProcessInstance.getMigratingInstance(activityInstance.getParentActivityInstanceId());
            migratingActivityInstance.childInstances = new HashSet<MigratingActivityInstance>();
            for (ActivityInstance childActivityInstance : activityInstance.getChildActivityInstances()) {
                migratingActivityInstance.childInstances.add(migratingProcessInstance.getMigratingInstance(childActivityInstance.getId()));
            }
        }
    }
}

