/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.migration.instance.EmergingInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingInstance;
import org.camunda.bpm.engine.impl.migration.instance.RemovingInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class MigratingTimerJobInstance
implements MigratingInstance,
RemovingInstance,
EmergingInstance {
    protected JobEntity jobEntity;
    protected JobDefinitionEntity targetJobDefinitionEntity;
    protected ScopeImpl targetScope;
    protected TimerDeclarationImpl timerDeclaration;
    protected List<MigratingInstance> migratingDependentInstances = new ArrayList<MigratingInstance>();

    public MigratingTimerJobInstance(JobEntity jobEntity, JobDefinitionEntity jobDefinitionEntity, ScopeImpl targetScope) {
        this.jobEntity = jobEntity;
        this.targetJobDefinitionEntity = jobDefinitionEntity;
        this.targetScope = targetScope;
    }

    public MigratingTimerJobInstance(JobEntity jobEntity) {
        this(jobEntity, null, null);
    }

    public MigratingTimerJobInstance(TimerDeclarationImpl timerDeclaration) {
        this.timerDeclaration = timerDeclaration;
    }

    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.migratingDependentInstances.add(migratingInstance);
    }

    @Override
    public void detachState() {
        this.jobEntity.setExecution(null);
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.detachState();
        }
    }

    @Override
    public void attachState(ExecutionEntity newScopeExecution) {
        this.jobEntity.setExecution(newScopeExecution);
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.attachState(newScopeExecution);
        }
    }

    @Override
    public void migrateState() {
        String activityId = this.targetScope.getId();
        this.jobEntity.setActivityId(activityId);
        this.updateJobConfiguration(activityId);
        if (this.targetJobDefinitionEntity != null) {
            this.jobEntity.setJobDefinition(this.targetJobDefinitionEntity);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.targetScope.getProcessDefinition();
        this.jobEntity.setProcessDefinitionId(processDefinition.getId());
        this.jobEntity.setProcessDefinitionKey(processDefinition.getKey());
    }

    @Override
    public void migrateDependentEntities() {
        for (MigratingInstance migratingDependentInstance : this.migratingDependentInstances) {
            migratingDependentInstance.migrateState();
        }
    }

    @Override
    public void create(ExecutionEntity scopeExecution) {
        this.timerDeclaration.createTimer(scopeExecution);
    }

    @Override
    public void remove() {
        this.jobEntity.delete();
    }

    protected void updateJobConfiguration(String activityId) {
        String configuration = this.jobEntity.getJobHandlerConfiguration();
        configuration = TimerEventJobHandler.updateKeyInConfiguration(configuration, activityId);
        this.jobEntity.setJobHandlerConfiguration(configuration);
    }
}

