/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation;

import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionInstanceValidator;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class AdditionalFlowScopeValidator
implements MigrationInstructionInstanceValidator {
    @Override
    public void validate(MigratingProcessInstance migratingProcessInstance, MigratingActivityInstance migratingActivityInstance, MigrationInstructionInstanceValidationReportImpl validationReport) {
        ScopeImpl parentInstanceTargetScope;
        MigratingActivityInstance ancestorInstance = this.getClosestPreservedAncestorInstance(migratingActivityInstance);
        ScopeImpl targetScope = migratingActivityInstance.getTargetScope();
        if (ancestorInstance != null && targetScope != null && targetScope != targetScope.getProcessDefinition() && (parentInstanceTargetScope = ancestorInstance.getTargetScope()) != null && !parentInstanceTargetScope.isAncestorFlowScopeOf(targetScope)) {
            validationReport.addValidationFailure(migratingActivityInstance, "Closest migrating ancestor activity instance is migrated to activity '" + parentInstanceTargetScope.getId() + "' which is not an ancestor of target activity '" + targetScope.getId() + "'");
        }
    }

    protected MigratingActivityInstance getClosestPreservedAncestorInstance(MigratingActivityInstance activityInstance) {
        MigratingActivityInstance parent;
        for (parent = activityInstance.getParent(); parent != null && parent.getTargetScope() == null; parent = parent.getParent()) {
        }
        return parent;
    }
}

