/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.migration.validation.AbstractMigrationActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.MigrationActivityValidator;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.TreeWalker;

public class MigrationActivityValidators {
    public static final MigrationActivityValidator SUPPORTED_ACTIVITY = new AbstractMigrationActivityValidator(){
        public final Set<Class<? extends ActivityBehavior>> SUPPORTED_ACTIVITY_BEHAVIORS = new HashSet<Class>(Arrays.asList(SubProcessActivityBehavior.class, UserTaskActivityBehavior.class, BoundaryEventActivityBehavior.class));

        @Override
        public boolean canBeMigrated(ActivityImpl activity, ProcessDefinitionImpl processDefinition) {
            return this.SUPPORTED_ACTIVITY_BEHAVIORS.contains(activity.getActivityBehavior().getClass());
        }
    };
    public static final MigrationActivityValidator NOT_MULTI_INSTANCE_CHILD = new AbstractMigrationActivityValidator(){

        @Override
        public boolean canBeMigrated(ActivityImpl activity, ProcessDefinitionImpl processDefinition) {
            return !MigrationActivityValidators.hasMultiInstanceParent(activity);
        }
    };
    public static final MigrationActivityValidator SUPPORTED_BOUNDARY_EVENT = new AbstractMigrationActivityValidator(){
        public final List<String> supportedTypes = Arrays.asList("boundaryMessage", "boundarySignal", "boundaryTimer");

        @Override
        public boolean canBeMigrated(ActivityImpl activity, ProcessDefinitionImpl processDefinition) {
            if (activity.getActivityBehavior().getClass().isAssignableFrom(BoundaryEventActivityBehavior.class)) {
                String boundaryType = (String)activity.getProperty("type");
                return this.supportedTypes.contains(boundaryType);
            }
            return true;
        }
    };
    public static final MigrationActivityValidator NOT_EVENT_SUB_PROCESS_CHILD = new AbstractMigrationActivityValidator(){

        @Override
        public boolean canBeMigrated(ActivityImpl activity, ProcessDefinitionImpl processDefinition) {
            return !MigrationActivityValidators.hasEventSubProcessParent(activity);
        }
    };
    public static final MigrationActivityValidator HAS_NO_EVENT_SUB_PROCESS_CHILD = new AbstractMigrationActivityValidator(){

        @Override
        public boolean canBeMigrated(ActivityImpl activity, ProcessDefinitionImpl processDefinition) {
            return !MigrationActivityValidators.hasEventSubProcessChildOrSibling(activity);
        }
    };

    protected static boolean hasMultiInstanceParent(ActivityImpl activity) {
        FlowScopeWalker flowScopeWalker = new FlowScopeWalker(activity);
        flowScopeWalker.walkUntil(new TreeWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                return MigrationActivityValidators.isProcessDefinition(element) || MigrationActivityValidators.isMultiInstance(element);
            }
        });
        return MigrationActivityValidators.isMultiInstance((ScopeImpl)flowScopeWalker.getCurrentElement());
    }

    protected static boolean isMultiInstance(ScopeImpl scope) {
        return !MigrationActivityValidators.isProcessDefinition(scope) && scope.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
    }

    protected static boolean hasEventSubProcessParent(ActivityImpl activity) {
        FlowScopeWalker flowScopeWalker = new FlowScopeWalker(activity);
        flowScopeWalker.walkUntil(new TreeWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                return MigrationActivityValidators.isProcessDefinition(element) || MigrationActivityValidators.isEventSubProcess(element);
            }
        });
        return MigrationActivityValidators.isEventSubProcess((ScopeImpl)flowScopeWalker.getCurrentElement());
    }

    protected static boolean isEventSubProcess(ScopeImpl scope) {
        return !MigrationActivityValidators.isProcessDefinition(scope) && scope.getActivityBehavior() instanceof EventSubProcessActivityBehavior;
    }

    protected static boolean hasEventSubProcessChildOrSibling(ActivityImpl activity) {
        if (MigrationActivityValidators.isScope(activity) || MigrationActivityValidators.isProcessDefinition(activity.getFlowScope())) {
            List<ActivityImpl> activitiesToCheck = !MigrationActivityValidators.isScope(activity) && MigrationActivityValidators.isProcessDefinition(activity.getFlowScope()) ? activity.getFlowScope().getActivities() : activity.getActivities();
            for (ActivityImpl activityToCheck : activitiesToCheck) {
                ActivityBehavior activityBehavior = activityToCheck.getActivityBehavior();
                if (!(activityBehavior instanceof EventSubProcessActivityBehavior)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isProcessDefinition(ScopeImpl scope) {
        return scope == scope.getProcessDefinition();
    }

    protected static boolean isScope(ActivityImpl activity) {
        return activity.isScope();
    }
}

