/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionInstanceValidationFailureImpl;
import org.camunda.bpm.engine.migration.MigrationInstructionInstanceValidationFailure;
import org.camunda.bpm.engine.migration.MigrationInstructionInstanceValidationReport;

public class MigrationInstructionInstanceValidationReportImpl
implements MigrationInstructionInstanceValidationReport {
    protected MigratingProcessInstance migratingProcessInstance;
    protected List<MigrationInstructionInstanceValidationFailureImpl> validationFailures = new ArrayList<MigrationInstructionInstanceValidationFailureImpl>();

    public MigrationInstructionInstanceValidationReportImpl(MigratingProcessInstance migratingProcessInstance) {
        this.migratingProcessInstance = migratingProcessInstance;
    }

    public void addValidationFailure(MigratingActivityInstance activityInstance, String errorMessage) {
        this.validationFailures.add(new MigrationInstructionInstanceValidationFailureImpl(activityInstance, errorMessage));
    }

    public boolean hasFailures() {
        return !this.validationFailures.isEmpty();
    }

    public MigratingProcessInstance getMigratingProcessInstance() {
        return this.migratingProcessInstance;
    }

    @Override
    public List<MigrationInstructionInstanceValidationFailure> getValidationFailures() {
        return this.validationFailures;
    }

    public void writeTo(StringBuilder sb) {
        sb.append("Migration plan is not valid for process:\n");
        for (MigrationInstructionInstanceValidationFailureImpl failure : this.validationFailures) {
            failure.writeTo(sb);
            sb.append("\n");
        }
    }

    @Override
    public String getProcessInstanceId() {
        return this.migratingProcessInstance.getProcessInstanceId();
    }
}

