/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.migration.validation.MigrationActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.MigrationActivityValidators;
import org.camunda.bpm.engine.impl.migration.validation.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class MigrationInstructionValidators {
    public static final MigrationInstructionValidator ACTIVITIES_CAN_BE_MIGRATED = new MigrationInstructionValidator(){
        public final List<MigrationActivityValidator> sourceActivityValidators = Arrays.asList(MigrationActivityValidators.SUPPORTED_ACTIVITY, MigrationActivityValidators.SUPPORTED_BOUNDARY_EVENT, MigrationActivityValidators.NOT_MULTI_INSTANCE_CHILD, MigrationActivityValidators.NOT_EVENT_SUB_PROCESS_CHILD, MigrationActivityValidators.HAS_NO_EVENT_SUB_PROCESS_CHILD);
        public final List<MigrationActivityValidator> targetActivityValidators = Arrays.asList(MigrationActivityValidators.SUPPORTED_ACTIVITY, MigrationActivityValidators.SUPPORTED_BOUNDARY_EVENT, MigrationActivityValidators.NOT_MULTI_INSTANCE_CHILD, MigrationActivityValidators.NOT_EVENT_SUB_PROCESS_CHILD, MigrationActivityValidators.HAS_NO_EVENT_SUB_PROCESS_CHILD);

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return this.canActivitiesBeMigrated(instruction.getSourceActivityIds(), sourceProcessDefinition, this.sourceActivityValidators) && this.canActivitiesBeMigrated(instruction.getTargetActivityIds(), targetProcessDefinition, this.targetActivityValidators);
        }

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, List<MigrationInstruction> instructions, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return this.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition);
        }

        protected boolean canActivitiesBeMigrated(List<String> activityIds, ProcessDefinitionImpl processDefinition, List<MigrationActivityValidator> activityValidators) {
            for (String activityId : activityIds) {
                if (this.canActivityBeMigrated(activityId, processDefinition, activityValidators)) continue;
                return false;
            }
            return true;
        }

        protected boolean canActivityBeMigrated(String activityId, ProcessDefinitionImpl processDefinition, List<MigrationActivityValidator> activityValidators) {
            for (MigrationActivityValidator activityValidator : activityValidators) {
                if (activityValidator.canBeMigrated(activityId, processDefinition)) continue;
                return false;
            }
            return true;
        }
    };
    public static final MigrationInstructionValidator ONE_TO_ONE_VALIDATOR = new MigrationInstructionValidator(){

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return instruction.getSourceActivityIds().size() == 1 && instruction.getTargetActivityIds().size() == 1;
        }

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, List<MigrationInstruction> instructions, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return this.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition);
        }
    };
    public static final MigrationInstructionValidator SAME_ID_VALIDATOR = new MigrationInstructionValidator(){

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return ONE_TO_ONE_VALIDATOR.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition) && instruction.getSourceActivityIds().contains(instruction.getTargetActivityIds().get(0));
        }

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, List<MigrationInstruction> instructions, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return this.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition);
        }
    };
    public static final MigrationInstructionValidator SAME_SCOPE = new MigrationInstructionValidator(){

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return ONE_TO_ONE_VALIDATOR.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition) && MigrationInstructionValidators.haveSameScope(instruction.getSourceActivityIds().get(0), instruction.getTargetActivityIds().get(0), sourceProcessDefinition, targetProcessDefinition);
        }

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, List<MigrationInstruction> instructions, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return this.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition);
        }
    };
    public static final MigrationInstructionValidator SAME_EVENT_SCOPE = new MigrationInstructionValidator(){

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return ONE_TO_ONE_VALIDATOR.isInstructionValid(instruction, sourceProcessDefinition, targetProcessDefinition) && MigrationInstructionValidators.haveSameEventScope(instruction.getSourceActivityIds().get(0), instruction.getTargetActivityIds().get(0), sourceProcessDefinition, targetProcessDefinition);
        }

        @Override
        public boolean isInstructionValid(MigrationInstruction instruction, List<MigrationInstruction> instructions, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
            return ONE_TO_ONE_VALIDATOR.isInstructionValid(instruction, instructions, sourceProcessDefinition, targetProcessDefinition) && MigrationInstructionValidators.haveSameEventScope(instruction.getSourceActivityIds().get(0), instruction.getTargetActivityIds().get(0), instructions, sourceProcessDefinition, targetProcessDefinition);
        }
    };

    protected static boolean haveSameScope(String sourceActivityId, String targetActivityId, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
        ScopeImpl sourceFlowScope = sourceProcessDefinition.findActivity(sourceActivityId).getFlowScope();
        ScopeImpl targetFlowScope = targetProcessDefinition.findActivity(targetActivityId).getFlowScope();
        return MigrationInstructionValidators.isProcessDefinition(sourceFlowScope) && MigrationInstructionValidators.isProcessDefinition(targetFlowScope) || sourceFlowScope.getId().equals(targetFlowScope.getId());
    }

    protected static boolean haveSameEventScope(String sourceActivityId, String targetActivityId, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
        ScopeImpl sourceEventScope = sourceProcessDefinition.findActivity(sourceActivityId).getEventScope();
        ScopeImpl targetEventScope = targetProcessDefinition.findActivity(targetActivityId).getEventScope();
        return sourceEventScope == null && targetEventScope == null || sourceEventScope != null && targetEventScope != null && sourceEventScope.getId().equals(targetEventScope.getId());
    }

    protected static boolean haveSameEventScope(String sourceActivityId, String targetActivityId, List<MigrationInstruction> instructions, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
        ScopeImpl sourceEventScope = sourceProcessDefinition.findActivity(sourceActivityId).getEventScope();
        ScopeImpl targetEventScope = targetProcessDefinition.findActivity(targetActivityId).getEventScope();
        if (sourceEventScope == null && targetEventScope == null) {
            return true;
        }
        if (sourceEventScope != null) {
            String migratedSourceEventScopeId = MigrationInstructionValidators.resolveActivityIdMappingFromMigrationInstructions(sourceEventScope.getId(), instructions);
            return migratedSourceEventScopeId != null && migratedSourceEventScopeId.equals(targetEventScope.getId());
        }
        return false;
    }

    protected static String resolveActivityIdMappingFromMigrationInstructions(String activityId, List<MigrationInstruction> instructions) {
        for (MigrationInstruction instruction : instructions) {
            if (!activityId.equals(instruction.getSourceActivityIds().get(0))) continue;
            return instruction.getTargetActivityIds().get(0);
        }
        return null;
    }

    protected static boolean isProcessDefinition(ScopeImpl scope) {
        return scope.getProcessDefinition() == scope;
    }
}

