/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.migration.validation.MigrationPlanValidationFailureImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationFailure;
import org.camunda.bpm.engine.migration.MigrationPlanValidationReport;

public class MigrationPlanValidationReportImpl
implements MigrationPlanValidationReport {
    protected MigrationPlan migrationPlan;
    protected List<MigrationPlanValidationFailureImpl> validationFailures = new ArrayList<MigrationPlanValidationFailureImpl>();

    public MigrationPlanValidationReportImpl(MigrationPlan migrationPlan) {
        this.migrationPlan = migrationPlan;
    }

    public void addValidationFailure(MigrationInstruction migrationInstruction, String errorMessage) {
        this.validationFailures.add(new MigrationPlanValidationFailureImpl(migrationInstruction, errorMessage));
    }

    public boolean hasFailures() {
        return !this.validationFailures.isEmpty();
    }

    public MigrationPlan getMigrationPlan() {
        return this.migrationPlan;
    }

    @Override
    public List<MigrationPlanValidationFailure> getValidationFailures() {
        return this.validationFailures;
    }

    public void writeTo(StringBuilder sb) {
        sb.append("Migration plan is not valid for process:\n");
        for (MigrationPlanValidationFailureImpl failure : this.validationFailures) {
            failure.writeTo(sb);
            sb.append("\n");
        }
    }
}

