/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.Execution;

public class DefaultCorrelationHandler
implements CorrelationHandler {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    @Override
    public MessageCorrelationResult correlateMessage(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        List<MessageCorrelationResult> correlations = this.correlateMessageToExecutions(commandContext, messageName, correlationSet);
        if (correlations.size() > 1) {
            throw new MismatchingMessageCorrelationException(messageName, correlationSet.getBusinessKey(), correlationSet.getCorrelationKeys(), String.valueOf(correlations.size()) + " executions match the correlation keys. Should be one or zero.");
        }
        if (!correlations.isEmpty()) {
            return correlations.get(0);
        }
        return this.correlateStartMessage(commandContext, messageName, correlationSet);
    }

    @Override
    public List<MessageCorrelationResult> correlateMessages(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        ArrayList<MessageCorrelationResult> result = new ArrayList<MessageCorrelationResult>();
        result.addAll(this.correlateMessageToExecutions(commandContext, messageName, correlationSet));
        MessageCorrelationResult processDefinitionCorrelation = this.correlateStartMessage(commandContext, messageName, correlationSet);
        if (processDefinitionCorrelation != null) {
            result.add(processDefinitionCorrelation);
        }
        return result;
    }

    protected List<MessageCorrelationResult> correlateMessageToExecutions(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        String processInstanceId;
        String businessKey;
        ExecutionQueryImpl query = new ExecutionQueryImpl();
        Map<String, Object> correlationKeys = correlationSet.getCorrelationKeys();
        if (correlationKeys != null) {
            for (Map.Entry<String, Object> correlationKey : correlationKeys.entrySet()) {
                query.processVariableValueEquals(correlationKey.getKey(), correlationKey.getValue());
            }
        }
        if ((businessKey = correlationSet.getBusinessKey()) != null) {
            query.processInstanceBusinessKey(businessKey);
        }
        if ((processInstanceId = correlationSet.getProcessInstanceId()) != null) {
            query.processInstanceId(processInstanceId);
        }
        if (messageName != null) {
            query.messageEventSubscriptionName(messageName);
        } else {
            query.messageEventSubscription();
        }
        query.active();
        List matchingExecutions = query.evaluateExpressionsAndExecuteList(commandContext, null);
        ArrayList<MessageCorrelationResult> result = new ArrayList<MessageCorrelationResult>(matchingExecutions.size());
        for (Execution matchingExecution : matchingExecutions) {
            result.add(MessageCorrelationResult.matchedExecution((ExecutionEntity)matchingExecution));
        }
        return result;
    }

    @Override
    public MessageCorrelationResult correlateStartMessage(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        if (messageName == null) {
            return null;
        }
        if (correlationSet.getProcessDefinitionId() == null) {
            return this.correlateStartMessageByEventSubscription(commandContext, messageName);
        }
        return this.correlateStartMessageByProcessDefinitionId(commandContext, messageName, correlationSet.getProcessDefinitionId());
    }

    protected MessageCorrelationResult correlateStartMessageByEventSubscription(CommandContext commandContext, String messageName) {
        MessageEventSubscriptionEntity messageEventSubscription = commandContext.getEventSubscriptionManager().findMessageStartEventSubscriptionByName(messageName);
        if (messageEventSubscription != null && messageEventSubscription.getConfiguration() != null) {
            String processDefinitionId;
            DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId = messageEventSubscription.getConfiguration());
            if (processDefinition != null && !processDefinition.isSuspended()) {
                return MessageCorrelationResult.matchedProcessDefinition(processDefinition, messageEventSubscription.getActivityId());
            }
            LOG.couldNotFindProcessDefinitionForEventSubscription(messageEventSubscription, processDefinitionId);
        }
        return null;
    }

    protected MessageCorrelationResult correlateStartMessageByProcessDefinitionId(CommandContext commandContext, String messageName, String processDefinitionId) {
        String startActivityId;
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition != null && !processDefinition.isSuspended() && (startActivityId = this.findStartActivityIdByMessage(processDefinition, messageName)) != null) {
            return MessageCorrelationResult.matchedProcessDefinition(processDefinition, startActivityId);
        }
        return null;
    }

    protected String findStartActivityIdByMessage(ProcessDefinitionEntity processDefinition, String messageName) {
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(processDefinition)) {
            if (!this.isMessageStartEventWithName(declaration, messageName)) continue;
            return declaration.getActivityId();
        }
        return null;
    }

    protected boolean isMessageStartEventWithName(EventSubscriptionDeclaration declaration, String messageName) {
        return "message".equals(declaration.getEventType()) && declaration.isStartEvent() && messageName.equals(declaration.getEventName());
    }
}

