/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class CallableElementUtil {
    public static DeploymentCache getDeploymentCache() {
        return Context.getProcessEngineConfiguration().getDeploymentCache();
    }

    public static ProcessDefinitionImpl getProcessDefinitionToCall(VariableScope execution, BaseCallableElement callableElement) {
        String processDefinitionKey = callableElement.getDefinitionKey(execution);
        String tenantId = callableElement.getDefinitionTenantId((CoreExecution)execution);
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = null;
        if (callableElement.isLatestBinding()) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            processDefinition = deploymentCache.findDeployedProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            processDefinition = deploymentCache.findDeployedProcessDefinitionByKeyVersionAndTenantId(processDefinitionKey, version, tenantId);
        }
        return processDefinition;
    }

    public static CmmnCaseDefinition getCaseDefinitionToCall(VariableScope execution, BaseCallableElement callableElement) {
        String caseDefinitionKey = callableElement.getDefinitionKey(execution);
        String tenantId = callableElement.getDefinitionTenantId((CoreExecution)execution);
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        CaseDefinitionEntity caseDefinition = null;
        if (callableElement.isLatestBinding()) {
            caseDefinition = deploymentCache.findDeployedLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByKeyVersionAndTenantId(caseDefinitionKey, version, tenantId);
        }
        return caseDefinition;
    }

    public static DecisionDefinition getDecisionDefinitionToCall(VariableScope execution, BaseCallableElement callableElement) {
        String decisionDefinitionKey = callableElement.getDefinitionKey(execution);
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        DecisionDefinition decisionDefinition = null;
        if (callableElement.isLatestBinding()) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKey(decisionDefinitionKey);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByDeploymentAndKey(deploymentId, decisionDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyAndVersion(decisionDefinitionKey, version);
        }
        return decisionDefinition;
    }
}

