/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static Map<String, Object> singletonMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static <T> List<T> asArrayList(T[] values) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, values);
        return result;
    }

    public static <S, T> void addToMapOfLists(Map<S, List<T>> map, S key, T value) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        list.add(value);
    }

    public static <S, T> void addToMapOfSets(Map<S, Set<T>> map, S key, T value) {
        Set<T> set = map.get(key);
        if (set == null) {
            set = new HashSet<T>();
            map.put(key, set);
        }
        set.add(value);
    }

    public static <S, T> void addCollectionToMapOfSets(Map<S, Set<T>> map, S key, Collection<T> values) {
        Set<T> set = map.get(key);
        if (set == null) {
            set = new HashSet<T>();
            map.put(key, set);
        }
        set.addAll(values);
    }
}

