/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.management.DeploymentStatistics;
import org.camunda.bpm.engine.management.DeploymentStatisticsQuery;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class DeploymentStatisticsAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected String firstDeploymentId;
    protected String secondDeploymentId;
    protected String thirdDeploymentId;

    @Override
    public void setUp() throws Exception {
        this.firstDeploymentId = this.createDeployment("first", "org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml").getId();
        this.secondDeploymentId = this.createDeployment("second", "org/camunda/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml").getId();
        this.thirdDeploymentId = this.createDeployment("third", "org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.firstDeploymentId);
        this.deleteDeployment(this.secondDeploymentId);
        this.deleteDeployment(this.thirdDeploymentId);
    }

    public void testQueryWithoutAuthorization() {
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnDeployment() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, this.firstDeploymentId, this.userId, new Permission[]{Permissions.READ});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        this.verifyQueryResults(query, 1);
        DeploymentStatistics statistics = (DeploymentStatistics)query.singleResult();
        this.verifyStatisticsResult(statistics, 0, 0, 0);
    }

    public void testQueryWithReadPermissionOnAnyDeployment() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        this.verifyQueryResults(query, 3);
        List result = query.list();
        for (DeploymentStatistics statistics : result) {
            this.verifyStatisticsResult(statistics, 0, 0, 0);
        }
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 1, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryWithReadInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryWithReadInstancePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsWithReadPermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 1, 1, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsWithReadPermissionOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 3, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsWithReadInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 3, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsWithReadInstancePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 3, 0);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingIncidentsWithReadPermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 1, 0, 1);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingIncidentsWithReadPermissionOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 3);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingIncidentsWithReadInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 3);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingIncidentsWithReadInstancePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 3);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsAndIncidentsWithReadPermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 1, 1, 1);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsAndIncidentsWithReadPermissionOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 3, 3);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsAndIncidentsWithReadInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 3, 3);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 0, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    public void testQueryIncludingFailedJobsAndIncidentsWithReadInstancePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_START_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().includeIncidents();
        List statistics = query.list();
        for (DeploymentStatistics deploymentStatistics : statistics) {
            String id = deploymentStatistics.getId();
            if (id.equals(this.firstDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 3, 3);
                continue;
            }
            if (id.equals(this.secondDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            if (id.equals(this.thirdDeploymentId)) {
                this.verifyStatisticsResult(deploymentStatistics, 3, 0, 0);
                continue;
            }
            DeploymentStatisticsAuthorizationTest.fail((String)"Unexpected deployment");
        }
    }

    protected void verifyQueryResults(DeploymentStatisticsQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyStatisticsResult(DeploymentStatistics statistics, int instances, int failedJobs, int incidents) {
        DeploymentStatisticsAuthorizationTest.assertEquals((String)"Instances", (int)instances, (int)statistics.getInstances());
        DeploymentStatisticsAuthorizationTest.assertEquals((String)"Failed Jobs", (int)failedJobs, (int)statistics.getFailedJobs());
        List incidentStatistics = statistics.getIncidentStatistics();
        if (incidents == 0) {
            DeploymentStatisticsAuthorizationTest.assertTrue((String)"Incidents supposed to be empty", (boolean)incidentStatistics.isEmpty());
        } else {
            DeploymentStatisticsAuthorizationTest.assertEquals((String)"Incidents", (int)incidents, (int)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
        }
    }
}

