/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class EventSubscriptionAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String SIGNAL_BOUNDARY_PROCESS_KEY = "signalBoundaryProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneMessageBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/signalBoundaryEventProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 1);
        EventSubscription eventSubscription = (EventSubscription)query.singleResult();
        EventSubscriptionAuthorizationTest.assertNotNull((Object)eventSubscription);
        EventSubscriptionAuthorizationTest.assertEquals((String)processInstanceId, (String)eventSubscription.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 1);
        EventSubscription eventSubscription = (EventSubscription)query.singleResult();
        EventSubscriptionAuthorizationTest.assertNotNull((Object)eventSubscription);
        EventSubscriptionAuthorizationTest.assertEquals((String)processInstanceId, (String)eventSubscription.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 1);
        EventSubscription eventSubscription = (EventSubscription)query.singleResult();
        EventSubscriptionAuthorizationTest.assertNotNull((Object)eventSubscription);
        EventSubscriptionAuthorizationTest.assertEquals((String)processInstanceId, (String)eventSubscription.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 1);
        EventSubscription eventSubscription = (EventSubscription)query.singleResult();
        EventSubscriptionAuthorizationTest.assertNotNull((Object)eventSubscription);
        EventSubscriptionAuthorizationTest.assertEquals((String)processInstanceId, (String)eventSubscription.getProcessInstanceId());
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 1);
        EventSubscription eventSubscription = (EventSubscription)query.singleResult();
        EventSubscriptionAuthorizationTest.assertNotNull((Object)eventSubscription);
        EventSubscriptionAuthorizationTest.assertEquals((String)processInstanceId, (String)eventSubscription.getProcessInstanceId());
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        this.verifyQueryResults(query, 7);
    }

    protected void verifyQueryResults(EventSubscriptionQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

