/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class GroupAuthorizationTest
extends AuthorizationTest {
    public static final String testUserId = "testUser";
    public static final List<String> testGroupIds = Arrays.asList("testGroup1", "testGroup2", "testGroup3");

    @Override
    protected void setUp() throws Exception {
        this.createUser(testUserId);
        for (String testGroupId : testGroupIds) {
            this.createGroupAndAddUser(testGroupId, testUserId);
        }
        this.identityService.setAuthentication(testUserId, testGroupIds);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    public void testTaskQueryWithoutGroupAuthorizations() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq(testGroupIds));
                ((TaskQueryImpl)Mockito.verify((Object)taskQuery)).setAuthGroupIds((List)org.mockito.Matchers.eq(Collections.emptyList()));
                return null;
            }
        });
    }

    public void testTaskQueryWithOneGroupAuthorization() {
        this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupIds.get(0), new Permission[0]);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq(testGroupIds));
                ((TaskQueryImpl)Mockito.verify((Object)taskQuery)).setAuthGroupIds((List)org.mockito.Matchers.eq(testGroupIds.subList(0, 1)));
                return null;
            }
        });
    }

    public void testTaskQueryWithGroupAuthorization() {
        for (String testGroupId : testGroupIds) {
            this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupId, new Permission[0]);
        }
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq(testGroupIds));
                ((TaskQueryImpl)Mockito.verify((Object)taskQuery)).setAuthGroupIds((List)org.mockito.Matchers.argThat((Matcher)Matchers.containsInAnyOrder((Object[])testGroupIds.toArray())));
                return null;
            }
        });
    }

    public void testTaskQueryWithUserWithoutGroups() {
        this.identityService.setAuthentication(testUserId, null);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq((Object)null));
                ((TaskQueryImpl)Mockito.verify((Object)taskQuery)).setAuthGroupIds((List)org.mockito.Matchers.eq(Collections.emptyList()));
                return null;
            }
        });
    }

    public void testCheckAuthorizationWithoutGroupAuthorizations() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, testGroupIds, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq(testGroupIds));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)org.mockito.Matchers.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                TestCase.assertTrue((boolean)authorizationCheck.getAuthGroupIds().isEmpty());
                return null;
            }
        });
    }

    public void testCheckAuthorizationWithOneGroupAuthorizations() {
        this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupIds.get(0), new Permission[0]);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, testGroupIds, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq(testGroupIds));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)org.mockito.Matchers.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                TestCase.assertEquals(testGroupIds.subList(0, 1), (Object)authorizationCheck.getAuthGroupIds());
                return null;
            }
        });
    }

    public void testCheckAuthorizationWithGroupAuthorizations() {
        for (String testGroupId : testGroupIds) {
            this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupId, new Permission[0]);
        }
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, testGroupIds, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq(testGroupIds));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)org.mockito.Matchers.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                MatcherAssert.assertThat((Object)authorizationCheck.getAuthGroupIds(), (Matcher)Matchers.containsInAnyOrder((Object[])testGroupIds.toArray()));
                return null;
            }
        });
    }

    public void testCheckAuthorizationWithUserWithoutGroups() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, null, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager)).filterAuthenticatedGroupIds((List)org.mockito.Matchers.eq((Object)null));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)org.mockito.Matchers.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                TestCase.assertTrue((boolean)authorizationCheck.getAuthGroupIds().isEmpty());
                return null;
            }
        });
    }

    protected void createGroupGrantAuthorization(Resource resource, String resourceId, String groupId, Permission ... permissions) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setGroupId(groupId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected void createGroupAndAddUser(String groupId, String userId) {
        this.createGroup(groupId);
        this.identityService.createMembership(userId, groupId);
    }

    protected <T extends Session> T spyOnSession(CommandContext commandContext, Class<T> sessionClass) {
        Session manager = (Session)commandContext.getSession(sessionClass);
        Session spy = (Session)Mockito.spy((Object)manager);
        commandContext.getSessions().put(sessionClass, spy);
        return (T)spy;
    }
}

