/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Date;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class JobAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-job-definition");
                return null;
            }
        });
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testQueryWithReadInstancePermissionOnTimerStartProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 1);
        Job job = (Job)query.singleResult();
        JobAuthorizationTest.assertNull((Object)job.getProcessInstanceId());
        JobAuthorizationTest.assertEquals((String)TIMER_START_PROCESS_KEY, (String)job.getProcessDefinitionKey());
    }

    public void testQueryWithReadInstancePermissionOnTimerBoundaryProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 1);
        Job job = (Job)query.singleResult();
        JobAuthorizationTest.assertEquals((String)processInstanceId, (String)job.getProcessInstanceId());
        JobAuthorizationTest.assertEquals((String)TIMER_BOUNDARY_PROCESS_KEY, (String)job.getProcessDefinitionKey());
    }

    public void testQueryWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testStandaloneJobQueryWithoutAuthorization() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, true, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 1);
        Job job = (Job)query.singleResult();
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertNull((Object)job.getProcessInstanceId());
        JobAuthorizationTest.assertNull((Object)job.getProcessDefinitionKey());
        this.deleteJob(job.getId());
    }

    public void testExecuteJobWithoutAuthorization() {
        Job job = this.selectAnyJob();
        String jobId = job.getId();
        try {
            this.managementService.executeJob(jobId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to execute the job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(job.getProcessDefinitionKey(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testExecuteJobWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.executeJob(jobId);
        Task task = this.selectSingleTask();
        JobAuthorizationTest.assertNotNull((Object)task);
        JobAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testExecuteJobWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.executeJob(jobId);
        Task task = this.selectSingleTask();
        JobAuthorizationTest.assertNotNull((Object)task);
        JobAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testExecuteJobWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.executeJob(jobId);
        Task task = this.selectSingleTask();
        JobAuthorizationTest.assertNotNull((Object)task);
        JobAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testExecuteJobWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.executeJob(jobId);
        Task task = this.selectSingleTask();
        JobAuthorizationTest.assertNotNull((Object)task);
        JobAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testExecuteStandaloneJob() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY);
        JobAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
    }

    public void testDeleteJobWithoutAuthorization() {
        Job job = this.selectAnyJob();
        String jobId = job.getId();
        try {
            this.managementService.deleteJob(jobId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete the job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(job.getProcessDefinitionKey(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteJobWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.deleteJob(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNull((Object)job);
    }

    public void testDeleteJobWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.deleteJob(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNull((Object)job);
    }

    public void testDeleteJobWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.deleteJob(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNull((Object)job);
    }

    public void testDeleteJobWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.deleteJob(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNull((Object)job);
    }

    public void testDeleteStandaloneJob() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.deleteJob(jobId);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNull((Object)job);
    }

    public void testSetJobRetriesWithoutAuthorization() {
        Job job = this.selectAnyJob();
        String jobId = job.getId();
        try {
            this.managementService.setJobRetries(jobId, 1);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to set job retries");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(job.getProcessDefinitionKey(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetJobRetriesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
    }

    public void testSetJobRetriesWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
    }

    public void testSetJobRetriesWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
    }

    public void testSetJobRetriesWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
    }

    public void testSetStandaloneJobRetries() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
        this.deleteJob(jobId);
    }

    public void testSetJobRetriesByJobDefinitionIdWithoutAuthorization() {
        this.disableAuthorization();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().listPage(0, 1).get(0);
        this.enableAuthorization();
        String jobDefinitionId = jobDefinition.getId();
        try {
            this.managementService.setJobRetriesByJobDefinitionId(jobDefinitionId, 1);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to set job retries");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(jobDefinition.getProcessDefinitionKey(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetJobRetriesByJobDefinitionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.setJobRetriesByJobDefinitionId(jobDefinitionId, 1);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to set job retries");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetJobRetriesByJobDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinitionId, 1);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
    }

    public void testSetJobRetriesByJobDefinitionIdWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
    }

    public void testSetJobRetriesByJobDefinitionIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertEquals((int)1, (int)job.getRetries());
    }

    public void testSetJobDueDateWithoutAuthorization() {
        Job job = this.selectAnyJob();
        String jobId = job.getId();
        try {
            this.managementService.setJobDuedate(jobId, new Date());
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to set the job due date");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(job.getProcessDefinitionKey(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetJobDueDateWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobDuedate(jobId, null);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNull((Object)job.getDuedate());
    }

    public void testSetJobDueDateWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobDuedate(jobId, null);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNull((Object)job.getDuedate());
    }

    public void testSetJobDueDateWithUpdateInstancePermissionOnTimerBoundaryProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobDuedate(jobId, null);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNull((Object)job.getDuedate());
    }

    public void testSetJobDueDateWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobDuedate(jobId, null);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNull((Object)job.getDuedate());
    }

    public void testSetStandaloneJobDueDate() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobDuedate(jobId, null);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNull((Object)job.getDuedate());
        this.deleteJob(jobId);
    }

    public void testGetExceptionStacktraceWithoutAuthorization() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        try {
            this.managementService.getJobExceptionStacktrace(jobId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the exception stacktrace");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_INCIDENT_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetExceptionStacktraceWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        JobAuthorizationTest.assertNotNull((Object)jobExceptionStacktrace);
    }

    public void testGetExceptionStacktraceReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        JobAuthorizationTest.assertNotNull((Object)jobExceptionStacktrace);
    }

    public void testGetExceptionStacktraceWithReadInstancePermissionOnTimerBoundaryProcessDefinition() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        JobAuthorizationTest.assertNotNull((Object)jobExceptionStacktrace);
    }

    public void testGetExceptionStacktraceWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        JobAuthorizationTest.assertNotNull((Object)jobExceptionStacktrace);
    }

    public void testStandaloneJobGetExceptionStacktrace() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        JobAuthorizationTest.assertNull((Object)jobExceptionStacktrace);
        this.deleteJob(jobId);
    }

    public void testSuspendJobByIdWihtoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        try {
            this.managementService.suspendJobById(jobId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendStandaloneJobById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.suspendJobById(jobId);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
        this.deleteJob(jobId);
    }

    public void testActivateJobByIdWihtoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.suspendJobById(jobId);
        try {
            this.managementService.activateJobById(jobId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.suspendJobById(jobId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.suspendJobById(jobId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.suspendJobById(jobId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.suspendJobById(jobId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobById(jobId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateStandaloneJobById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.suspendJobById(jobId);
        this.managementService.activateJobById(jobId);
        Job job = this.selectJobById(jobId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
        this.deleteJob(jobId);
    }

    public void testSuspendJobByProcessInstanceIdWihtoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.suspendJobByProcessInstanceId(processInstanceId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByProcessInstanceIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessInstanceIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessInstanceIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessInstanceIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessInstanceIdWihtoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessInstanceId(processInstanceId);
        try {
            this.managementService.activateJobByProcessInstanceId(processInstanceId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByProcessInstanceIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessInstanceId(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessInstanceIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessInstanceId(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessInstanceIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessInstanceId(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessInstanceIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessInstanceId(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByProcessInstanceId(processInstanceId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testSuspendJobByJobDefinitionIdWihtoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByJobDefinitionIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByJobDefinitionIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByJobDefinitionIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByJobDefinitionIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testActivateJobByJobDefinitionIdWihtoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByJobDefinitionId(jobDefinitionId);
        try {
            this.managementService.activateJobByJobDefinitionId(jobDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByJobDefinitionIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByJobDefinitionId(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobByJobDefinitionId(jobDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByJobDefinitionIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByJobDefinitionId(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobByJobDefinitionId(jobDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByJobDefinitionIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByJobDefinitionId(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByJobDefinitionId(jobDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByJobDefinitionIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByJobDefinitionId(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByJobDefinitionId(jobDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessDefinitionIdWihtoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.suspendJobByProcessDefinitionId(processDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByProcessDefinitionIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobByProcessDefinitionId(processDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByProcessDefinitionIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobByProcessDefinitionId(processDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessDefinitionIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByProcessDefinitionId(processDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessDefinitionIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByProcessDefinitionId(processDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessDefinitionIdWihtoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionId(processDefinitionId);
        try {
            this.managementService.activateJobByProcessDefinitionId(processDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByProcessDefinitionIdWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobByProcessDefinitionId(processDefinitionId);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByProcessDefinitionIdWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobByProcessDefinitionId(processDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessDefinitionIdWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByProcessDefinitionId(processDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessDefinitionIdWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByProcessDefinitionId(processDefinitionId);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessDefinitionKeyWihtoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        try {
            this.managementService.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByProcessDefinitionKeyWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendJobByProcessDefinitionKeyWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessDefinitionKeyWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendJobByProcessDefinitionKeyWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessDefinitionKeyWihtoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        try {
            this.managementService.activateJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByProcessDefinitionKeyWihtUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            JobAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateJobByProcessDefinitionKeyWihtUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessDefinitionKeyWihtUpdatePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateJobByProcessDefinitionKeyWihtUpdatePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobAuthorizationTest.assertNotNull((Object)job);
        JobAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    protected void verifyQueryResults(JobQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected Job selectAnyJob() {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().listPage(0, 1).get(0);
        this.enableAuthorization();
        return job;
    }

    protected void deleteJob(String jobId) {
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
    }

    protected Job selectJobByProcessInstanceId(String processInstanceId) {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.enableAuthorization();
        return job;
    }

    protected Job selectJobById(String jobId) {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        this.enableAuthorization();
        return job;
    }

    protected JobDefinition selectJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.disableAuthorization();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        this.enableAuthorization();
        return jobDefinition;
    }
}

