/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchQuery;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchQueryTest {
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void removeBatches() {
        for (Batch batch : this.managementService.createBatchQuery().list()) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
    }

    @Test
    public void testBatchQuery() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        List list = this.managementService.createBatchQuery().list();
        Assert.assertEquals((long)2L, (long)list.size());
        ArrayList<String> batchIds = new ArrayList<String>();
        for (Batch resultBatch : list) {
            batchIds.add(resultBatch.getId());
        }
        Assert.assertTrue((boolean)batchIds.contains(batch1.getId()));
        Assert.assertTrue((boolean)batchIds.contains(batch2.getId()));
    }

    @Test
    public void testBatchQueryResult() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Batch resultBatch = (Batch)this.managementService.createBatchQuery().singleResult();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((Object)batch.getId(), (Object)resultBatch.getId());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)resultBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)resultBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)resultBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)batch.getTenantId(), (Object)resultBatch.getTenantId());
        Assert.assertEquals((Object)batch.getType(), (Object)resultBatch.getType());
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)resultBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)batch.getInvocationsPerBatchJob(), (long)resultBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((long)batch.getSize(), (long)resultBatch.getSize());
    }

    @Test
    public void testBatchQueryById() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        Batch resultBatch = (Batch)this.managementService.createBatchQuery().batchId(batch1.getId()).singleResult();
        Assert.assertNotNull((Object)resultBatch);
        Assert.assertEquals((Object)batch1.getId(), (Object)resultBatch.getId());
    }

    @Test
    public void testBatchQueryByIdNull() {
        try {
            this.managementService.createBatchQuery().batchId(null).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Batch id is null"));
        }
    }

    @Test
    public void testBatchQueryByType() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.managementService.createBatchQuery().type(batch1.getType()).count();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testBatchQueryByNonExistingType() {
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.managementService.createBatchQuery().type("foo").count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testBatchQueryByTypeNull() {
        try {
            this.managementService.createBatchQuery().type(null).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Type is null"));
        }
    }

    @Test
    public void testBatchQueryCount() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.managementService.createBatchQuery().count();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testBatchQueryOrderByIdAsc() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((BatchQuery)this.managementService.createBatchQuery().orderById().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.batchById());
    }

    @Test
    public void testBatchQueryOrderByIdDec() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((BatchQuery)this.managementService.createBatchQuery().orderById().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.batchById()));
    }

    @Test
    public void testBatchQueryOrderingPropertyWithoutOrder() {
        try {
            this.managementService.createBatchQuery().orderById().singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid query: call asc() or desc() after using orderByXX()"));
        }
    }

    @Test
    public void testBatchQueryOrderWithoutOrderingProperty() {
        try {
            ((BatchQuery)this.managementService.createBatchQuery().asc()).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"You should call any of the orderBy methods first before specifying a direction"));
        }
    }
}

