/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyCallActivityTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String CMMN = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final BpmnModelInstance SUB_PROCESS = Bpmn.createExecutableProcess((String)"subProcess").startEvent().userTask().endEvent().done();

    public void testStartProcessInstanceWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("deployment")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceWithLatestBindingSameVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceWithLatestBindingDifferentVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SUB_PROCESS});
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessDefinition latestSubProcessTenantTwo = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).processDefinitionKey("subProcess").latestVersion().singleResult();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).processDefinitionId(latestSubProcessTenantTwo.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("version")).camundaCalledElementVersion("1")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailStartProcessInstanceFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("deployment")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SUB_PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyCallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key = 'subProcess'"));
        }
    }

    public void testFailStartProcessInstanceFromOtherTenantWithLatestBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SUB_PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyCallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key 'subProcess'"));
        }
    }

    public void testFailStartProcessInstanceFromOtherTenantWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("version")).camundaCalledElementVersion("2")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess, SUB_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SUB_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SUB_PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyCallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key = 'subProcess'"));
        }
    }

    public void testStartCaseInstanceWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("deployment")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, CMMN, callingProcess);
        this.deploymentForTenant(TENANT_TWO, CMMN, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        this.assertThatStartedCaseInstanceForTenant(TENANT_ONE);
        this.assertThatStartedCaseInstanceForTenant(TENANT_TWO);
    }

    public void testStartCaseInstanceWithLatestBindingSameVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, CMMN, callingProcess);
        this.deploymentForTenant(TENANT_TWO, CMMN, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        this.assertThatStartedCaseInstanceForTenant(TENANT_ONE);
        this.assertThatStartedCaseInstanceForTenant(TENANT_TWO);
    }

    public void testStartCaseInstanceWithLatestBindingDifferentVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, CMMN, callingProcess);
        this.deploymentForTenant(TENANT_TWO, CMMN, callingProcess);
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN});
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        this.assertThatStartedCaseInstanceForTenant(TENANT_ONE);
        CaseDefinition latestCaseDefinitionTenantTwo = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).latestVersion().singleResult();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionId(latestCaseDefinitionTenantTwo.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartCaseInstanceWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("version")).camundaCaseVersion("1")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, CMMN, callingProcess);
        this.deploymentForTenant(TENANT_TWO, CMMN, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        this.assertThatStartedCaseInstanceForTenant(TENANT_ONE);
        this.assertThatStartedCaseInstanceForTenant(TENANT_TWO);
    }

    public void testFailStartCaseInstanceFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("deployment")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN});
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyCallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key = 'Case_1'"));
        }
    }

    public void testFailStartCaseInstanceFromOtherTenantWithLatestBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{callingProcess});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN});
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyCallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key 'Case_1'"));
        }
    }

    public void testFailStartCaseInstanceFromOtherTenantWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("version")).camundaCaseVersion("2")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, CMMN, callingProcess);
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN});
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyCallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key = 'Case_1'"));
        }
    }

    public void testCalledElementTenantIdConstant() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementTenantId(TENANT_ONE)).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SUB_PROCESS});
        this.deployment(new BpmnModelInstance[]{callingProcess});
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCalledElementTenantIdExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementTenantId("${'tenant1'}")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SUB_PROCESS});
        this.deployment(new BpmnModelInstance[]{callingProcess});
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCaseRefTenantIdConstant() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId(TENANT_ONE)).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        this.deployment(new BpmnModelInstance[]{callingProcess});
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.assertThatStartedCaseInstanceForTenant(TENANT_ONE);
    }

    public void testCaseRefTenantIdExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId("${'tenant1'}")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        this.deployment(new BpmnModelInstance[]{callingProcess});
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.assertThatStartedCaseInstanceForTenant(TENANT_ONE);
    }

    protected void assertThatStartedCaseInstanceForTenant(String tenantId) {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{tenantId}).singleResult();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionId(caseDefinition.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    protected String deploymentForTenant(String tenantId, String classpathResource, BpmnModelInstance modelInstance) {
        return this.deployment(this.repositoryService.createDeployment().tenantId(tenantId).addClasspathResource(classpathResource), new BpmnModelInstance[]{modelInstance});
    }
}

