/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyMessageCorrelationTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance MESSAGE_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"messageStart").startEvent().message("message")).userTask().endEvent().done();
    protected static final BpmnModelInstance MESSAGE_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"messageCatch").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done();

    public void testCorrelateMessageToStartEventNoTenantIdSetForNonTenant() {
        this.deployment(new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.runtimeService.createMessageCorrelation("message").correlate();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testCorrelateMessageToStartEventNoTenantIdSetForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.runtimeService.createMessageCorrelation("message").correlate();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCorrelateMessageToStartEventWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.runtimeService.createMessageCorrelation("message").withoutTenantId().correlate();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testCorrelateMessageToStartEventWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.runtimeService.createMessageCorrelation("message").tenantId(TENANT_ONE).correlate();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testCorrelateMessageToIntermediateCatchEventNoTenantIdSetForNonTenant() {
        this.deployment(new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.startProcessInstanceByKey("messageCatch");
        this.runtimeService.createMessageCorrelation("message").correlate();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCorrelateMessageToIntermediateCatchEventNoTenantIdSetForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.startProcessInstanceByKey("messageCatch");
        this.runtimeService.createMessageCorrelation("message").correlate();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCorrelateMessageToIntermediateCatchEventWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createMessageCorrelation("message").withoutTenantId().correlate();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Task)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testCorrelateMessageToIntermediateCatchEventWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createMessageCorrelation("message").tenantId(TENANT_ONE).correlate();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testCorrelateMessageToStartAndIntermediateCatchEventWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createMessageCorrelation("message").withoutTenantId().correlateAll();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testCorrelateMessageToStartAndIntermediateCatchEventWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createMessageCorrelation("message").tenantId(TENANT_ONE).correlateAll();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testCorrelateMessageToMultipleIntermediateCatchEventsWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createMessageCorrelation("message").withoutTenantId().correlateAll();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testCorrelateMessageToMultipleIntermediateCatchEventsWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createMessageCorrelation("message").tenantId(TENANT_ONE).correlateAll();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testCorrelateStartMessageWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.runtimeService.createMessageCorrelation("message").withoutTenantId().correlateStartMessage();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testCorrelateStartMessageWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.runtimeService.createMessageCorrelation("message").tenantId(TENANT_ONE).correlateStartMessage();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testCorrelateMessagesToStartEventsForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.runtimeService.createMessageCorrelation("message").correlateAll();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCorrelateMessagesToIntermediateCatchEventsForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createMessageCorrelation("message").correlateAll();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCorrelateMessagesToStartAndIntermediateCatchEventForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createMessageCorrelation("message").correlateAll();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailToCorrelateMessageToIntermediateCatchEventsForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        try {
            this.runtimeService.createMessageCorrelation("message").correlate();
            MultiTenancyMessageCorrelationTest.fail((String)"expected exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot correlate a message with name 'message' to a single execution"));
        }
    }

    public void testFailToCorrelateMessageToStartEventsForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        try {
            this.runtimeService.createMessageCorrelation("message").correlate();
            MultiTenancyMessageCorrelationTest.fail((String)"expected exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot correlate a message with name 'message' to a single process definition"));
        }
    }

    public void testFailToCorrelateStartMessageForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{MESSAGE_START_PROCESS});
        try {
            this.runtimeService.createMessageCorrelation("message").correlateStartMessage();
            MultiTenancyMessageCorrelationTest.fail((String)"expected exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot correlate a message with name 'message' to a single process definition"));
        }
    }

    public void testFailToCorrelateMessageByProcessInstanceIdWithoutTenantId() {
        try {
            this.runtimeService.createMessageCorrelation("message").processInstanceId("id").withoutTenantId().correlate();
            MultiTenancyMessageCorrelationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToCorrelateMessageByProcessInstanceIdAndTenantId() {
        try {
            this.runtimeService.createMessageCorrelation("message").processInstanceId("id").tenantId(TENANT_ONE).correlate();
            MultiTenancyMessageCorrelationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToCorrelateMessageByProcessDefinitionIdWithoutTenantId() {
        try {
            this.runtimeService.createMessageCorrelation("message").processDefinitionId("id").withoutTenantId().correlateStartMessage();
            MultiTenancyMessageCorrelationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToCorrelateMessageByProcessDefinitionIdAndTenantId() {
        try {
            this.runtimeService.createMessageCorrelation("message").processDefinitionId("id").tenantId(TENANT_ONE).correlateStartMessage();
            MultiTenancyMessageCorrelationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }
}

