/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancySignalReceiveTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance SIGNAL_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"signalStart").startEvent().signal("signal")).userTask().endEvent().done();
    protected static final BpmnModelInstance SIGNAL_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"signalCatch").startEvent().intermediateCatchEvent().signal("signal")).userTask().endEvent().done();
    protected static final BpmnModelInstance SIGNAL_INTERMEDIATE_THROW_PROCESS = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)"signalThrow").startEvent().intermediateThrowEvent().signal("signal")).endEvent().done();
    protected static final BpmnModelInstance SIGNAL_END_THROW_PROCESS = ((EndEventBuilder)Bpmn.createExecutableProcess((String)"signalThrow").startEvent().endEvent().signal("signal")).done();

    public void testSendSignalToStartEventForNonTenant() {
        this.deployment(new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.runtimeService.createSignalEvent("signal").withoutTenantId().send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testSendSignalToStartEventForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_TWO).send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToStartEventWithoutTenantIdForNonTenant() {
        this.deployment(new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.runtimeService.createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToStartEventWithoutTenantIdForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.runtimeService.createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToIntermediateCatchEventForNonTenant() {
        this.deployment(new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createSignalEvent("signal").withoutTenantId().send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Task)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testSendSignalToIntermediateCatchEventForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_TWO).send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToIntermediateCatchEventWithoutTenantIdForNonTenant() {
        this.deployment(new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToIntermediateCatchEventWithoutTenantIdForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToStartAndIntermediateCatchEventForNonTenant() {
        this.deployment(new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createSignalEvent("signal").withoutTenantId().send();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testSendSignalToStartAndIntermediateCatchEventForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_TWO).send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testSendSignalToStartEventsForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.runtimeService.createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToIntermediateCatchEventsForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToStartAndIntermediateCatchEventForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_CATCH_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_START_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailToSendSignalWithExecutionIdForTenant() {
        try {
            this.runtimeService.createSignalEvent("signal").executionId("id").tenantId(TENANT_ONE).send();
            MultiTenancySignalReceiveTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id when deliver a signal to a single execution."));
        }
    }

    public void testThrowIntermediateSignalForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_INTERMEDIATE_THROW_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.deployment(new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testThrowIntermediateSignalForNonTenant() {
        this.deployment(new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_INTERMEDIATE_THROW_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testThrowEndSignalForTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_END_THROW_PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.deployment(new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testThrowEndSignalForNonTenant() {
        this.deployment(new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_END_THROW_PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS});
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }
}

