/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyTaskServiceTest
extends PluggableProcessEngineTestCase {
    private static final String tenant1 = "the-tenant-1";
    private static final String tenant2 = "the-tenant-2";

    public void testStandaloneTaskCreateWithTenantId() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        MultiTenancyTaskServiceTest.assertEquals((String)tenant1, (String)task.getTenantId());
        this.deleteTasks(task);
    }

    public void testStandaloneTaskCannotChangeTenantIdIfNull() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setTenantId(tenant1);
        try {
            this.taskService.saveTask(task);
            MultiTenancyTaskServiceTest.fail((String)"Expected an exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-03072 Cannot change tenantId of Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    public void testStandaloneTaskCannotChangeTenantId() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setTenantId(tenant2);
        try {
            this.taskService.saveTask(task);
            MultiTenancyTaskServiceTest.fail((String)"Expected an exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-03072 Cannot change tenantId of Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    public void testStandaloneTaskCannotSetDifferentTenantIdOnSubTask() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        Task subTask = this.taskService.newTask();
        subTask.setParentTaskId(task.getId());
        subTask.setTenantId(tenant2);
        try {
            this.taskService.saveTask(subTask);
            MultiTenancyTaskServiceTest.fail((String)"Exception expected.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-03073 Cannot set different tenantId on subtask than on parent Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    public void testStandaloneTaskCannotSetDifferentTenantIdOnSubTaskWithNull() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        Task subTask = this.taskService.newTask();
        subTask.setParentTaskId(task.getId());
        subTask.setTenantId(tenant1);
        try {
            this.taskService.saveTask(subTask);
            MultiTenancyTaskServiceTest.fail((String)"Exception expected.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-03073 Cannot set different tenantId on subtask than on parent Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    public void testStandaloneTaskPropagateTenantIdToSubTask() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        Task subTask = this.taskService.newTask();
        subTask.setParentTaskId(task.getId());
        this.taskService.saveTask(subTask);
        subTask = (Task)this.taskService.createTaskQuery().taskId(subTask.getId()).singleResult();
        MultiTenancyTaskServiceTest.assertEquals((String)tenant1, (String)subTask.getTenantId());
        this.deleteTasks(subTask, task);
    }

    public void testStandaloneTaskPropagatesTenantIdToVariableInstance() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        this.taskService.setVariable(task.getId(), "var", (Object)"test");
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenant1));
        this.deleteTasks(task);
    }

    protected void deleteTasks(Task ... tasks) {
        for (Task task : tasks) {
            this.taskService.deleteTask(task.getId(), true);
        }
    }
}

