/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderProcessInstanceContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TenantIdProviderTest
extends ResourceProcessEngineTestCase {
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String TENANT_ID = "tenant1";

    public TenantIdProviderTest() {
        super("org/camunda/bpm/engine/test/api/multitenancy/TenantIdProviderTest.camunda.cfg.xml");
    }

    protected void tearDown() throws Exception {
        TestTenantIdProvider.reset();
        super.tearDown();
    }

    public void testProviderCalledForProcessDefinitionWithoutTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testProviderNotCalledForProcessDefinitionWithTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deploymentForTenant(TENANT_ID, new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testProviderCalledWithVariables() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("varName", (Object)true));
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)tenantIdProvider.parameters.get(0).getVariables().get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    public void testProviderCalledWithProcessDefinition() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done()});
        ProcessDefinition deployedProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessDefinition passedProcessDefinition = tenantIdProvider.parameters.get(0).getProcessDefinition();
        Assert.assertThat((Object)passedProcessDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedProcessDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedProcessDefinition.getId()));
    }

    public void testSetsTenantId() {
        String tenantId = TENANT_ID;
        SetValueTenantIdProvider tenantIdProvider = new SetValueTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    public void testSetNullTenantId() {
        String tenantId = null;
        SetValueTenantIdProvider tenantIdProvider = new SetValueTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testProviderCalledForProcessDefinitionWithoutTenantId_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).done()});
        this.runtimeService.startProcessInstanceByKey("superProcess");
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    public void testProviderNotCalledForProcessDefinitionWithTenantId_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deploymentForTenant(TENANT_ID, new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).done()});
        this.runtimeService.startProcessInstanceByKey("superProcess");
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testProviderCalledWithVariables_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done(), ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).camundaIn("varName", "varName")).done()});
        this.runtimeService.startProcessInstanceByKey("superProcess", (Map)Variables.createVariables().putValue("varName", (Object)true));
        Assert.assertThat((Object)tenantIdProvider.parameters.get(1).getVariables().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)tenantIdProvider.parameters.get(1).getVariables().get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    public void testProviderCalledWithProcessDefinition_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).done()});
        ProcessDefinition deployedProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        this.runtimeService.startProcessInstanceByKey("superProcess");
        ProcessDefinition passedProcessDefinition = tenantIdProvider.parameters.get(1).getProcessDefinition();
        Assert.assertThat((Object)passedProcessDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedProcessDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedProcessDefinition.getId()));
    }

    public void testProviderCalledWithSuperProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).done()});
        ProcessDefinition superProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("superProcess").singleResult();
        this.runtimeService.startProcessInstanceByKey("superProcess");
        DelegateExecution superExecution = tenantIdProvider.parameters.get(1).getSuperExecution();
        Assert.assertThat((Object)superExecution, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)superExecution.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)superProcessDefinition.getId()));
    }

    public void testSetsTenantId_SubProcessInstance() {
        String tenantId = TENANT_ID;
        SetValueOnSubProcessInstanceTenantIdProvider tenantIdProvider = new SetValueOnSubProcessInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).done()});
        this.runtimeService.startProcessInstanceByKey("superProcess");
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertThat((Object)subProcessInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
        ProcessInstance superProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("superProcess").singleResult();
        Assert.assertThat((Object)superProcessInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testSetNullTenantId_SubProcessInstance() {
        String tenantId = null;
        SetValueOnSubProcessInstanceTenantIdProvider tenantIdProvider = new SetValueOnSubProcessInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).done()});
        this.runtimeService.startProcessInstanceByKey("superProcess");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testTenantIdInheritedFromSuperProcessInstance() {
        String tenantId = TENANT_ID;
        SetValueOnRootProcessInstanceTenantIdProvider tenantIdProvider = new SetValueOnRootProcessInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("testProcess")).done()});
        this.runtimeService.startProcessInstanceByKey("superProcess");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    public void testProviderCalledForProcessDefinitionWithoutTenantId_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn"), new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done()});
        this.caseService.createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.caseService.manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testProviderNotCalledForProcessDefinitionWithTenantId_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(this.repositoryService.createDeployment().tenantId(TENANT_ID).addClasspathResource("org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn"), new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done()});
        this.caseService.createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.caseService.manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testProviderCalledWithVariables_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn"), new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done()});
        this.caseService.createCaseInstanceByKey("testCase", (Map)Variables.createVariables().putValue("varName", (Object)true));
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.caseService.manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        VariableMap variables = tenantIdProvider.parameters.get(0).getVariables();
        Assert.assertThat((Object)variables.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)variables.get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    public void testProviderCalledWithProcessDefinition_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn"), new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done()});
        this.caseService.createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.caseService.manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)tenantIdProvider.parameters.get(0).getProcessDefinition(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    public void testProviderCalledWithSuperCaseExecution() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn"), new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().done()});
        this.caseService.createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.caseService.manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)tenantIdProvider.parameters.get(0).getSuperCaseExecution(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    public void testProviderCalledForDecisionDefinitionWithoutTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new String[]{DMN_FILE});
        this.decisionService.evaluateDecisionTableByKey("decision").variables((Map)this.createVariables()).evaluate();
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testProviderNotCalledForDecisionDefinitionWithTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deploymentForTenant(TENANT_ID, new String[]{DMN_FILE});
        this.decisionService.evaluateDecisionTableByKey("decision").variables((Map)this.createVariables()).evaluate();
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testProviderCalledWithDecisionDefinition() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new String[]{DMN_FILE});
        DecisionDefinition deployedDecisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.decisionService.evaluateDecisionTableByKey("decision").variables((Map)this.createVariables()).evaluate();
        DecisionDefinition passedDecisionDefinition = tenantIdProvider.dmnParameters.get(0).getDecisionDefinition();
        Assert.assertThat((Object)passedDecisionDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedDecisionDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedDecisionDefinition.getId()));
    }

    public void testSetsTenantIdForHistoricDecisionInstance() {
        String tenantId = TENANT_ID;
        SetValueTenantIdProvider tenantIdProvider = new SetValueTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new String[]{DMN_FILE});
        this.decisionService.evaluateDecisionTableByKey("decision").variables((Map)this.createVariables()).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    public void testSetNullTenantIdForHistoricDecisionInstance() {
        String tenantId = null;
        SetValueTenantIdProvider tenantIdProvider = new SetValueTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.deployment(new String[]{DMN_FILE});
        this.decisionService.evaluateDecisionTableByKey("decision").variables((Map)this.createVariables()).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testProviderCalledForHistoricDecisionDefinitionWithoutTenantId_BusinessRuleTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().businessRuleTask().camundaDecisionRef("decision")).endEvent().done();
        this.deploymentWithoutTenant(DMN_FILE, process);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.createVariables());
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testProviderNotCalledForHistoricDecisionDefinitionWithTenantId_BusinessRuleTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().businessRuleTask().camundaDecisionRef("decision")).endEvent().done();
        this.deploymentForTenant(TENANT_ID, DMN_FILE, process);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.createVariables());
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testProviderCalledWithExecution_BusinessRuleTasks() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaAsyncAfter()).endEvent().done();
        this.deploymentWithoutTenant(DMN_FILE, process);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.createVariables());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)1));
        ExecutionEntity passedExecution = (ExecutionEntity)tenantIdProvider.dmnParameters.get(0).getExecution();
        Assert.assertThat((Object)passedExecution, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedExecution.getParent().getId(), (Matcher)CoreMatchers.is((Object)execution.getId()));
    }

    public void testSetsTenantIdForHistoricDecisionInstance_BusinessRuleTask() {
        String tenantId = TENANT_ID;
        SetValueOnRootProcessInstanceTenantIdProvider.SetValueOnHistoricDecisionInstanceTenantIdProvider tenantIdProvider = new SetValueOnRootProcessInstanceTenantIdProvider.SetValueOnHistoricDecisionInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaAsyncAfter()).endEvent().done();
        this.deploymentWithoutTenant(DMN_FILE, process);
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").setVariables((Map)this.createVariables())).execute();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("decision").singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    public void testSetNullTenantIdForHistoricDecisionInstance_BusinessRuleTask() {
        String tenantId = null;
        SetValueOnRootProcessInstanceTenantIdProvider.SetValueOnHistoricDecisionInstanceTenantIdProvider tenantIdProvider = new SetValueOnRootProcessInstanceTenantIdProvider.SetValueOnHistoricDecisionInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaAsyncAfter()).endEvent().done();
        this.deploymentWithoutTenant(DMN_FILE, process);
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").setVariables((Map)this.createVariables())).execute();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("decision").singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    protected String deploymentForTenant(String tenantId, String classpathResource, BpmnModelInstance modelInstance) {
        return this.deployment(this.repositoryService.createDeployment().tenantId(tenantId).addClasspathResource(classpathResource), new BpmnModelInstance[]{modelInstance});
    }

    protected String deploymentWithoutTenant(String classpathResource, BpmnModelInstance modelInstance) {
        return this.deployment(this.repositoryService.createDeployment().addClasspathResource(classpathResource), new BpmnModelInstance[]{modelInstance});
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"gold");
    }

    public static class SetValueOnRootProcessInstanceTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueOnRootProcessInstanceTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return ctx.getSuperExecution() == null ? this.tenantIdToSet : null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return null;
        }

        public static class SetValueOnHistoricDecisionInstanceTenantIdProvider
        implements TenantIdProvider {
            private final String tenantIdToSet;

            public SetValueOnHistoricDecisionInstanceTenantIdProvider(String tenantIdToSet) {
                this.tenantIdToSet = tenantIdToSet;
            }

            public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
                return null;
            }

            public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
                return ctx.getExecution() != null ? this.tenantIdToSet : null;
            }
        }
    }

    public static class SetValueOnSubProcessInstanceTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueOnSubProcessInstanceTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return ctx.getSuperExecution() != null ? this.tenantIdToSet : null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return null;
        }
    }

    public static class SetValueTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return this.tenantIdToSet;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return this.tenantIdToSet;
        }
    }

    public static class ContextLoggingTenantIdProvider
    implements TenantIdProvider {
        protected List<TenantIdProviderProcessInstanceContext> parameters = new ArrayList<TenantIdProviderProcessInstanceContext>();
        protected List<TenantIdProviderHistoricDecisionInstanceContext> dmnParameters = new ArrayList<TenantIdProviderHistoricDecisionInstanceContext>();

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            this.parameters.add(ctx);
            return null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            this.dmnParameters.add(ctx);
            return null;
        }
    }

    public static class TestTenantIdProvider
    implements TenantIdProvider {
        protected static TenantIdProvider delegate;

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            if (delegate != null) {
                return delegate.provideTenantIdForProcessInstance(ctx);
            }
            return null;
        }

        public static void reset() {
            delegate = null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            if (delegate != null) {
                return delegate.provideTenantIdForHistoricDecisionInstance(ctx);
            }
            return null;
        }
    }
}

