/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDecisionDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deployment(new String[]{DMN});
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN});
    }

    public void testQueryNoTenantIdSet() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByDefinitionsWithoutTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByLatestNoTenantIdSet() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantIds() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithoutTenantId() {
        this.deployment(new String[]{DMN});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    public void testQueryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.deployment(new String[]{DMN});
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    public void testQueryByNonExistingTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{null});
            MultiTenancyDecisionDefinitionQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)decisionDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)decisionDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    protected Map<String, DecisionDefinition> getDecisionDefinitionsForTenant(List<DecisionDefinition> decisionDefinitions) {
        HashMap<String, DecisionDefinition> definitionsForTenant = new HashMap<String, DecisionDefinition>();
        for (DecisionDefinition definition : decisionDefinitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }
}

