/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyExecutionQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();
        this.deployment(new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{oneTaskProcess});
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_TWO).execute();
    }

    public void testQueryNoTenantIdSet() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByTenantId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByExecutionsWithoutTenantId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByNonExistingTenantId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{null});
            MultiTenancyExecutionQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List executions = ((ExecutionQuery)this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List executions = ((ExecutionQuery)this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }
}

