/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.DeploymentStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyStatisticsQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance process = Bpmn.createExecutableProcess().startEvent().done();
        this.deployment(new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{process});
    }

    public void testDeploymentStatistics() {
        List deploymentStatistics = this.managementService.createDeploymentStatisticsQuery().list();
        Assert.assertThat((Object)deploymentStatistics.size(), (Matcher)CoreMatchers.is((Object)3));
        Set<String> tenantIds = this.collectDeploymentTenantIds(deploymentStatistics);
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    public void testProcessDefinitionStatistics() {
        List processDefinitionStatistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertThat((Object)processDefinitionStatistics.size(), (Matcher)CoreMatchers.is((Object)3));
        Set<String> tenantIds = this.collectDefinitionTenantIds(processDefinitionStatistics);
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    protected Set<String> collectDeploymentTenantIds(List<DeploymentStatistics> deploymentStatistics) {
        HashSet<String> tenantIds = new HashSet<String>();
        for (DeploymentStatistics statistics : deploymentStatistics) {
            tenantIds.add(statistics.getTenantId());
        }
        return tenantIds;
    }

    protected Set<String> collectDefinitionTenantIds(List<ProcessDefinitionStatistics> processDefinitionStatistics) {
        HashSet<String> tenantIds = new HashSet<String>();
        for (ProcessDefinitionStatistics statistics : processDefinitionStatistics) {
            tenantIds.add(statistics.getTenantId());
        }
        return tenantIds;
    }
}

