/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CamundaUserTaskFormFieldBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyHistoricDetailFormPropertyQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() throws IOException {
        BpmnModelInstance oneTaskProcess = ((UserTaskBuilder)((CamundaUserTaskFormFieldBuilder)((CamundaUserTaskFormFieldBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("userTask").camundaFormField().camundaId("myFormField")).camundaType("string")).camundaFormFieldDone()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{oneTaskProcess});
        ProcessInstance processInstanceOne = this.startProcessInstanceForTenant(TENANT_ONE);
        ProcessInstance processInstanceTwo = this.startProcessInstanceForTenant(TENANT_TWO);
        this.completeUserTask(processInstanceOne);
        this.completeUserTask(processInstanceTwo);
    }

    public void testQueryWithoutTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{null});
            MultiTenancyHistoricDetailFormPropertyQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formFields().orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicDetails.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formFields().orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicDetails.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }

    protected void completeUserTask(ProcessInstance processInstance) {
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertThat((Object)task, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("myFormField", "myFormFieldValue");
        this.formService.submitTaskForm(task.getId(), properties);
    }
}

