/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyHistoricJobLogQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String BPMN = "org/camunda/bpm/engine/test/api/multitenancy/failingTask.bpmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deploymentForTenant(TENANT_ONE, new String[]{BPMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{BPMN});
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_ONE);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_TWO);
    }

    public void testQueryWithoutTenantId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
    }

    public void testQueryByTenantId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.historyService.createHistoricJobLogQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantIds() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricJobLogQuery().tenantIdIn(new String[]{null});
            MultiTenancyHistoricJobLogQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicJobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicJobLogs.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List historicJobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicJobLogs.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricJobLog)historicJobLogs.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    protected void startProcessInstanceAndExecuteFailingJobForTenant(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Job job = (Job)this.managementService.createJobQuery().processDefinitionId(processDefinitionId).singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }
}

