/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import java.util.Calendar;
import java.util.Date;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyJobDefinitionSuspensionStateTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().camundaAsyncBefore()).endEvent().done();

    protected void setUp() throws Exception {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.deployment(new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    public void testSuspendAndActivateJobDefinitionsForAllTenants() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendJobDefinitionForTenant() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendJobDefinitionForNonTenant() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateJobDefinitionForTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testJobProcessDefinitionForNonTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendAndActivateJobDefinitionsIncludingJobsForAllTenants() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendJobDefinitionIncludingJobsForTenant() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeJobs(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendJobDefinitionIncludingJobsForNonTenant() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeJobs(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateJobDefinitionIncludingJobsForTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).suspend();
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeJobs(true).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateJobDefinitionIncludingJobsForNonTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).suspend();
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeJobs(true).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedSuspendJobDefinitionsForAllTenants() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testDelayedSuspendJobDefinitionsForTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedSuspendJobDefinitionsForNonTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedActivateJobDefinitionsForAllTenants() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).activate();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testDelayedActivateJobDefinitionsForTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).activate();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedActivateJobDefinitionsForNonTenant() {
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).activate();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    protected Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        return calendar.getTime();
    }

    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-job-definition");
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-job-definition");
                return null;
            }
        });
    }
}

