/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyJobSuspensionStateTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done();

    protected void setUp() throws Exception {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.deployment(new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    public void testSuspendAndActivateJobsForAllTenants() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendJobForTenant() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendJobsForNonTenant() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateJobsForTenant() {
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateJobsForNonTenant() {
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }
}

