/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import java.util.Calendar;
import java.util.Date;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderProcessInstanceContext;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessDefinitionSuspensionStateTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().camundaAsyncBefore()).endEvent().done();

    protected void setUp() throws Exception {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.deployment(new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    public void testSuspendAndActivateProcessDefinitionsForAllTenants() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendProcessDefinitionForTenant() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessDefinitionForNonTenant() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessDefinitionForTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessDefinitionForNonTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendAndActivateProcessDefinitionsIncludeInstancesForAllTenants() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendProcessDefinitionIncludeInstancesForTenant() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeProcessInstances(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessDefinitionIncludeInstancesForNonTenant() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeProcessInstances(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessDefinitionIncludeInstancesForTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeProcessInstances(true).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessDefinitionIncludeInstancesForNonTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeProcessInstances(true).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedSuspendProcessDefinitionsForAllTenants() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).suspend();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testDelayedSuspendProcessDefinitionsForTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).suspend();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedSuspendProcessDefinitionsForNonTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).suspend();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedActivateProcessDefinitionsForAllTenants() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).activate();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testDelayedActivateProcessDefinitionsForTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).activate();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDelayedActivateProcessDefinitionsForNonTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).activate();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Job job = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(job.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessDefinitionIncludingJobDefinitionsForAllTenants() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testSuspendProcessDefinitionIncludingJobDefinitionsForTenant() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessDefinitionIncludingJobDefinitionsForNonTenant() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessDefinitionIncludingJobDefinitionsForAllTenants() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testActivateProcessDefinitionIncludingJobDefinitionsForTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessDefinitionIncludingJobDefinitionsForNonTenant() {
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessDefinitionByIdIncludeInstancesFromAllTenants() {
        TestTenantIdProvider tenantIdProvider = new TestTenantIdProvider();
        this.processEngineConfiguration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
        tenantIdProvider.tenantId = TENANT_ONE;
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        tenantIdProvider.tenantId = TENANT_TWO;
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().withoutTenantId().singleResult();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).includeProcessInstances(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testActivateProcessDefinitionByIdIncludeInstancesFromAllTenants() {
        TestTenantIdProvider tenantIdProvider = new TestTenantIdProvider();
        this.processEngineConfiguration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
        tenantIdProvider.tenantId = TENANT_ONE;
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        tenantIdProvider.tenantId = TENANT_TWO;
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().withoutTenantId().singleResult();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).includeProcessInstances(true).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        return calendar.getTime();
    }

    public void tearDown() throws Exception {
        this.processEngineConfiguration.setTenantIdProvider(null);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-processdefinition");
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                return null;
            }
        });
    }

    protected class TestTenantIdProvider
    implements TenantIdProvider {
        protected String tenantId;

        protected TestTenantIdProvider() {
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return this.tenantId;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return this.tenantId;
        }
    }
}

