/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SendTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessInstanceSuspensionStateTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((BoundaryEventBuilder)((SendTaskBuilder)((SendTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().parallelGateway("fork").userTask().moveToLastGateway().sendTask().camundaType("external")).camundaTopic("test")).boundaryEvent().timerWithDuration("PT1M")).done();

    protected void setUp() throws Exception {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.deployment(new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    public void testSuspendAndActivateProcessInstancesForAllTenants() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendProcessInstanceForTenant() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessInstanceForNonTenant() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessInstanceForTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessInstanceForNonTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendAndActivateProcessInstancesIncludingUserTasksForAllTenants() {
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendProcessInstanceIncludingUserTaskForTenant() {
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessInstanceIncludingUserTaskForNonTenant() {
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessInstanceIncludingUserTaskForTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessInstanceIncludingUserTaskForNonTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendAndActivateProcessInstancesIncludingExternalTasksForAllTenants() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendProcessInstanceIncludingExternalTaskForTenant() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessInstanceIncludingExternalTaskForNonTenant() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ExternalTask)query.suspended().singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testActivateProcessInstanceIncludingExternalTaskForTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessInstanceIncludingExternalTaskForNonTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ExternalTask)query.active().singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testSuspendAndActivateProcessInstancesIncludingJobsForAllTenants() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testSuspendProcessInstanceIncludingJobForTenant() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSuspendProcessInstanceIncludingJobForNonTenant() {
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Job)query.suspended().singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testActivateProcessInstanceIncludingJobForTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testActivateProcessInstanceIncludingJobForNonTenant() {
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Job)query.active().singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

