/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.test.api.repository.AbstractDefinitionQueryTest;

public class DecisionDefinitionQueryTest
extends AbstractDefinitionQueryTest {
    @Override
    protected String getResourceOnePath() {
        return "org/camunda/bpm/engine/test/repository/one.dmn";
    }

    @Override
    protected String getResourceTwoPath() {
        return "org/camunda/bpm/engine/test/repository/two.dmn";
    }

    public void testDecisionDefinitionProperties() {
        List decisionDefinitions = ((DecisionDefinitionQuery)((DecisionDefinitionQuery)((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionName().asc()).orderByDecisionDefinitionVersion().asc()).orderByDecisionDefinitionCategory().asc()).list();
        DecisionDefinition decisionDefinition = (DecisionDefinition)decisionDefinitions.get(0);
        DecisionDefinitionQueryTest.assertEquals((String)"one", (String)decisionDefinition.getKey());
        DecisionDefinitionQueryTest.assertEquals((String)"One", (String)decisionDefinition.getName());
        DecisionDefinitionQueryTest.assertTrue((boolean)decisionDefinition.getId().startsWith("one:1"));
        DecisionDefinitionQueryTest.assertEquals((String)"Examples", (String)decisionDefinition.getCategory());
        DecisionDefinitionQueryTest.assertEquals((int)1, (int)decisionDefinition.getVersion());
        DecisionDefinitionQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/one.dmn", (String)decisionDefinition.getResourceName());
        DecisionDefinitionQueryTest.assertEquals((String)this.deploymentOneId, (String)decisionDefinition.getDeploymentId());
        decisionDefinition = (DecisionDefinition)decisionDefinitions.get(1);
        DecisionDefinitionQueryTest.assertEquals((String)"one", (String)decisionDefinition.getKey());
        DecisionDefinitionQueryTest.assertEquals((String)"One", (String)decisionDefinition.getName());
        DecisionDefinitionQueryTest.assertTrue((boolean)decisionDefinition.getId().startsWith("one:2"));
        DecisionDefinitionQueryTest.assertEquals((String)"Examples", (String)decisionDefinition.getCategory());
        DecisionDefinitionQueryTest.assertEquals((int)2, (int)decisionDefinition.getVersion());
        DecisionDefinitionQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/one.dmn", (String)decisionDefinition.getResourceName());
        DecisionDefinitionQueryTest.assertEquals((String)this.deploymentTwoId, (String)decisionDefinition.getDeploymentId());
        decisionDefinition = (DecisionDefinition)decisionDefinitions.get(2);
        DecisionDefinitionQueryTest.assertEquals((String)"two", (String)decisionDefinition.getKey());
        DecisionDefinitionQueryTest.assertEquals((String)"Two", (String)decisionDefinition.getName());
        DecisionDefinitionQueryTest.assertTrue((boolean)decisionDefinition.getId().startsWith("two:1"));
        DecisionDefinitionQueryTest.assertEquals((String)"Examples2", (String)decisionDefinition.getCategory());
        DecisionDefinitionQueryTest.assertEquals((int)1, (int)decisionDefinition.getVersion());
        DecisionDefinitionQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/two.dmn", (String)decisionDefinition.getResourceName());
        DecisionDefinitionQueryTest.assertEquals((String)this.deploymentOneId, (String)decisionDefinition.getDeploymentId());
    }

    public void testQueryByDecisionDefinitionIds() {
        DecisionDefinitionQueryTest.assertTrue((boolean)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionIdIn(new String[]{"a", "b"}).list().isEmpty());
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().list();
        ArrayList<String> ids = new ArrayList<String>();
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            ids.add(decisionDefinition.getId());
        }
        decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionIdIn(ids.toArray(new String[ids.size()])).list();
        DecisionDefinitionQueryTest.assertEquals((int)ids.size(), (int)decisionDefinitions.size());
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            if (ids.contains(decisionDefinition.getId())) continue;
            DecisionDefinitionQueryTest.fail((String)("Expected to find decision definition " + decisionDefinition));
        }
    }

    public void testQueryByDeploymentId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.deploymentId(this.deploymentOneId);
        this.verifyQueryResults((Query)query, 2);
    }

    public void testQueryByInvalidDeploymentId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.deploymentId("invalid");
        this.verifyQueryResults((Query)query, 0);
        try {
            query.deploymentId(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionName("Two");
        this.verifyQueryResults((Query)query, 1);
        query.decisionDefinitionName("One");
        this.verifyQueryResults((Query)query, 2);
    }

    public void testQueryByInvalidName() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionName("invalid");
        this.verifyQueryResults((Query)query, 0);
        try {
            query.decisionDefinitionName(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionNameLike("%w%");
        this.verifyQueryResults((Query)query, 1);
    }

    public void testQueryByInvalidNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionNameLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
        try {
            query.decisionDefinitionNameLike(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKey("one");
        this.verifyQueryResults((Query)query, 2);
        query.decisionDefinitionKey("two");
        this.verifyQueryResults((Query)query, 1);
    }

    public void testQueryByInvalidKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKey("invalid");
        this.verifyQueryResults((Query)query, 0);
        try {
            query.decisionDefinitionKey(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByKeyLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKeyLike("%o%");
        this.verifyQueryResults((Query)query, 3);
    }

    public void testQueryByInvalidKeyLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKeyLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
        try {
            query.decisionDefinitionKeyLike(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByCategory() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategory("Examples");
        this.verifyQueryResults((Query)query, 2);
    }

    public void testQueryByInvalidCategory() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategory("invalid");
        this.verifyQueryResults((Query)query, 0);
        try {
            query.decisionDefinitionCategory(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByCategoryLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategoryLike("%Example%");
        this.verifyQueryResults((Query)query, 3);
        query.decisionDefinitionCategoryLike("%amples2");
        this.verifyQueryResults((Query)query, 1);
    }

    public void testQueryByInvalidCategoryLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategoryLike("invalid");
        this.verifyQueryResults((Query)query, 0);
        try {
            query.decisionDefinitionCategoryLike(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByVersion() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults((Query)query, 1);
        query.decisionDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults((Query)query, 2);
    }

    public void testQueryByInvalidVersion() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults((Query)query, 0);
        try {
            query.decisionDefinitionVersion(Integer.valueOf(-1));
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionVersion(null);
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQueryByLatest() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.latestVersion();
        this.verifyQueryResults((Query)query, 2);
        query.decisionDefinitionKey("one").latestVersion();
        this.verifyQueryResults((Query)query, 1);
        query.decisionDefinitionKey("two").latestVersion();
        this.verifyQueryResults((Query)query, 1);
    }

    public void testInvalidUsageOfLatest() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        try {
            query.decisionDefinitionId("test").latestVersion().list();
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionName("test").latestVersion().list();
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionNameLike("test").latestVersion().list();
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionVersion(Integer.valueOf(1)).latestVersion().list();
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.deploymentId("test").latestVersion().list();
            DecisionDefinitionQueryTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testQuerySorting() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionId().asc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDeploymentId().asc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionKey().asc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionVersion().asc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionId().desc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDeploymentId().desc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionKey().desc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionVersion().desc();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createDecisionDefinitionQuery();
        ((DecisionDefinitionQuery)query.orderByDecisionDefinitionKey().asc()).orderByDecisionDefinitionVersion().desc();
        List decisionDefinitions = query.list();
        DecisionDefinitionQueryTest.assertEquals((int)3, (int)decisionDefinitions.size());
        DecisionDefinitionQueryTest.assertEquals((String)"one", (String)((DecisionDefinition)decisionDefinitions.get(0)).getKey());
        DecisionDefinitionQueryTest.assertEquals((int)2, (int)((DecisionDefinition)decisionDefinitions.get(0)).getVersion());
        DecisionDefinitionQueryTest.assertEquals((String)"one", (String)((DecisionDefinition)decisionDefinitions.get(1)).getKey());
        DecisionDefinitionQueryTest.assertEquals((int)1, (int)((DecisionDefinition)decisionDefinitions.get(1)).getVersion());
        DecisionDefinitionQueryTest.assertEquals((String)"two", (String)((DecisionDefinition)decisionDefinitions.get(2)).getKey());
        DecisionDefinitionQueryTest.assertEquals((int)1, (int)((DecisionDefinition)decisionDefinitions.get(2)).getVersion());
    }
}

