/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MultiInstanceProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationAddMultiInstanceTest {
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testAddMultiInstanceBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity 'userTask' is a descendant of multi-instance body 'userTask#multiInstanceBody' that is not migrated from the source process definition");
        }
    }

    @Test
    public void testRemoveAndAddMultiInstanceBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity 'userTask' is a descendant of multi-instance body 'userTask#multiInstanceBody' that is not migrated from the source process definition");
        }
    }

    @Test
    public void testAddMultiInstanceBodyWithDeeperNestedMapping() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_SUBPROCESS_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            e.printStackTrace();
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity 'userTask' is a descendant of multi-instance body 'subProcess#multiInstanceBody' that is not migrated from the source process definition");
        }
    }
}

