/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationEventSubProcessTest {
    public static final String IN_EVENT_SUB_PROCESS_TASK = "inEventSubProcessTask";
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMapUserTaskSiblingOfMessageEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").message(MESSAGE_NAME)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubscriptionRemoved("eventStart", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionCreated("eventStart", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfMessageEventSubProcessAndTriggerMessage() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").message(MESSAGE_NAME)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfSignalEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").signal(SIGNAL_NAME)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubscriptionRemoved("eventStart", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionCreated("eventStart", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfSignalEventSubProcessAndSendSignal() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").signal(SIGNAL_NAME)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfTimerEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").timerWithDate(TIMER_DATE)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubProcessTimerJobRemoved("eventStart");
        this.testHelper.assertEventSubProcessTimerJobCreated("eventStart");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfTimerEventSubProcessAndTriggerTimer() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").timerWithDate(TIMER_DATE)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }
}

